/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureParser;
import com.android.tools.profilers.cpu.CpuProfilerNotifications;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.cpu.StatusPanelModel;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCaptureHandler
implements Updatable,
StatusPanelModel {
    @NotNull
    private final CpuCaptureParser myCaptureParser;
    @NotNull
    private Range myParseRange;
    @NotNull
    private final IdeProfilerServices myServices;
    @NotNull
    private final ProfilingConfiguration myConfiguration;
    @NotNull
    private final File myCaptureFile;
    private boolean myIsParsing;
    private final boolean myIsImportedTrace;

    public CpuCaptureHandler(@NotNull IdeProfilerServices services, @NotNull File captureFile, @NotNull ProfilingConfiguration configuration, @Nullable String captureProcessNameHint, int captureProcessIdHint) {
        if (services == null) {
            CpuCaptureHandler.$$$reportNull$$$0(0);
        }
        if (captureFile == null) {
            CpuCaptureHandler.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            CpuCaptureHandler.$$$reportNull$$$0(2);
        }
        this.myParseRange = new Range();
        this.myIsParsing = false;
        this.myCaptureParser = new CpuCaptureParser(services);
        this.myCaptureParser.setProcessNameHint(captureProcessNameHint, captureProcessIdHint);
        this.myCaptureFile = captureFile;
        this.myServices = services;
        this.myConfiguration = configuration;
        this.myIsImportedTrace = captureProcessIdHint == 0;
        this.myCaptureParser.trackCaptureMetadata(42L, new CpuCaptureMetadata(configuration));
    }

    @Override
    @NotNull
    public Range getRange() {
        Range range = this.myParseRange;
        if (range == null) {
            CpuCaptureHandler.$$$reportNull$$$0(3);
        }
        return range;
    }

    @Override
    @NotNull
    public String getConfigurationText() {
        String string = this.myConfiguration.getName();
        if (string == null) {
            CpuCaptureHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void abort() {
        this.myCaptureParser.abortParsing();
    }

    public void update(long elapsedNs) {
        if (this.myIsParsing) {
            this.myParseRange.setMax(this.myParseRange.getMax() + (double)elapsedNs);
        }
    }

    public void parse(Consumer<CpuCapture> captureCompleted) {
        this.myIsParsing = true;
        this.myParseRange.set(0.0, 0.0);
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.parse(this.myCaptureFile, this.myIsImportedTrace);
        if (capture == null) {
            this.myServices.showNotification(CpuProfilerNotifications.IMPORT_TRACE_PARSING_FAILURE);
            captureCompleted.accept(null);
            return;
        }
        capture.handleAsync((parsedCapture, exception) -> {
            if (capture.isCancelled()) {
                this.myServices.showNotification(CpuProfilerNotifications.IMPORT_TRACE_PARSING_ABORTED);
            } else if (parsedCapture == null) {
                this.myServices.showNotification(CpuProfilerNotifications.IMPORT_TRACE_PARSING_FAILURE);
            }
            this.myIsParsing = false;
            captureCompleted.accept((CpuCapture)parsedCapture);
            return parsedCapture;
        }, this.myServices.getMainExecutor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

