/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.ProfilingTechnology;
import com.android.tools.profilers.sessions.SessionArtifact;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CpuCaptureSessionArtifact
implements SessionArtifact<Cpu.CpuTraceInfo> {
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final Common.SessionMetaData mySessionMetaData;
    @NotNull
    private final Cpu.CpuTraceInfo myInfo;
    private final boolean myIsOngoingCapture;

    public CpuCaptureSessionArtifact(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData, @NotNull Cpu.CpuTraceInfo info) {
        if (profilers == null) {
            CpuCaptureSessionArtifact.$$$reportNull$$$0(0);
        }
        if (session == null) {
            CpuCaptureSessionArtifact.$$$reportNull$$$0(1);
        }
        if (sessionMetaData == null) {
            CpuCaptureSessionArtifact.$$$reportNull$$$0(2);
        }
        if (info == null) {
            CpuCaptureSessionArtifact.$$$reportNull$$$0(3);
        }
        this.myProfilers = profilers;
        this.mySession = session;
        this.mySessionMetaData = sessionMetaData;
        this.myInfo = info;
        this.myIsOngoingCapture = info.getToTimestamp() == -1L;
    }

    @Override
    @NotNull
    public Cpu.CpuTraceInfo getArtifactProto() {
        Cpu.CpuTraceInfo cpuTraceInfo = this.myInfo;
        if (cpuTraceInfo == null) {
            CpuCaptureSessionArtifact.$$$reportNull$$$0(4);
        }
        return cpuTraceInfo;
    }

    @Override
    @NotNull
    public StudioProfilers getProfilers() {
        StudioProfilers studioProfilers = this.myProfilers;
        if (studioProfilers == null) {
            CpuCaptureSessionArtifact.$$$reportNull$$$0(5);
        }
        return studioProfilers;
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        Common.Session session = this.mySession;
        if (session == null) {
            CpuCaptureSessionArtifact.$$$reportNull$$$0(6);
        }
        return session;
    }

    @Override
    @NotNull
    public Common.SessionMetaData getSessionMetaData() {
        Common.SessionMetaData sessionMetaData = this.mySessionMetaData;
        if (sessionMetaData == null) {
            CpuCaptureSessionArtifact.$$$reportNull$$$0(7);
        }
        return sessionMetaData;
    }

    @Override
    @NotNull
    public String getName() {
        Cpu.CpuTraceConfiguration.UserOptions options = this.myInfo.getConfiguration().getUserOptions();
        String string = ProfilingTechnology.fromTypeAndMode(options.getTraceType(), options.getTraceMode()).getName();
        if (string == null) {
            CpuCaptureSessionArtifact.$$$reportNull$$$0(8);
        }
        return string;
    }

    public String getSubtitle() {
        if (this.myIsOngoingCapture) {
            return "Recording...";
        }
        if (this.isImportedSession()) {
            return TimeFormatter.getLocalizedDateTime((long)TimeUnit.NANOSECONDS.toMillis(this.mySession.getStartTimestamp()));
        }
        return TimeFormatter.getFullClockString((long)TimeUnit.NANOSECONDS.toMicros(this.getTimestampNs()));
    }

    @Override
    public long getTimestampNs() {
        if (this.isImportedSession()) {
            return 0L;
        }
        return this.myInfo.getFromTimestamp() - this.mySession.getStartTimestamp();
    }

    @Override
    public void onSelect() {
        boolean needsToOpenCpuProfiler;
        boolean needsToChangeSession;
        boolean bl = needsToChangeSession = this.mySession != this.myProfilers.getSession();
        if (needsToChangeSession) {
            this.myProfilers.getSessionsManager().setSession(this.mySession);
        }
        if (this.isImportedSession()) {
            return;
        }
        boolean bl2 = needsToOpenCpuProfiler = !(this.myProfilers.getStage() instanceof CpuProfilerStage);
        if (needsToOpenCpuProfiler) {
            this.myProfilers.setStage(new CpuProfilerStage(this.myProfilers));
        }
        if (this.myIsOngoingCapture) {
            SessionArtifact.navigateTimelineToOngoingCapture(this.myProfilers.getTimeline(), TimeUnit.NANOSECONDS.toMicros(this.myInfo.getFromTimestamp()));
        } else {
            assert (this.myProfilers.getStage() instanceof CpuProfilerStage);
            ((CpuProfilerStage)this.myProfilers.getStage()).setAndSelectCapture(this.myInfo.getTraceId());
        }
        this.myProfilers.getIdeServices().getFeatureTracker().trackSessionArtifactSelected(this, this.myProfilers.getSessionsManager().isSessionAlive());
    }

    @Override
    public boolean isOngoing() {
        return this.myIsOngoingCapture;
    }

    @Override
    public boolean canExport() {
        return !this.isOngoing();
    }

    @Override
    public void export(@NotNull OutputStream outputStream) {
        if (outputStream == null) {
            CpuCaptureSessionArtifact.$$$reportNull$$$0(9);
        }
        assert (this.canExport());
        CpuProfiler.saveCaptureToFile(this.myProfilers, this.getArtifactProto(), outputStream);
    }

    private boolean isImportedSession() {
        return this.mySessionMetaData.getType() == Common.SessionMetaData.SessionType.CPU_CAPTURE;
    }

    public static List<SessionArtifact> getSessionArtifacts(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData) {
        if (profilers == null) {
            CpuCaptureSessionArtifact.$$$reportNull$$$0(10);
        }
        if (session == null) {
            CpuCaptureSessionArtifact.$$$reportNull$$$0(11);
        }
        if (sessionMetaData == null) {
            CpuCaptureSessionArtifact.$$$reportNull$$$0(12);
        }
        Range requestRange = new Range();
        if (sessionMetaData.getType() == Common.SessionMetaData.SessionType.FULL) {
            requestRange.set((double)TimeUnit.NANOSECONDS.toMicros(session.getStartTimestamp()), (double)TimeUnit.NANOSECONDS.toMicros(session.getEndTimestamp()));
        } else {
            requestRange.set(-9.223372036854776E18, 9.223372036854776E18);
        }
        List<Cpu.CpuTraceInfo> traceInfoList = CpuProfiler.getTraceInfoFromRange(profilers.getClient(), session, requestRange, profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled());
        ArrayList<SessionArtifact> artifacts = new ArrayList<SessionArtifact>();
        for (Cpu.CpuTraceInfo info : traceInfoList) {
            artifacts.add(new CpuCaptureSessionArtifact(profilers, session, sessionMetaData, info));
        }
        return artifacts;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionMetaData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureSessionArtifact";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureSessionArtifact";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactProto";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionMetaData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSessionArtifacts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

