/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DefaultTimeline;
import com.android.tools.adtui.model.MultiSelectionModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.event.EventModel;
import com.android.tools.adtui.model.event.LifecycleEventModel;
import com.android.tools.adtui.model.event.UserEvent;
import com.android.tools.adtui.model.trackgroup.TrackGroupModel;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.EventStreamServer;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerTrackRendererType;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.AtraceDataSeries;
import com.android.tools.profilers.cpu.CaptureThreadComparator;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureHandler;
import com.android.tools.profilers.cpu.CpuCaptureMinimapModel;
import com.android.tools.profilers.cpu.CpuCoreTrackModel;
import com.android.tools.profilers.cpu.CpuFramesModel;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.CpuThreadTrackModel;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalyzable;
import com.android.tools.profilers.cpu.analysis.CpuFullTraceAnalysisModel;
import com.android.tools.profilers.cpu.atrace.AtraceCpuCapture;
import com.android.tools.profilers.cpu.atrace.AtraceFrame;
import com.android.tools.profilers.cpu.atrace.CpuFrameTooltip;
import com.android.tools.profilers.cpu.atrace.CpuKernelTooltip;
import com.android.tools.profilers.cpu.atrace.CpuThreadSliceInfo;
import com.android.tools.profilers.event.LifecycleEventDataSeries;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.UserEventDataSeries;
import com.android.tools.profilers.event.UserEventTooltip;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCaptureStage
extends Stage<Timeline> {
    private final CpuCaptureHandler myCpuCaptureHandler;
    private final AspectModel<Aspect> myAspect;
    private final List<CpuAnalysisModel> myAnalysisModels;
    private final List<TrackGroupModel> myTrackGroupModels;
    private final MultiSelectionModel<CpuAnalyzable> myMultiSelectionModel;
    private CpuCaptureMinimapModel myMinimapModel;
    private State myState;
    private CpuCapture myCapture;
    private final Timeline myTrackGroupTimeline;

    @NotNull
    public static File saveCapture(long traceId, ByteString data) {
        File file;
        try {
            File trace = FileUtil.createTempFile((String)String.format(Locale.US, "cpu_trace_%d", traceId), (String)".trace", (boolean)true);
            try (FileOutputStream out = new FileOutputStream(trace);){
                out.write(data.toByteArray());
            }
            file = trace;
        }
        catch (IOException io) {
            throw new IllegalStateException("Unable to save trace to disk");
        }
        if (file == null) {
            CpuCaptureStage.$$$reportNull$$$0(0);
        }
        return file;
    }

    @Nullable
    private static File getAndSaveCapture(@NotNull StudioProfilers profilers, long traceId) {
        if (profilers == null) {
            CpuCaptureStage.$$$reportNull$$$0(1);
        }
        Transport.BytesRequest traceRequest = Transport.BytesRequest.newBuilder().setStreamId(profilers.getSession().getStreamId()).setId(String.valueOf(traceId)).build();
        Transport.BytesResponse traceResponse = profilers.getClient().getTransportClient().getBytes(traceRequest);
        if (!traceResponse.getContents().isEmpty()) {
            return CpuCaptureStage.saveCapture(traceId, traceResponse.getContents());
        }
        return null;
    }

    @Nullable
    public static CpuCaptureStage create(@NotNull StudioProfilers profilers, @NotNull ProfilingConfiguration configuration, long traceId) {
        File captureFile;
        if (profilers == null) {
            CpuCaptureStage.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            CpuCaptureStage.$$$reportNull$$$0(3);
        }
        if ((captureFile = CpuCaptureStage.getAndSaveCapture(profilers, traceId)) == null) {
            return null;
        }
        String captureProcessNameHint = CpuProfiler.getTraceInfoFromId(profilers, traceId).getConfiguration().getAppName();
        return new CpuCaptureStage(profilers, configuration, captureFile, captureProcessNameHint, profilers.getSession().getPid());
    }

    @NotNull
    public static CpuCaptureStage create(@NotNull StudioProfilers profilers, @NotNull ProfilingConfiguration configuration, @NotNull File captureFile) {
        if (profilers == null) {
            CpuCaptureStage.$$$reportNull$$$0(4);
        }
        if (configuration == null) {
            CpuCaptureStage.$$$reportNull$$$0(5);
        }
        if (captureFile == null) {
            CpuCaptureStage.$$$reportNull$$$0(6);
        }
        return new CpuCaptureStage(profilers, configuration, captureFile, null, 0);
    }

    @VisibleForTesting
    CpuCaptureStage(@NotNull StudioProfilers profilers, @NotNull ProfilingConfiguration configuration, @NotNull File captureFile, @Nullable String captureProcessNameHint, int captureProcessIdHint) {
        if (profilers == null) {
            CpuCaptureStage.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            CpuCaptureStage.$$$reportNull$$$0(8);
        }
        if (captureFile == null) {
            CpuCaptureStage.$$$reportNull$$$0(9);
        }
        super(profilers);
        this.myAspect = new AspectModel();
        this.myAnalysisModels = new ArrayList<CpuAnalysisModel>();
        this.myTrackGroupModels = new ArrayList<TrackGroupModel>();
        this.myMultiSelectionModel = new MultiSelectionModel();
        this.myState = State.PARSING;
        this.myTrackGroupTimeline = new DefaultTimeline();
        this.myCpuCaptureHandler = new CpuCaptureHandler(profilers.getIdeServices(), captureFile, configuration, captureProcessNameHint, captureProcessIdHint);
    }

    public State getState() {
        return this.myState;
    }

    @NotNull
    public AspectModel<Aspect> getAspect() {
        AspectModel<Aspect> aspectModel = this.myAspect;
        if (aspectModel == null) {
            CpuCaptureStage.$$$reportNull$$$0(10);
        }
        return aspectModel;
    }

    @NotNull
    public CpuCaptureHandler getCaptureHandler() {
        CpuCaptureHandler cpuCaptureHandler = this.myCpuCaptureHandler;
        if (cpuCaptureHandler == null) {
            CpuCaptureStage.$$$reportNull$$$0(11);
        }
        return cpuCaptureHandler;
    }

    @NotNull
    public List<TrackGroupModel> getTrackGroupModels() {
        List<TrackGroupModel> list = this.myTrackGroupModels;
        if (list == null) {
            CpuCaptureStage.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public MultiSelectionModel<CpuAnalyzable> getMultiSelectionModel() {
        MultiSelectionModel<CpuAnalyzable> multiSelectionModel = this.myMultiSelectionModel;
        if (multiSelectionModel == null) {
            CpuCaptureStage.$$$reportNull$$$0(13);
        }
        return multiSelectionModel;
    }

    @NotNull
    public CpuCaptureMinimapModel getMinimapModel() {
        assert (this.myState == State.ANALYZING);
        CpuCaptureMinimapModel cpuCaptureMinimapModel = this.myMinimapModel;
        if (cpuCaptureMinimapModel == null) {
            CpuCaptureStage.$$$reportNull$$$0(14);
        }
        return cpuCaptureMinimapModel;
    }

    @NotNull
    public List<CpuAnalysisModel> getAnalysisModels() {
        List<CpuAnalysisModel> list = this.myAnalysisModels;
        if (list == null) {
            CpuCaptureStage.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public Timeline getCaptureTimeline() {
        Timeline timeline = this.getCapture().getTimeline();
        if (timeline == null) {
            CpuCaptureStage.$$$reportNull$$$0(16);
        }
        return timeline;
    }

    @Override
    @NotNull
    public Timeline getTimeline() {
        Timeline timeline = this.myTrackGroupTimeline;
        if (timeline == null) {
            CpuCaptureStage.$$$reportNull$$$0(17);
        }
        return timeline;
    }

    private void setState(State state) {
        this.myState = state;
        this.myAspect.changed((Enum)Aspect.STATE);
    }

    @NotNull
    public CpuCapture getCapture() {
        assert (this.myState == State.ANALYZING);
        CpuCapture cpuCapture = this.myCapture;
        if (cpuCapture == null) {
            CpuCaptureStage.$$$reportNull$$$0(18);
        }
        return cpuCapture;
    }

    @Override
    public void enter() {
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuCaptureHandler);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(((Object)((Object)this)).getClass());
        this.myCpuCaptureHandler.parse(capture -> {
            try {
                if (capture == null) {
                    this.getStudioProfilers().getIdeServices().getMainExecutor().execute(() -> this.getStudioProfilers().setStage(new CpuProfilerStage(this.getStudioProfilers())));
                } else {
                    this.myCapture = capture;
                    this.onCaptureParsed((CpuCapture)capture);
                    this.setState(State.ANALYZING);
                }
            }
            catch (Exception ex) {
                Logger.getInstance(CpuCaptureStage.class).error((Throwable)ex);
            }
        });
    }

    @Override
    public void exit() {
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuCaptureHandler);
    }

    public void addCpuAnalysisModel(@NotNull CpuAnalysisModel model) {
        if (model == null) {
            CpuCaptureStage.$$$reportNull$$$0(19);
        }
        this.myAnalysisModels.add(model);
        this.myAspect.changed((Enum)Aspect.ANALYSIS_MODEL_UPDATED);
    }

    public void removeCpuAnalysisModel(int index) {
        this.myAnalysisModels.remove(index);
        this.myAspect.changed((Enum)Aspect.ANALYSIS_MODEL_UPDATED);
    }

    private void onCaptureParsed(@NotNull CpuCapture capture) {
        if (capture == null) {
            CpuCaptureStage.$$$reportNull$$$0(20);
        }
        this.myTrackGroupTimeline.getDataRange().set(capture.getRange());
        this.myMinimapModel = new CpuCaptureMinimapModel(this.getStudioProfilers(), capture, this.myTrackGroupTimeline.getViewRange());
        this.initTrackGroupList(this.myMinimapModel.getRangeSelectionModel().getSelectionRange(), capture);
        this.addCpuAnalysisModel(new CpuFullTraceAnalysisModel(capture, this.myMinimapModel.getRangeSelectionModel().getSelectionRange()));
        if (this.getStudioProfilers().getSession().getPid() == 0) {
            this.insertImportedTraceEvent(capture);
        }
    }

    private void insertImportedTraceEvent(@NotNull CpuCapture capture) {
        if (capture == null) {
            CpuCaptureStage.$$$reportNull$$$0(21);
        }
        Cpu.CpuTraceInfo importedTraceInfo = Cpu.CpuTraceInfo.newBuilder().setTraceId(42L).setFromTimestamp(TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMin())).setToTimestamp(TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMax())).setConfiguration(Cpu.CpuTraceConfiguration.newBuilder().setUserOptions(Cpu.CpuTraceConfiguration.UserOptions.newBuilder().setTraceType(capture.getType()))).build();
        EventStreamServer streamServer = this.getStudioProfilers().getSessionsManager().getEventStreamServer(this.getStudioProfilers().getSession().getStreamId());
        if (streamServer != null) {
            streamServer.getEventDeque().offer(Common.Event.newBuilder().setGroupId(importedTraceInfo.getTraceId()).setTimestamp(importedTraceInfo.getToTimestamp()).setIsEnded(true).setKind(Common.Event.Kind.CPU_TRACE).setCpuTrace(Cpu.CpuTraceData.newBuilder().setTraceEnded(Cpu.CpuTraceData.TraceEnded.newBuilder().setTraceInfo(importedTraceInfo))).build());
        }
    }

    private void initTrackGroupList(@NotNull Range selectionRange, @NotNull CpuCapture capture) {
        if (selectionRange == null) {
            CpuCaptureStage.$$$reportNull$$$0(22);
        }
        if (capture == null) {
            CpuCaptureStage.$$$reportNull$$$0(23);
        }
        this.myTrackGroupModels.clear();
        if (this.getStudioProfilers().getSession().getPid() != 0) {
            this.myTrackGroupModels.add(this.createInteractionTrackGroup(selectionRange));
        }
        if (capture instanceof AtraceCpuCapture) {
            this.myTrackGroupModels.add(this.createDisplayTrackGroup(selectionRange, (AtraceCpuCapture)capture));
            this.myTrackGroupModels.add(this.createCpuCoresTrackGroup(selectionRange, (AtraceCpuCapture)capture));
        }
        this.myTrackGroupModels.add(this.createThreadsTrackGroup(selectionRange, capture));
    }

    private TrackGroupModel createInteractionTrackGroup(@NotNull Range selectionRange) {
        if (selectionRange == null) {
            CpuCaptureStage.$$$reportNull$$$0(24);
        }
        TrackGroupModel interaction = TrackGroupModel.newBuilder().setTitle("Interaction").build();
        EventModel userEventEventModel = new EventModel(new RangedSeries(selectionRange, (DataSeries)new UserEventDataSeries(this.getStudioProfilers())));
        LifecycleEventModel lifecycleEventModel = new LifecycleEventModel(new RangedSeries(selectionRange, (DataSeries)new LifecycleEventDataSeries(this.getStudioProfilers(), false)), new RangedSeries(selectionRange, (DataSeries)new LifecycleEventDataSeries(this.getStudioProfilers(), true)));
        interaction.addTrackModel(TrackModel.newBuilder((Object)userEventEventModel, (Enum)ProfilerTrackRendererType.USER_INTERACTION, (String)"User").setDefaultTooltipModel((TooltipModel)new UserEventTooltip(this.getTimeline(), (EventModel<UserEvent>)userEventEventModel)));
        interaction.addTrackModel(TrackModel.newBuilder((Object)lifecycleEventModel, (Enum)ProfilerTrackRendererType.APP_LIFECYCLE, (String)"Lifecycle").setDefaultTooltipModel((TooltipModel)new LifecycleTooltip(this.getTimeline(), lifecycleEventModel)));
        return interaction;
    }

    private TrackGroupModel createDisplayTrackGroup(@NotNull Range selectionRange, @NotNull AtraceCpuCapture atraceCapture) {
        if (selectionRange == null) {
            CpuCaptureStage.$$$reportNull$$$0(25);
        }
        if (atraceCapture == null) {
            CpuCaptureStage.$$$reportNull$$$0(26);
        }
        TrackGroupModel display = TrackGroupModel.newBuilder().setTitle("Display").build();
        CpuFramesModel.FrameState mainFrames = new CpuFramesModel.FrameState("Main", atraceCapture.getMainThreadId(), AtraceFrame.FrameThread.MAIN, atraceCapture, selectionRange);
        CpuFrameTooltip mainFrameTooltip = new CpuFrameTooltip(this.myTrackGroupTimeline);
        mainFrameTooltip.setFrameSeries(mainFrames.getSeries());
        display.addTrackModel(TrackModel.newBuilder((Object)mainFrames, (Enum)ProfilerTrackRendererType.FRAMES, (String)"Frames").setDefaultTooltipModel((TooltipModel)mainFrameTooltip));
        return display;
    }

    private TrackGroupModel createThreadsTrackGroup(@NotNull Range selectionRange, @NotNull CpuCapture capture) {
        if (selectionRange == null) {
            CpuCaptureStage.$$$reportNull$$$0(27);
        }
        if (capture == null) {
            CpuCaptureStage.$$$reportNull$$$0(28);
        }
        boolean collapseThreads = !(capture instanceof AtraceCpuCapture);
        List threadInfos = capture.getThreads().stream().sorted(new CaptureThreadComparator(capture)).collect(Collectors.toList());
        String threadsTitle = String.format(Locale.getDefault(), "Threads (%d)", threadInfos.size());
        TrackGroupModel threads = TrackGroupModel.newBuilder().setTitle(threadsTitle).setTitleInfo("This section contains thread info. Double-click on the thread name to expand/collapse it.").setTrackSelectable(true).build();
        for (CpuThreadInfo threadInfo : threadInfos) {
            String title = threadInfo.getName();
            threads.addTrackModel(TrackModel.newBuilder((Object)new CpuThreadTrackModel(selectionRange, capture, threadInfo, this.getTimeline(), this.myMultiSelectionModel), (Enum)ProfilerTrackRendererType.CPU_THREAD, (String)title).setCollapsible(true).setCollapsed(collapseThreads));
        }
        return threads;
    }

    private TrackGroupModel createCpuCoresTrackGroup(@NotNull Range selectionRange, @NotNull AtraceCpuCapture atraceCapture) {
        if (selectionRange == null) {
            CpuCaptureStage.$$$reportNull$$$0(29);
        }
        if (atraceCapture == null) {
            CpuCaptureStage.$$$reportNull$$$0(30);
        }
        int cpuCount = atraceCapture.getCpuCount();
        String coresTitle = String.format(Locale.getDefault(), "CPU cores (%d)", cpuCount);
        TrackGroupModel cores = TrackGroupModel.newBuilder().setTitle(coresTitle).setCollapsedInitially(true).build();
        for (int cpuId = 0; cpuId < cpuCount; ++cpuId) {
            CpuKernelTooltip kernelTooltip = new CpuKernelTooltip(this.getTimeline(), atraceCapture.getMainThreadId());
            int coreId = cpuId;
            AtraceDataSeries<CpuThreadSliceInfo> dataSeries = new AtraceDataSeries<CpuThreadSliceInfo>(atraceCapture, capture -> capture.getCpuThreadSliceInfoStates(coreId));
            kernelTooltip.setCpuSeries(cpuId, dataSeries);
            cores.addTrackModel(TrackModel.newBuilder((Object)new CpuCoreTrackModel(dataSeries, selectionRange, atraceCapture), (Enum)ProfilerTrackRendererType.CPU_CORE, (String)("CPU " + cpuId)).setDefaultTooltipModel((TooltipModel)kernelTooltip));
        }
        return cores;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureStage";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capture";
                break;
            }
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionRange";
                break;
            }
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "atraceCapture";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "saveCapture";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureStage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspect";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureHandler";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrackGroupModels";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultiSelectionModel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimapModel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalysisModels";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureTimeline";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeline";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapture";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAndSaveCapture";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addCpuAnalysisModel";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "onCaptureParsed";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "insertImportedTraceEvent";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "initTrackGroupList";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createInteractionTrackGroup";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createDisplayTrackGroup";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createThreadsTrackGroup";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createCpuCoresTrackGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum State {
        PARSING,
        ANALYZING;

    }

    public static enum Aspect {
        STATE,
        ANALYSIS_MODEL_UPDATED;

    }
}

