/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profiler.proto.Cpu;
import com.android.utils.HashCodes;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ProfilingConfiguration {
    public static final int DEFAULT_BUFFER_SIZE_MB = 8;
    public static final int DEFAULT_SAMPLING_INTERVAL_US = 1000;
    private String myName;
    private Cpu.CpuTraceType myProfilerType;
    private Cpu.CpuTraceMode myMode;
    private int myProfilingBufferSizeInMb = 8;
    private int myProfilingSamplingIntervalUs = 1000;
    private boolean myDisableLiveAllocation = true;

    public ProfilingConfiguration() {
    }

    public ProfilingConfiguration(String name, Cpu.CpuTraceType profilerType, Cpu.CpuTraceMode mode) {
        this.myName = name;
        this.myProfilerType = profilerType;
        this.myMode = mode;
    }

    public Cpu.CpuTraceMode getMode() {
        return this.myMode;
    }

    public void setMode(Cpu.CpuTraceMode mode) {
        this.myMode = mode;
    }

    public Cpu.CpuTraceType getTraceType() {
        return this.myProfilerType;
    }

    public void setTraceType(Cpu.CpuTraceType traceType) {
        this.myProfilerType = traceType;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public int getProfilingBufferSizeInMb() {
        return this.myProfilingBufferSizeInMb;
    }

    public void setProfilingBufferSizeInMb(int profilingBufferSizeInMb) {
        this.myProfilingBufferSizeInMb = profilingBufferSizeInMb;
    }

    public int getProfilingSamplingIntervalUs() {
        return this.myProfilingSamplingIntervalUs;
    }

    public boolean isDisableLiveAllocation() {
        return this.myDisableLiveAllocation;
    }

    public void setDisableLiveAllocation(boolean disableLiveAllocation) {
        this.myDisableLiveAllocation = disableLiveAllocation;
    }

    public int getRequiredDeviceLevel() {
        switch (this.myProfilerType) {
            case ATRACE: {
                return 24;
            }
            case SIMPLEPERF: {
                return 26;
            }
        }
        return 0;
    }

    public boolean isDeviceLevelSupported(int deviceLevel) {
        return deviceLevel >= this.getRequiredDeviceLevel();
    }

    public void setProfilingSamplingIntervalUs(int profilingSamplingIntervalUs) {
        this.myProfilingSamplingIntervalUs = profilingSamplingIntervalUs;
    }

    @NotNull
    public static ProfilingConfiguration fromProto(@NotNull Cpu.CpuTraceConfiguration.UserOptions proto) {
        if (proto == null) {
            ProfilingConfiguration.$$$reportNull$$$0(0);
        }
        ProfilingConfiguration configuration = new ProfilingConfiguration(proto.getName(), proto.getTraceType(), proto.getTraceMode());
        configuration.setProfilingSamplingIntervalUs(proto.getSamplingIntervalUs());
        configuration.setProfilingBufferSizeInMb(proto.getBufferSizeInMb());
        configuration.setDisableLiveAllocation(proto.getDisableLiveAllocation());
        ProfilingConfiguration profilingConfiguration = configuration;
        if (profilingConfiguration == null) {
            ProfilingConfiguration.$$$reportNull$$$0(1);
        }
        return profilingConfiguration;
    }

    @NotNull
    public Cpu.CpuTraceConfiguration.UserOptions toProto() {
        Cpu.CpuTraceConfiguration.UserOptions userOptions = Cpu.CpuTraceConfiguration.UserOptions.newBuilder().setName(this.getName()).setTraceType(this.getTraceType()).setTraceMode(this.getMode()).setSamplingIntervalUs(this.getProfilingSamplingIntervalUs()).setBufferSizeInMb(this.getProfilingBufferSizeInMb()).setDisableLiveAllocation(this.isDisableLiveAllocation()).build();
        if (userOptions == null) {
            ProfilingConfiguration.$$$reportNull$$$0(2);
        }
        return userOptions;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProfilingConfiguration)) {
            return false;
        }
        ProfilingConfiguration incoming = (ProfilingConfiguration)obj;
        return StringUtil.equals((CharSequence)this.getName(), (CharSequence)incoming.getName()) && this.getTraceType() == incoming.getTraceType() && this.getMode() == incoming.getMode() && this.getProfilingSamplingIntervalUs() == incoming.getProfilingSamplingIntervalUs() && this.getProfilingBufferSizeInMb() == incoming.getProfilingBufferSizeInMb() && this.isDisableLiveAllocation() == incoming.isDisableLiveAllocation();
    }

    public int hashCode() {
        return HashCodes.mix((int)Objects.hashCode(this.getName()), (int)Objects.hashCode(this.getTraceType()), (int)Objects.hashCode(this.getMode()), (int)this.getProfilingSamplingIntervalUs(), (int)this.getProfilingBufferSizeInMb(), (int)Boolean.hashCode(this.isDisableLiveAllocation()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/ProfilingConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/ProfilingConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fromProto";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toProto";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromProto";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

