/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.adtui.model.Range;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import trebuchet.model.base.SliceGroup;

public final class SliceStream {
    @NotNull
    private final List<SliceGroup> mySlices;
    private Pattern myPattern;
    private Range myRange;

    public SliceStream(@NotNull List<SliceGroup> slices) {
        if (slices == null) {
            SliceStream.$$$reportNull$$$0(0);
        }
        this.myPattern = Pattern.compile(".*");
        this.myRange = new Range(Double.MIN_VALUE, Double.MAX_VALUE);
        this.mySlices = slices;
    }

    public SliceStream matchPattern(@NotNull Pattern pattern) {
        if (pattern == null) {
            SliceStream.$$$reportNull$$$0(1);
        }
        this.myPattern = pattern;
        return this;
    }

    public SliceStream matchName(@NotNull String name) {
        if (name == null) {
            SliceStream.$$$reportNull$$$0(2);
        }
        return this.matchPattern(Pattern.compile("^" + Pattern.quote(name)));
    }

    public SliceStream overlapsRange(Range range) {
        this.myRange = range;
        return this;
    }

    public void enumerate(@NotNull Function<SliceGroup, EnumerationResult> action) {
        if (action == null) {
            SliceStream.$$$reportNull$$$0(3);
        }
        SliceStream.forEachMatchingSlice(this.mySlices, this.myPattern, this.myRange, action);
    }

    public SliceGroup findFirst() {
        SliceGroup[] slices = new SliceGroup[1];
        SliceStream.forEachMatchingSlice(this.mySlices, this.myPattern, this.myRange, sliceGroup -> {
            slices[0] = sliceGroup;
            return EnumerationResult.TERMINATE;
        });
        return slices[0];
    }

    private static EnumerationResult forEachMatchingSlice(@NotNull List<SliceGroup> sliceGroups, @NotNull Pattern pattern, @NotNull Range range, Function<SliceGroup, EnumerationResult> action) {
        if (sliceGroups == null) {
            SliceStream.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            SliceStream.$$$reportNull$$$0(5);
        }
        if (range == null) {
            SliceStream.$$$reportNull$$$0(6);
        }
        for (SliceGroup slice : sliceGroups) {
            EnumerationResult result;
            if (!(slice.getStartTime() <= range.getMax()) || !(slice.getEndTime() >= range.getMin())) continue;
            boolean skipChildren = false;
            if (pattern.matcher(slice.getName()).matches()) {
                EnumerationResult continueResult = action.apply(slice);
                if (continueResult == EnumerationResult.TERMINATE) {
                    return continueResult;
                }
                boolean bl = skipChildren = continueResult == EnumerationResult.SKIP_CHILDREN;
            }
            if (skipChildren || (result = SliceStream.forEachMatchingSlice(slice.getChildren(), pattern, range, action)) != EnumerationResult.TERMINATE) continue;
            return result;
        }
        return EnumerationResult.CONTINUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slices";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sliceGroups";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/atrace/SliceStream";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "matchPattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "matchName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "enumerate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "forEachMatchingSlice";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum EnumerationResult {
        CONTINUE,
        TERMINATE,
        SKIP_CHILDREN;

    }
}

