/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.VisualNodeCaptureNode;
import com.android.tools.profilers.cpu.atrace.AtraceCpuCapture;
import com.android.tools.profilers.cpu.audits.RenderAuditModel;
import com.android.tools.profilers.cpu.capturedetails.BottomUpNode;
import com.android.tools.profilers.cpu.capturedetails.BottomUpTreeModel;
import com.android.tools.profilers.cpu.capturedetails.TopDownNode;
import com.android.tools.profilers.cpu.capturedetails.TopDownTreeModel;
import com.android.tools.profilers.cpu.nodemodel.SingleNameModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CaptureDetails {
    @NotNull
    private final CpuCapture myCapture;

    protected CaptureDetails(@NotNull CpuCapture cpuCapture) {
        if (cpuCapture == null) {
            CaptureDetails.$$$reportNull$$$0(0);
        }
        this.myCapture = cpuCapture;
    }

    @NotNull
    public CpuCapture getCapture() {
        CpuCapture cpuCapture = this.myCapture;
        if (cpuCapture == null) {
            CaptureDetails.$$$reportNull$$$0(1);
        }
        return cpuCapture;
    }

    @NotNull
    public abstract Type getType();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpuCapture";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapture";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RenderAuditCaptureDetails
    extends CaptureDetails {
        private final RenderAuditModel myRenderAuditModel;

        RenderAuditCaptureDetails(@NotNull Range range, @NotNull List<CaptureNode> nodes, @NotNull CpuCapture cpuCapture) {
            if (range == null) {
                RenderAuditCaptureDetails.$$$reportNull$$$0(0);
            }
            if (nodes == null) {
                RenderAuditCaptureDetails.$$$reportNull$$$0(1);
            }
            if (cpuCapture == null) {
                RenderAuditCaptureDetails.$$$reportNull$$$0(2);
            }
            super(cpuCapture);
            assert (cpuCapture instanceof AtraceCpuCapture);
            this.myRenderAuditModel = new RenderAuditModel((AtraceCpuCapture)cpuCapture);
        }

        @Override
        @NotNull
        public Type getType() {
            Type type = Type.RENDER_AUDIT;
            if (type == null) {
                RenderAuditCaptureDetails.$$$reportNull$$$0(3);
            }
            return type;
        }

        public RenderAuditModel getRenderAuditModel() {
            return this.myRenderAuditModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpuCapture";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$RenderAuditCaptureDetails";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$RenderAuditCaptureDetails";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class FlameChart
    extends ChartDetails {
        @NotNull
        private final Range myFlameRange;
        @Nullable
        private CaptureNode myFlameNode;
        @Nullable
        private final TopDownNode myTopDownNode;
        @NotNull
        private final Range mySelectionRange;
        @NotNull
        private final AspectModel<Aspect> myAspectModel;

        FlameChart(@NotNull Range selectionRange, @NotNull List<CaptureNode> captureNodes, @NotNull CpuCapture cpuCapture) {
            if (selectionRange == null) {
                FlameChart.$$$reportNull$$$0(0);
            }
            if (captureNodes == null) {
                FlameChart.$$$reportNull$$$0(1);
            }
            if (cpuCapture == null) {
                FlameChart.$$$reportNull$$$0(2);
            }
            super(cpuCapture);
            this.mySelectionRange = selectionRange;
            this.myFlameRange = new Range();
            this.myAspectModel = new AspectModel();
            if (captureNodes.isEmpty()) {
                this.myFlameNode = null;
                this.myTopDownNode = null;
                return;
            }
            VisualNodeCaptureNode visual = new VisualNodeCaptureNode(new SingleNameModel(""));
            captureNodes.sort(Comparator.comparingLong(CaptureNode::getStartGlobal));
            captureNodes.forEach(visual::addChild);
            visual.setStartGlobal(captureNodes.get(0).getStartGlobal());
            this.myTopDownNode = new TopDownNode(visual);
            this.myTopDownNode.update(new Range(0.0, Double.MAX_VALUE));
            visual.setEndGlobal(visual.getStartGlobal() + (long)this.myTopDownNode.getGlobalChildrenTotal());
            selectionRange.addDependency(this.myAspectModel).onChange((Enum)Range.Aspect.RANGE, this::selectionRangeChanged);
            this.selectionRangeChanged();
        }

        private void selectionRangeChanged() {
            assert (this.myTopDownNode != null);
            this.myTopDownNode.update(this.mySelectionRange);
            if (this.myTopDownNode.getGlobalTotal() > 0.0) {
                double start = Math.max((double)this.myTopDownNode.getNodes().get(0).getStart(), this.mySelectionRange.getMin());
                this.myFlameNode = this.convertToFlameChart(this.myTopDownNode, start, 0);
                this.myFlameNode.setEndGlobal(((CaptureNode)this.myFlameNode.getLastChild()).getEndGlobal());
                this.myFlameRange.set((double)this.myFlameNode.getStart(), (double)this.myFlameNode.getEnd());
            } else {
                this.myFlameNode = null;
            }
            this.myAspectModel.changed((Enum)Aspect.NODE);
        }

        @NotNull
        public Range getRange() {
            Range range = this.myFlameRange;
            if (range == null) {
                FlameChart.$$$reportNull$$$0(3);
            }
            return range;
        }

        @Override
        @Nullable
        public CaptureNode getNode() {
            return this.myFlameNode;
        }

        @NotNull
        public AspectModel<Aspect> getAspect() {
            AspectModel<Aspect> aspectModel = this.myAspectModel;
            if (aspectModel == null) {
                FlameChart.$$$reportNull$$$0(4);
            }
            return aspectModel;
        }

        @Override
        @NotNull
        public Type getType() {
            Type type = Type.FLAME_CHART;
            if (type == null) {
                FlameChart.$$$reportNull$$$0(5);
            }
            return type;
        }

        /*
         * WARNING - void declaration
         */
        private CaptureNode convertToFlameChart(@NotNull TopDownNode topDown, double start, int n) {
            void depth;
            if (topDown == null) {
                FlameChart.$$$reportNull$$$0(6);
            }
            assert (topDown.getGlobalTotal() > 0.0);
            CaptureNode node = new CaptureNode(topDown.getNodes().get(0).getData());
            node.setFilterType(topDown.getNodes().get(0).getFilterType());
            node.setStartGlobal((long)start);
            node.setStartThread((long)start);
            node.setEndGlobal((long)(start + topDown.getGlobalTotal()));
            node.setEndThread((long)(start + topDown.getThreadTotal()));
            node.setDepth((int)depth);
            for (TopDownNode child : topDown.getChildren()) {
                child.update(this.mySelectionRange);
            }
            ArrayList sortedChildren = new ArrayList(topDown.getChildren());
            sortedChildren.sort((o1, o2) -> {
                int cmp = Boolean.compare(o1.isUnmatched(), o2.isUnmatched());
                return cmp == 0 ? Double.compare(o2.getGlobalTotal(), o1.getGlobalTotal()) : cmp;
            });
            for (TopDownNode child : sortedChildren) {
                if (child.getGlobalTotal() == 0.0) continue;
                node.addChild(this.convertToFlameChart(child, start, (int)(depth + true)));
                start += child.getGlobalTotal();
            }
            return node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectionRange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "captureNodes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpuCapture";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$FlameChart";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topDown";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$FlameChart";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAspect";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToFlameChart";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static enum Aspect {
            NODE;

        }
    }

    public static class CallChart
    extends ChartDetails {
        @NotNull
        private final Range myRange;
        @Nullable
        private CaptureNode myNode;

        public CallChart(@NotNull Range range, @NotNull List<CaptureNode> nodes, @NotNull CpuCapture cpuCapture) {
            if (range == null) {
                CallChart.$$$reportNull$$$0(0);
            }
            if (nodes == null) {
                CallChart.$$$reportNull$$$0(1);
            }
            if (cpuCapture == null) {
                CallChart.$$$reportNull$$$0(2);
            }
            super(cpuCapture);
            this.myRange = range;
            if (nodes.isEmpty()) {
                this.myNode = null;
                return;
            }
            this.myNode = nodes.get(0);
        }

        @NotNull
        public Range getRange() {
            Range range = this.myRange;
            if (range == null) {
                CallChart.$$$reportNull$$$0(3);
            }
            return range;
        }

        @Override
        @Nullable
        public CaptureNode getNode() {
            return this.myNode;
        }

        @Override
        @NotNull
        public Type getType() {
            Type type = Type.CALL_CHART;
            if (type == null) {
                CallChart.$$$reportNull$$$0(4);
            }
            return type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpuCapture";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$CallChart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$CallChart";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BottomUp
    extends CaptureDetails {
        @Nullable
        private BottomUpTreeModel myModel;

        BottomUp(@NotNull Range range, @NotNull List<CaptureNode> nodes, @NotNull CpuCapture cpuCapture) {
            if (range == null) {
                BottomUp.$$$reportNull$$$0(0);
            }
            if (nodes == null) {
                BottomUp.$$$reportNull$$$0(1);
            }
            if (cpuCapture == null) {
                BottomUp.$$$reportNull$$$0(2);
            }
            super(cpuCapture);
            if (nodes.isEmpty()) {
                this.myModel = null;
                return;
            }
            Range captureRange = cpuCapture.getRange();
            VisualNodeCaptureNode visual = new VisualNodeCaptureNode(new SingleNameModel(""));
            nodes.forEach(visual::addChild);
            visual.setStartGlobal((long)captureRange.getMin());
            visual.setEndGlobal((long)captureRange.getMax());
            BottomUpNode buNode = new BottomUpNode(visual);
            buNode.update(range);
            this.myModel = new BottomUpTreeModel(range, buNode);
        }

        @Nullable
        public BottomUpTreeModel getModel() {
            return this.myModel;
        }

        @Override
        @NotNull
        public Type getType() {
            Type type = Type.BOTTOM_UP;
            if (type == null) {
                BottomUp.$$$reportNull$$$0(3);
            }
            return type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpuCapture";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$BottomUp";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$BottomUp";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TopDown
    extends CaptureDetails {
        @Nullable
        private final TopDownTreeModel myModel;

        TopDown(@NotNull Range range, @NotNull List<CaptureNode> nodes, @NotNull CpuCapture cpuCapture) {
            if (range == null) {
                TopDown.$$$reportNull$$$0(0);
            }
            if (nodes == null) {
                TopDown.$$$reportNull$$$0(1);
            }
            if (cpuCapture == null) {
                TopDown.$$$reportNull$$$0(2);
            }
            super(cpuCapture);
            if (nodes.isEmpty()) {
                this.myModel = null;
                return;
            }
            Range captureRange = cpuCapture.getRange();
            VisualNodeCaptureNode visual = new VisualNodeCaptureNode(new SingleNameModel(""));
            nodes.forEach(visual::addChild);
            visual.setStartGlobal((long)captureRange.getMin());
            visual.setEndGlobal((long)captureRange.getMax());
            this.myModel = new TopDownTreeModel(range, new TopDownNode(visual));
        }

        @Nullable
        public TopDownTreeModel getModel() {
            return this.myModel;
        }

        @Override
        @NotNull
        public Type getType() {
            Type type = Type.TOP_DOWN;
            if (type == null) {
                TopDown.$$$reportNull$$$0(3);
            }
            return type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpuCapture";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$TopDown";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$TopDown";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static abstract class ChartDetails
    extends CaptureDetails {
        protected ChartDetails(@NotNull CpuCapture cpuCapture) {
            if (cpuCapture == null) {
                ChartDetails.$$$reportNull$$$0(0);
            }
            super(cpuCapture);
        }

        @Nullable
        abstract CaptureNode getNode();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cpuCapture", "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$ChartDetails", "<init>"));
        }
    }

    static interface CaptureDetailsBuilder {
        public CaptureDetails build(Range var1, List<CaptureNode> var2, CpuCapture var3);
    }

    public static enum Type {
        TOP_DOWN(TopDown::new),
        BOTTOM_UP(BottomUp::new),
        CALL_CHART(CallChart::new),
        FLAME_CHART(FlameChart::new),
        RENDER_AUDIT(RenderAuditCaptureDetails::new);

        @NotNull
        private final CaptureDetailsBuilder myBuilder;

        private Type(CaptureDetailsBuilder builder) {
            if (builder == null) {
                Type.$$$reportNull$$$0(0);
            }
            this.myBuilder = builder;
        }

        public CaptureDetails build(@NotNull Range range, @NotNull List<CaptureNode> node, @NotNull CpuCapture cpuCapture) {
            if (range == null) {
                Type.$$$reportNull$$$0(1);
            }
            if (node == null) {
                Type.$$$reportNull$$$0(2);
            }
            if (cpuCapture == null) {
                Type.$$$reportNull$$$0(3);
            }
            return this.myBuilder.build(range, node, cpuCapture);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpuCapture";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$Type";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "build";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

