/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.profilers.memory.MemoryProfilerConfiguration;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassSet;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.PackageSet;
import com.android.tools.profilers.memory.adapters.ThreadSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class HeapSet
extends ClassifierSet {
    @NotNull
    private final CaptureObject myCaptureObject;
    @NotNull
    private MemoryProfilerConfiguration.ClassGrouping myClassGrouping;
    private final int myId;
    @NotNull
    private Filter myFilter;

    public HeapSet(@NotNull CaptureObject captureObject, @NotNull String heapName, int id) {
        if (captureObject == null) {
            HeapSet.$$$reportNull$$$0(0);
        }
        if (heapName == null) {
            HeapSet.$$$reportNull$$$0(1);
        }
        super(heapName);
        this.myClassGrouping = MemoryProfilerConfiguration.ClassGrouping.ARRANGE_BY_CLASS;
        this.myCaptureObject = captureObject;
        this.myId = id;
        this.myFilter = Filter.EMPTY_FILTER;
        this.setClassGrouping(MemoryProfilerConfiguration.ClassGrouping.ARRANGE_BY_CLASS);
    }

    public void setClassGrouping(@NotNull MemoryProfilerConfiguration.ClassGrouping classGrouping) {
        if (classGrouping == null) {
            HeapSet.$$$reportNull$$$0(2);
        }
        if (this.myClassGrouping == classGrouping) {
            return;
        }
        this.myClassGrouping = classGrouping;
        List snapshotStream = this.getSnapshotInstanceStream().collect(Collectors.toList());
        List deltaStream = this.getDeltaInstanceStream().collect(Collectors.toList());
        this.myDeltaInstances.clear();
        this.mySnapshotInstances.clear();
        this.myClassifier = null;
        this.myDeltaInstances.addAll(deltaStream);
        this.mySnapshotInstances.addAll(snapshotStream);
        this.myNeedsRefiltering = true;
    }

    public int getId() {
        return this.myId;
    }

    public void selectFilter(@NotNull Filter filter) {
        if (filter == null) {
            HeapSet.$$$reportNull$$$0(3);
        }
        if (this.myFilter.isEmpty() && filter.isEmpty()) {
            return;
        }
        boolean filterChanged = !this.myFilter.equals((Object)filter);
        this.myFilter = filter;
        this.applyFilter(filterChanged);
    }

    @NotNull
    public Filter getFilter() {
        Filter filter = this.myFilter;
        if (filter == null) {
            HeapSet.$$$reportNull$$$0(4);
        }
        return filter;
    }

    private void applyFilter(boolean filterChanged) {
        this.applyFilter(this.myFilter, false, filterChanged);
    }

    @Override
    @NotNull
    public ClassifierSet.Classifier createSubClassifier() {
        switch (this.myClassGrouping) {
            case ARRANGE_BY_CLASS: {
                ClassifierSet.Classifier classifier = ClassSet.createDefaultClassifier();
                if (classifier == null) {
                    HeapSet.$$$reportNull$$$0(5);
                }
                return classifier;
            }
            case ARRANGE_BY_PACKAGE: {
                ClassifierSet.Classifier classifier = PackageSet.createDefaultClassifier(this.myCaptureObject);
                if (classifier == null) {
                    HeapSet.$$$reportNull$$$0(6);
                }
                return classifier;
            }
            case ARRANGE_BY_CALLSTACK: {
                ClassifierSet.Classifier classifier = ThreadSet.createDefaultClassifier(this.myCaptureObject);
                if (classifier == null) {
                    HeapSet.$$$reportNull$$$0(7);
                }
                return classifier;
            }
        }
        throw new RuntimeException("Classifier type not implemented: " + this.myClassGrouping);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heapName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classGrouping";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/HeapSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/HeapSet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubClassifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setClassGrouping";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "selectFilter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

