/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.httpdata.HttpData;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpDataFetcher {
    private final AspectObserver myAspectObserver;
    @NotNull
    private final NetworkConnectionsModel myConnectionsModel;
    @NotNull
    private final Range myRange;
    @NotNull
    private final List<Listener> myListeners;
    @Nullable
    private List<HttpData> myDataList;

    public HttpDataFetcher(@NotNull NetworkConnectionsModel connectionsModel, @NotNull Range range) {
        if (connectionsModel == null) {
            HttpDataFetcher.$$$reportNull$$$0(0);
        }
        if (range == null) {
            HttpDataFetcher.$$$reportNull$$$0(1);
        }
        this.myAspectObserver = new AspectObserver();
        this.myListeners = new ArrayList<Listener>();
        this.myConnectionsModel = connectionsModel;
        this.myRange = range;
        this.myRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::handleRangeUpdated);
        this.handleRangeUpdated();
    }

    public void addListener(@NotNull Listener listener) {
        if (listener == null) {
            HttpDataFetcher.$$$reportNull$$$0(2);
        }
        this.myListeners.add(listener);
        if (this.myDataList != null) {
            this.fireListeners(this.myDataList);
        }
    }

    private void handleRangeUpdated() {
        ArrayList<HttpData> dataList;
        List<HttpData> list = dataList = !this.myRange.isEmpty() ? this.myConnectionsModel.getData(this.myRange) : new ArrayList<HttpData>();
        if (this.myDataList != null && this.myDataList.equals(dataList)) {
            return;
        }
        this.myDataList = dataList;
        this.fireListeners(this.myDataList);
    }

    private void fireListeners(@NotNull List<HttpData> dataList) {
        if (dataList == null) {
            HttpDataFetcher.$$$reportNull$$$0(3);
        }
        for (Listener l : this.myListeners) {
            l.onUpdated(dataList);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionsModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataList";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/network/HttpDataFetcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fireListeners";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener {
        public void onUpdated(@NotNull List<HttpData> var1);
    }
}

