/*
 * Decompiled with CFR 0.152.
 */
package training.learn;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.NewLearnProjectUtil;
import training.learn.OpenLessonActivities;
import training.learn.OpenLessonActivities$cleanupAndOpenLesson$;
import training.learn.OpenLessonActivities$openLessonForPreparedProject$;
import training.learn.OpenLessonActivities$sam$java_lang_Runnable$0;
import training.learn.interfaces.Lesson;
import training.learn.interfaces.LessonType;
import training.learn.interfaces.Module;
import training.learn.lesson.LessonListener;
import training.learn.lesson.LessonManager;
import training.learn.lesson.kimpl.KLesson;
import training.learn.lesson.kimpl.LessonContextImpl;
import training.learn.lesson.kimpl.LessonExecutor;
import training.learn.lesson.kimpl.LessonUtil;
import training.learn.lesson.listeners.StatisticLessonListener;
import training.project.ProjectUtils;
import training.ui.LearnToolWindow;
import training.ui.LearnToolWindowFactory;
import training.ui.LearningUiManager;
import training.util.UtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0002J5\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\t2!\u0010\u001c\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00070\u001dH\u0002J\u0006\u0010 \u001a\u00020\u0007J\u0018\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010#\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010$\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\tH\u0003J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0002J,\u0010'\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\"\u001a\u00020\t2\b\u0010+\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010,\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Ltraining/learn/OpenLessonActivities;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "addStatisticLessonListenerIfNeeded", "", "currentProject", "Lcom/intellij/openapi/project/Project;", "lesson", "Ltraining/learn/interfaces/Lesson;", "askSwitchToLearnProjectBack", "learnProject", "cleanupAndOpenLesson", "project", "lessonToOpen", "findLearnProjectInOpenedProjects", "langSupport", "Ltraining/lang/LangSupport;", "getFileInLearnProject", "Lcom/intellij/openapi/vfs/VirtualFile;", "getScratchFile", "filename", "", "hideOtherViews", "initLearnProject", "projectToClose", "postInitCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "openLearnProjectFromWelcomeScreen", "openLesson", "projectWhereToStartLesson", "openLessonForPreparedProject", "openLessonWhenLearnProjectStart", "myLearnProject", "openReadme", "processDslLesson", "Ltraining/learn/lesson/kimpl/KLesson;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "vf", "showModules", "intellij.featuresTrainer"})
public final class OpenLessonActivities {
    private static final Logger LOG;
    public static final OpenLessonActivities INSTANCE;

    @RequiresEdt
    public final void openLesson(@NotNull Project projectWhereToStartLesson, @NotNull Lesson lesson) {
        LearnToolWindow activeToolWindow;
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)projectWhereToStartLesson, (String)"projectWhereToStartLesson");
        Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
        LOG.debug(projectWhereToStartLesson.getName() + ": start openLesson method");
        LessonManager.Companion.getInstance().stopLesson$intellij_featuresTrainer();
        LearnToolWindow learnToolWindow = LearningUiManager.INSTANCE.getActiveToolWindow();
        if (learnToolWindow == null) {
            object = LearnToolWindowFactory.Companion.getLearnWindowPerProject().get(projectWhereToStartLesson);
            bl = false;
            boolean bl2 = false;
            LearnToolWindow it = object;
            boolean bl3 = false;
            LearningUiManager.INSTANCE.setActiveToolWindow(it);
            learnToolWindow = activeToolWindow = object;
        }
        if (activeToolWindow != null && Intrinsics.areEqual((Object)activeToolWindow.getProject(), (Object)projectWhereToStartLesson) ^ true) {
            activeToolWindow.setModulesPanel();
        }
        if (LessonManager.Companion.getInstance().lessonShouldBeOpenedCompleted(lesson)) {
            LearnToolWindow learnToolWindow2 = LearningUiManager.INSTANCE.getActiveToolWindow();
            if (learnToolWindow2 == null) {
                object = "No active toolwindow in " + projectWhereToStartLesson;
                bl = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            learnToolWindow2.setLearnPanel();
            LessonManager.Companion.getInstance().openLessonPassed$intellij_featuresTrainer((KLesson)lesson, projectWhereToStartLesson);
            return;
        }
        try {
            LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
            if (langSupport2 == null) {
                throw (Throwable)new Exception("Language for learning plugin is not defined");
            }
            LangSupport langSupport3 = langSupport2;
            Project learnProject = LearningUiManager.INSTANCE.getLearnProject();
            if (learnProject != null && !UtilsKt.isLearningProject(learnProject, langSupport3)) {
                learnProject = null;
            }
            LOG.debug(projectWhereToStartLesson.getName() + ": trying to get cached LearnProject " + (learnProject != null));
            if (learnProject == null) {
                learnProject = this.findLearnProjectInOpenedProjects(langSupport3);
            }
            LOG.debug(projectWhereToStartLesson.getName() + ": trying to find LearnProject in opened projects " + (learnProject != null));
            if (learnProject != null) {
                LearningUiManager.INSTANCE.setLearnProject(learnProject);
            }
            if (lesson.getLessonType() == LessonType.SCRATCH) {
                LOG.debug(projectWhereToStartLesson.getName() + ": scratch based lesson");
            } else if (learnProject == null || learnProject.isDisposed()) {
                if (!UtilsKt.isLearningProject(projectWhereToStartLesson, langSupport3)) {
                    LOG.debug(projectWhereToStartLesson.getName() + ": 1. learnProject is null or disposed");
                    this.initLearnProject(projectWhereToStartLesson, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(projectWhereToStartLesson, lesson){
                        final /* synthetic */ Project $projectWhereToStartLesson;
                        final /* synthetic */ Lesson $lesson;

                        public final void invoke(@NotNull Project it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            OpenLessonActivities.access$getLOG$p(OpenLessonActivities.INSTANCE).debug(this.$projectWhereToStartLesson.getName() + ": 1. ... LearnProject has been started");
                            OpenLessonActivities.access$openLessonWhenLearnProjectStart(OpenLessonActivities.INSTANCE, this.$lesson, it);
                            OpenLessonActivities.access$getLOG$p(OpenLessonActivities.INSTANCE).debug(this.$projectWhereToStartLesson.getName() + ": 1. ... open lesson when learn project has been started");
                        }
                        {
                            this.$projectWhereToStartLesson = project;
                            this.$lesson = lesson;
                            super(1);
                        }
                    }));
                    return;
                }
                LOG.debug(projectWhereToStartLesson.getName() + ": 0. learnProject is null but the current project (" + projectWhereToStartLesson.getName() + ')' + "is LearnProject then just getFileInLearnProject");
                LearningUiManager.INSTANCE.setLearnProject(projectWhereToStartLesson);
                learnProject = projectWhereToStartLesson;
            } else {
                if (learnProject.isOpen() && Intrinsics.areEqual((Object)projectWhereToStartLesson, (Object)learnProject) ^ true) {
                    LOG.debug(projectWhereToStartLesson.getName() + ": 3. LearnProject is opened but not focused. Ask user to focus to LearnProject");
                    this.askSwitchToLearnProjectBack(learnProject, projectWhereToStartLesson);
                    return;
                }
                if (learnProject.isOpen() && Intrinsics.areEqual((Object)projectWhereToStartLesson, (Object)learnProject)) {
                    LOG.debug(projectWhereToStartLesson.getName() + ": 4. LearnProject is the current project");
                } else {
                    throw (Throwable)new Exception("Unable to start Learn project");
                }
            }
            if (lesson.getLessonType().isProject()) {
                if (Intrinsics.areEqual((Object)projectWhereToStartLesson, (Object)learnProject) ^ true) {
                    LOG.error((Throwable)new Exception("Invalid learning project initialization: projectWhereToStartLesson = " + projectWhereToStartLesson + ", learnProject = " + learnProject));
                    return;
                }
                this.cleanupAndOpenLesson(projectWhereToStartLesson, lesson);
            } else {
                this.openLessonForPreparedProject(projectWhereToStartLesson, lesson);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanupAndOpenLesson(Project project, Lesson lessonToOpen) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CourseManager.Companion.getInstance().getLessonsForModules();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Lesson it = (Lesson)element$iv$iv;
            boolean bl = false;
            if (!(it.getLessonType() == LessonType.PROJECT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List lessons = (List)destination$iv$iv;
        String title$iv = LearnBundle.INSTANCE.message("learn.project.initializing.process", new Object[0]);
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title$iv, cancellable$iv, project, title$iv, cancellable$iv, project, lessons, lessonToOpen){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ List $lessons$inlined;
            final /* synthetic */ Lesson $lessonToOpen$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.$project$inlined = project;
                this.$lessons$inlined = list2;
                this.$lessonToOpen$inlined = lesson;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator it = indicator;
                boolean bl = false;
                LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
                if (langSupport2 != null) {
                    langSupport2.cleanupBeforeLessons(this.$project$inlined);
                }
                for (Lesson lesson : this.$lessons$inlined) {
                    lesson.cleanup(this.$project$inlined);
                }
                ModalityState modalityState$iv = null;
                boolean $i$f$invokeLater = false;
                Application application = ApplicationManager.getApplication();
                Runnable runnable2 = new Runnable(this){
                    final /* synthetic */ cleanupAndOpenLesson$$inlined$runBackgroundableTask$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        boolean bl = false;
                        OpenLessonActivities.access$openLessonForPreparedProject(OpenLessonActivities.INSTANCE, this.this$0.$project$inlined, this.this$0.$lessonToOpen$inlined);
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application.invokeLater(runnable2, modalityState);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void openLessonForPreparedProject(Project project, Lesson lesson) {
        LearnToolWindow learnToolWindow;
        boolean bl;
        VirtualFile vf;
        VirtualFile virtualFile;
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport2 == null) {
            throw (Throwable)new Exception("Language should be defined by now");
        }
        LangSupport langSupport3 = langSupport2;
        if (lesson.getLessonType() == LessonType.SCRATCH) {
            LOG.debug(project.getName() + ": scratch based lesson");
            virtualFile = this.getScratchFile(project, lesson, langSupport3.getFilename());
        } else {
            LOG.debug(project.getName() + ": 4. LearnProject is the current project");
            virtualFile = vf = this.getFileInLearnProject(lesson);
        }
        if (lesson.getLessonType() != LessonType.SCRATCH) {
            ProjectUtils.INSTANCE.closeAllEditorsInProject(project);
        }
        if (lesson.getLessonType() != LessonType.SCRATCH || Intrinsics.areEqual((Object)LearningUiManager.INSTANCE.getLearnProject(), (Object)project)) {
            this.hideOtherViews(project);
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Learn");
            if (toolWindow != null) {
                toolWindow.show();
            }
        }
        LOG.debug(project.getName() + ": Add listeners to lesson");
        this.addStatisticLessonListenerIfNeeded(project, lesson);
        LOG.debug(project.getName() + ": Set lesson view");
        LearningUiManager learningUiManager = LearningUiManager.INSTANCE;
        LearnToolWindow learnToolWindow2 = LearnToolWindowFactory.Companion.getLearnWindowPerProject().get(project);
        if (learnToolWindow2 != null) {
            void it;
            LearnToolWindow learnToolWindow3 = learnToolWindow2;
            boolean bl2 = false;
            bl = false;
            LearnToolWindow learnToolWindow4 = learnToolWindow3;
            LearningUiManager learningUiManager2 = learningUiManager;
            boolean bl3 = false;
            it.setLearnPanel();
            Unit unit = Unit.INSTANCE;
            learningUiManager = learningUiManager2;
            learnToolWindow = learnToolWindow3;
        } else {
            learnToolWindow = null;
        }
        learningUiManager.setActiveToolWindow(learnToolWindow);
        LOG.debug(project.getName() + ": XmlLesson onStart()");
        lesson.onStart();
        LOG.debug(project.getName() + ": PREPARING TO START LESSON:");
        LOG.debug(project.getName() + ": 1. Open or find editor");
        TextEditor textEditor = null;
        if (vf != null && FileEditorManager.getInstance((Project)project).isFileOpen(vf)) {
            FileEditor[] editors;
            for (FileEditor fileEditor : editors = FileEditorManager.getInstance((Project)project).getEditors(vf)) {
                if (!(fileEditor instanceof TextEditor)) continue;
                textEditor = (TextEditor)fileEditor;
            }
        }
        if (vf != null && textEditor == null) {
            FileEditor[] editors;
            for (FileEditor fileEditor : editors = FileEditorManager.getInstance((Project)project).openFile(vf, true, true)) {
                if (!(fileEditor instanceof TextEditor)) continue;
                textEditor = (TextEditor)fileEditor;
            }
            if (textEditor == null) {
                LOG.error("Cannot open editor for " + vf);
                if (lesson.getLessonType() == LessonType.SCRATCH) {
                    ModalityState modalityState$iv = null;
                    boolean $i$f$invokeLater = false;
                    Application application = ApplicationManager.getApplication();
                    Runnable runnable2 = new Runnable(vf){
                        final /* synthetic */ VirtualFile $vf$inlined;
                        {
                            this.$vf$inlined = virtualFile;
                        }

                        public final void run() {
                            boolean bl = false;
                            boolean $i$f$runWriteAction = false;
                            ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(this){
                                final /* synthetic */ openLessonForPreparedProject$$inlined$invokeLater$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public final T compute() {
                                    boolean bl = false;
                                    this.this$0.$vf$inlined.delete((Object)OpenLessonActivities.INSTANCE);
                                    return (T)Unit.INSTANCE;
                                }
                            });
                        }
                    };
                    ModalityState modalityState = ModalityState.defaultModalityState();
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                    application.invokeLater(runnable2, modalityState);
                }
            }
        }
        LOG.debug(project.getName() + ": 2. Set the focus on this editor");
        if (vf != null) {
            FileEditorManager.getInstance((Project)project).openEditor(new OpenFileDescriptor(project, vf), true);
        }
        LOG.debug(project.getName() + ": 4. Process lesson");
        if (!(lesson instanceof KLesson)) {
            String string = "Unknown lesson format";
            bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.processDslLesson((KLesson)lesson, textEditor, project, vf);
    }

    private final void processDslLesson(KLesson lesson, TextEditor textEditor, Project projectWhereToStartLesson, VirtualFile vf) {
        TextEditor textEditor2 = textEditor;
        LessonExecutor executor = new LessonExecutor(lesson, projectWhereToStartLesson, (Editor)(textEditor2 != null ? textEditor2.getEditor() : null), vf);
        LessonContextImpl lessonContext = new LessonContextImpl(executor);
        TextEditor textEditor3 = textEditor;
        LessonManager.Companion.getInstance().initDslLesson$intellij_featuresTrainer((Editor)(textEditor3 != null ? textEditor3.getEditor() : null), lesson, executor);
        lesson.getLessonContent().invoke((Object)lessonContext);
        executor.startLesson();
    }

    private final void hideOtherViews(Project project) {
        ApplicationManager.getApplication().invokeLater(new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                LessonUtil.INSTANCE.hideStandardToolwindows(this.$project);
            }
            {
                this.$project = project;
            }
        });
    }

    private final void addStatisticLessonListenerIfNeeded(Project currentProject, Lesson lesson) {
        boolean bl;
        StatisticLessonListener statLessonListener;
        block4: {
            statLessonListener = new StatisticLessonListener(currentProject);
            Iterable $this$any$iv = lesson.getLessonListeners();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LessonListener it = (LessonListener)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof StatisticLessonListener)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (!bl) {
            lesson.addLessonListener(statLessonListener);
        }
    }

    private final void openReadme(Project project) {
        ProjectRootManager manager;
        ProjectRootManager projectRootManager = manager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"manager");
        VirtualFile root = projectRootManager.getContentRoots()[0];
        VirtualFile virtualFile = root;
        if (virtualFile == null || (virtualFile = virtualFile.findFileByRelativePath("README.md")) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"root?.findFileByRelative\u2026th(\"README.md\") ?: return");
        VirtualFile readme = virtualFile;
        FileEditorManager.getInstance((Project)project).openFile(readme, true, true);
    }

    public final void openLearnProjectFromWelcomeScreen() {
        this.initLearnProject(null, (Function1<? super Project, Unit>)((Function1)openLearnProjectFromWelcomeScreen.1.INSTANCE));
    }

    private final void showModules(Project project) {
        block0: {
            ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
            ToolWindow toolWindow = toolWindowManager.getToolWindow("Learn");
            if (toolWindow == null) break block0;
            toolWindow.show(null);
        }
    }

    @RequiresEdt
    private final void openLessonWhenLearnProjectStart(Lesson lesson, Project myLearnProject) {
        if (lesson.getProperties().getCanStartInDumbMode()) {
            this.openLessonForPreparedProject(myLearnProject, lesson);
            return;
        }
        Function0<Unit> $fun$openLesson$1 = new Function0<Unit>(myLearnProject, lesson){
            final /* synthetic */ Project $myLearnProject;
            final /* synthetic */ Lesson $lesson;

            public final void invoke() {
                ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.$myLearnProject);
                ToolWindow learnToolWindow = toolWindowManager.getToolWindow("Learn");
                if (learnToolWindow != null) {
                    Runnable runnable2 = this.$lesson.getProperties().getShowLearnToolwindowAtStart() ? null : (Runnable)new Runnable(learnToolWindow){
                        final /* synthetic */ ToolWindow $learnToolWindow;

                        public final void run() {
                            this.$learnToolWindow.hide();
                        }
                        {
                            this.$learnToolWindow = toolWindow;
                        }
                    };
                    DumbService.getInstance((Project)this.$myLearnProject).runWhenSmart(new Runnable(this, learnToolWindow, runnable2){
                        final /* synthetic */ openLessonWhenLearnProjectStart.1 this$0;
                        final /* synthetic */ ToolWindow $learnToolWindow;
                        final /* synthetic */ Runnable $runnable;

                        public final void run() {
                            Function0 openWhenSmart2;
                            this.$learnToolWindow.show(this.$runnable);
                            Function0 function0 = openWhenSmart2 = (Function0)new Function0<Unit>(this){
                                final /* synthetic */ openLessonWhenLearnProjectStart.1 this$0;

                                public final void invoke() {
                                    DumbService.getInstance((Project)this.this$0.this$0.$myLearnProject).runWhenSmart(new Runnable(this){
                                        final /* synthetic */ openLessonWhenLearnProjectStart.openWhenSmart.1 this$0;

                                        public final void run() {
                                            OpenLessonActivities.access$openLessonForPreparedProject(OpenLessonActivities.INSTANCE, this.this$0.this$0.this$0.$myLearnProject, this.this$0.this$0.this$0.$lesson);
                                        }
                                        {
                                            this.this$0 = var1_1;
                                        }
                                    });
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            };
                            new Alarm().addRequest((Runnable)new OpenLessonActivities$sam$java_lang_Runnable$0(function0), 500);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$learnToolWindow = toolWindow;
                            this.$runnable = runnable2;
                        }
                    });
                }
            }
            {
                this.$myLearnProject = project;
                this.$lesson = lesson;
                super(0);
            }
        };
        StartupManager startupManager = StartupManager.getInstance((Project)myLearnProject);
        if (startupManager instanceof StartupManagerEx && startupManager.postStartupActivityPassed()) {
            $fun$openLesson$1.invoke();
        } else {
            startupManager.registerPostStartupActivity(new Runnable($fun$openLesson$1){
                final /* synthetic */ openLessonWhenLearnProjectStart.1 $openLesson$1;

                public final void run() {
                    this.$openLesson$1.invoke();
                }
                {
                    this.$openLesson$1 = var1_1;
                }
            });
        }
    }

    private final VirtualFile getScratchFile(Project project, Lesson lesson, String filename) throws IOException {
        VirtualFile vf = null;
        Language languageByID = UtilsKt.findLanguageByID(lesson.getLang());
        if (CourseManager.Companion.getInstance().getMapModuleVirtualFile().containsKey(lesson.getModule())) {
            vf = CourseManager.Companion.getInstance().getMapModuleVirtualFile().get(lesson.getModule());
            ScratchFileService scratchFileService = ScratchFileService.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)scratchFileService, (String)"ScratchFileService.getInstance()");
            scratchFileService.getScratchesMapping().setMapping(vf, (Object)languageByID);
        }
        if (vf == null || !vf.isValid()) {
            vf = ScratchFileService.getInstance().findFile((RootType)ScratchRootType.getInstance(), filename, ScratchFileService.Option.existing_only);
            if (vf != null) {
                FileEditorManager.getInstance((Project)project).closeFile(vf);
                ScratchFileService scratchFileService = ScratchFileService.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)scratchFileService, (String)"ScratchFileService.getInstance()");
                scratchFileService.getScratchesMapping().setMapping(vf, (Object)languageByID);
            }
            if (vf == null || !vf.isValid()) {
                vf = ScratchRootType.getInstance().createScratchFile(project, filename, languageByID, "");
                boolean bl = vf != null;
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
            }
            CourseManager courseManager = CourseManager.Companion.getInstance();
            Module module = lesson.getModule();
            VirtualFile virtualFile = vf;
            Intrinsics.checkNotNull((Object)virtualFile);
            courseManager.registerVirtualFile(module, virtualFile);
        }
        return vf;
    }

    private final void askSwitchToLearnProjectBack(Project learnProject, Project currentProject) {
        Object[] objectArray = new Object[1];
        String string = learnProject.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"learnProject.name");
        objectArray[0] = string;
        Messages.showInfoMessage((Project)currentProject, (String)LearnBundle.INSTANCE.message("dialog.askToSwitchToLearnProject.message", objectArray), (String)LearnBundle.INSTANCE.message("dialog.askToSwitchToLearnProject.title", new Object[0]));
    }

    private final VirtualFile getFileInLearnProject(Lesson lesson) throws IOException {
        if (!lesson.getProperties().getOpenFileAtStart()) {
            LOG.debug(lesson.getName() + " does not open any file at the start");
            return null;
        }
        Computable<VirtualFile> function2 = new Computable<VirtualFile>(lesson){
            final /* synthetic */ Lesson $lesson;

            @NotNull
            public VirtualFile compute() {
                String string;
                Project project = LearningUiManager.INSTANCE.getLearnProject();
                Intrinsics.checkNotNull((Object)project);
                Project learnProject = project;
                String string2 = this.$lesson.getExistedFile();
                if (string2 == null) {
                    string2 = this.$lesson.getModule().getPrimaryLanguage().getProjectSandboxRelativePath();
                }
                String existedFile = string2;
                ProjectRootManager manager = ProjectRootManager.getInstance((Project)learnProject);
                if (existedFile != null) {
                    VirtualFile findFileByRelativePath;
                    VirtualFile root;
                    ProjectRootManager projectRootManager = manager;
                    Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"manager");
                    VirtualFile virtualFile = root = projectRootManager.getContentRoots()[0];
                    Object object = findFileByRelativePath = virtualFile != null ? virtualFile.findFileByRelativePath(existedFile) : null;
                    if (findFileByRelativePath != null) {
                        return findFileByRelativePath;
                    }
                }
                if ((string = existedFile) == null) {
                    string = this.$lesson.getFileName();
                }
                String fileName = string;
                VirtualFile lessonVirtualFile = null;
                ProjectRootManager projectRootManager = manager;
                Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"manager");
                VirtualFile[] roots = projectRootManager.getContentSourceRoots();
                Intrinsics.checkNotNullExpressionValue((Object)roots, (String)"roots");
                VirtualFile[] virtualFileArray = roots;
                int n = 0;
                if (virtualFileArray.length == 0) {
                    roots = manager.getContentRoots();
                }
                VirtualFile[] virtualFileArray2 = roots;
                int n2 = virtualFileArray2.length;
                for (n = 0; n < n2; ++n) {
                    VirtualFile file;
                    VirtualFile virtualFile = file = virtualFileArray2[n];
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file");
                    if (Intrinsics.areEqual((Object)virtualFile.getName(), (Object)fileName)) {
                        lessonVirtualFile = file;
                        break;
                    }
                    lessonVirtualFile = file.findChild(fileName);
                    if (lessonVirtualFile != null) break;
                }
                if (lessonVirtualFile == null) {
                    lessonVirtualFile = roots[0].createChildData((Object)this, fileName);
                }
                CourseManager.Companion.getInstance().registerVirtualFile(this.$lesson.getModule(), lessonVirtualFile);
                return lessonVirtualFile;
            }
            {
                this.$lesson = $captured_local_variable$0;
            }
        };
        VirtualFile vf = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)function2);
        boolean bl = vf instanceof VirtualFile;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return vf;
    }

    private final void initLearnProject(Project projectToClose, Function1<? super Project, Unit> postInitCallback) {
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport2 == null) {
            throw (Throwable)new Exception("Language for learning plugin is not defined");
        }
        LangSupport langSupport3 = langSupport2;
        Project project = this.findLearnProjectInOpenedProjects(langSupport3);
        if (project != null) {
            Project project2 = project;
            boolean bl = false;
            boolean bl2 = false;
            Project it = project2;
            boolean bl3 = false;
            postInitCallback.invoke((Object)it);
            return;
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode() && projectToClose != null && !NewLearnProjectUtil.INSTANCE.showDialogOpenLearnProject(projectToClose)) {
            return;
        }
        try {
            NewLearnProjectUtil.INSTANCE.createLearnProject(projectToClose, langSupport3, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(langSupport3, postInitCallback){
                final /* synthetic */ LangSupport $langSupport;
                final /* synthetic */ Function1 $postInitCallback;

                public final void invoke(@NotNull Project learnProject) {
                    Application app$iv;
                    Intrinsics.checkNotNullParameter((Object)learnProject, (String)"learnProject");
                    this.$langSupport.applyToProjectAfterConfigure().invoke((Object)learnProject);
                    LearningUiManager.INSTANCE.setLearnProject(learnProject);
                    ModalityState modalityState$iv = null;
                    boolean $i$f$runInEdt = false;
                    Application application = app$iv = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
                    if (application.isDispatchThread()) {
                        boolean bl = false;
                        this.$postInitCallback.invoke((Object)learnProject);
                    } else {
                        boolean $i$f$invokeLater = false;
                        Application application2 = ApplicationManager.getApplication();
                        Runnable runnable2 = new Runnable(this, learnProject){
                            final /* synthetic */ initLearnProject.2 this$0;
                            final /* synthetic */ Project $learnProject$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$learnProject$inlined = project;
                            }

                            public final void run() {
                                boolean bl = false;
                                this.this$0.$postInitCallback.invoke((Object)this.$learnProject$inlined);
                            }
                        };
                        ModalityState modalityState = ModalityState.defaultModalityState();
                        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                        application2.invokeLater(runnable2, modalityState);
                    }
                }
                {
                    this.$langSupport = langSupport2;
                    this.$postInitCallback = function1;
                    super(1);
                }
            }));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private final Project findLearnProjectInOpenedProjects(LangSupport langSupport2) {
        Project project;
        block1: {
            Project[] openProjects;
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project[] projectArray = projectManager.getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
            Project[] $this$firstOrNull$iv = openProjects = projectArray;
            boolean $i$f$firstOrNull = false;
            Project[] projectArray2 = $this$firstOrNull$iv;
            int n = projectArray2.length;
            for (int j = 0; j < n; ++j) {
                Project element$iv;
                Project it = element$iv = projectArray2[j];
                boolean bl = false;
                Project project2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"it");
                if (!UtilsKt.isLearningProject(project2, langSupport2)) continue;
                project = element$iv;
                break block1;
            }
            project = null;
        }
        return project;
    }

    private OpenLessonActivities() {
    }

    static {
        OpenLessonActivities openLessonActivities;
        INSTANCE = openLessonActivities = new OpenLessonActivities();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(OpenLessonActivities.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$p(OpenLessonActivities $this) {
        OpenLessonActivities openLessonActivities = $this;
        return LOG;
    }

    public static final /* synthetic */ void access$openLessonWhenLearnProjectStart(OpenLessonActivities $this, Lesson lesson, Project myLearnProject) {
        $this.openLessonWhenLearnProjectStart(lesson, myLearnProject);
    }

    public static final /* synthetic */ void access$openLessonForPreparedProject(OpenLessonActivities $this, Project project, Lesson lesson) {
        $this.openLessonForPreparedProject(project, lesson);
    }

    public static final /* synthetic */ void access$openReadme(OpenLessonActivities $this, Project project) {
        $this.openReadme(project);
    }

    public static final /* synthetic */ void access$hideOtherViews(OpenLessonActivities $this, Project project) {
        $this.hideOtherViews(project);
    }

    public static final /* synthetic */ void access$showModules(OpenLessonActivities $this, Project project) {
        $this.showModules(project);
    }
}

