/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.formatting.ASTBlock;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinObsoleteCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\"\u0010\u0004\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u001a\"\u0010\u0004\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\f2\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u001a\u001a\u0010\r\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\u001a\n\u0010\u0011\u001a\u00020\u000f*\u00020\u0002\u001a!\u0010\u0012\u001a\u0004\u0018\u00010\u000f*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0015\u001a\f\u0010\u0016\u001a\u00020\u0001*\u0004\u0018\u00010\u0002\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\u0002\u001a*\u0010\u0018\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\b\b\u0002\u0010\u0019\u001a\u00020\u00012\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010\u001b\u001a \u0010\u001c\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\b\b\u0002\u0010\u0019\u001a\u00020\u00012\b\b\u0002\u0010\u001d\u001a\u00020\u0001\u001a \u0010\u001e\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\b\b\u0002\u0010\u0019\u001a\u00020\u00012\b\b\u0002\u0010\u001d\u001a\u00020\u0001\u001a\u000f\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b!*\u00020\"\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006#"}, d2={"isComma", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Z", "applyKotlinCodeStyle", "codeStyleId", "", "codeStyleSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "modifyCodeStyle", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinCodeStyleSettings;", "containsLineBreakInChild", "globalStartOffset", "", "globalEndOffset", "getLineCount", "getLineCountByDocument", "startOffset", "endOffset", "(Lcom/intellij/psi/PsiElement;II)Ljava/lang/Integer;", "isLineBreak", "isMultiline", "leaf", "forward", "filter", "Lkotlin/Function1;", "leafIgnoringWhitespace", "skipEmptyElements", "leafIgnoringWhitespaceAndComments", "requireNode", "Lcom/intellij/lang/ASTNode;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/formatting/ASTBlock;", "kotlin.formatter"})
public final class FormatterUtilKt {
    @NotNull
    public static final ASTNode requireNode(@NotNull ASTBlock $this$requireNode) {
        Intrinsics.checkNotNullParameter((Object)$this$requireNode, (String)"$this$requireNode");
        ASTNode aSTNode = $this$requireNode.getNode();
        if (aSTNode == null) {
            String string = "ASTBlock.getNode() returned null";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node ?: error(\"ASTBlock.getNode() returned null\")");
        return aSTNode;
    }

    public static final int getLineCount(@NotNull PsiElement $this$getLineCount) {
        int n;
        TextRange spaceRange;
        Intrinsics.checkNotNullParameter((Object)$this$getLineCount, (String)"$this$getLineCount");
        TextRange textRange = $this$getLineCount.getTextRange();
        if (textRange == null) {
            textRange = TextRange.EMPTY_RANGE;
        }
        TextRange textRange2 = spaceRange = textRange;
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"spaceRange");
        Integer n2 = FormatterUtilKt.getLineCountByDocument($this$getLineCount, textRange2.getStartOffset(), spaceRange.getEndOffset());
        if (n2 != null) {
            n = n2;
        } else {
            String string = $this$getLineCount.getText();
            if (string == null) {
                String string2 = "Cannot count number of lines";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            n = StringUtil.getLineBreakCount((CharSequence)string) + 1;
        }
        return n;
    }

    @Nullable
    public static final Integer getLineCountByDocument(@NotNull PsiElement $this$getLineCountByDocument, int startOffset, int endOffset) {
        PsiFile psiFile;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)$this$getLineCountByDocument, (String)"$this$getLineCountByDocument");
                psiFile = $this$getLineCountByDocument.getContainingFile();
                if (psiFile == null) break block4;
                PsiFile psiFile2 = psiFile;
                boolean bl = false;
                boolean bl2 = false;
                PsiFile it = psiFile2;
                boolean bl3 = false;
                psiFile = PsiDocumentManager.getInstance((Project)$this$getLineCountByDocument.getProject()).getDocument(it);
                if (psiFile != null) break block5;
            }
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"containingFile?.let { Ps\u2026ment(it) } ?: return null");
        PsiFile doc = psiFile;
        if (endOffset > doc.getTextLength() || startOffset >= endOffset) {
            return null;
        }
        int startLine = doc.getLineNumber(startOffset);
        int endLine = doc.getLineNumber(endOffset);
        return endLine - startLine + 1;
    }

    public static final boolean isMultiline(@NotNull PsiElement $this$isMultiline) {
        Intrinsics.checkNotNullParameter((Object)$this$isMultiline, (String)"$this$isMultiline");
        return FormatterUtilKt.getLineCount($this$isMultiline) > 1;
    }

    public static final boolean isLineBreak(@Nullable PsiElement $this$isLineBreak) {
        return $this$isLineBreak instanceof PsiWhiteSpace && StringUtil.containsLineBreak((CharSequence)((PsiWhiteSpace)$this$isLineBreak).getText());
    }

    @Nullable
    public static final PsiElement leafIgnoringWhitespace(@NotNull PsiElement $this$leafIgnoringWhitespace, boolean forward, boolean skipEmptyElements) {
        Intrinsics.checkNotNullParameter((Object)$this$leafIgnoringWhitespace, (String)"$this$leafIgnoringWhitespace");
        return FormatterUtilKt.leaf($this$leafIgnoringWhitespace, forward, (Function1<? super PsiElement, Boolean>)((Function1)new Function1<PsiElement, Boolean>(skipEmptyElements){
            final /* synthetic */ boolean $skipEmptyElements;

            public final boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (!this.$skipEmptyElements || it.getTextLength() != 0) && !(it instanceof PsiWhiteSpace);
            }
            {
                this.$skipEmptyElements = bl;
                super(1);
            }
        }));
    }

    public static /* synthetic */ PsiElement leafIgnoringWhitespace$default(PsiElement psiElement, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return FormatterUtilKt.leafIgnoringWhitespace(psiElement, bl, bl2);
    }

    @Nullable
    public static final PsiElement leafIgnoringWhitespaceAndComments(@NotNull PsiElement $this$leafIgnoringWhitespaceAndComments, boolean forward, boolean skipEmptyElements) {
        Intrinsics.checkNotNullParameter((Object)$this$leafIgnoringWhitespaceAndComments, (String)"$this$leafIgnoringWhitespaceAndComments");
        return FormatterUtilKt.leaf($this$leafIgnoringWhitespaceAndComments, forward, (Function1<? super PsiElement, Boolean>)((Function1)new Function1<PsiElement, Boolean>(skipEmptyElements){
            final /* synthetic */ boolean $skipEmptyElements;

            public final boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (!this.$skipEmptyElements || it.getTextLength() != 0) && !(it instanceof PsiWhiteSpace) && !(it instanceof PsiComment);
            }
            {
                this.$skipEmptyElements = bl;
                super(1);
            }
        }));
    }

    public static /* synthetic */ PsiElement leafIgnoringWhitespaceAndComments$default(PsiElement psiElement, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return FormatterUtilKt.leafIgnoringWhitespaceAndComments(psiElement, bl, bl2);
    }

    @Nullable
    public static final PsiElement leaf(@NotNull PsiElement $this$leaf, boolean forward, @NotNull Function1<? super PsiElement, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)$this$leaf, (String)"$this$leaf");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return forward ? PsiUtilsKt.nextLeaf((PsiElement)$this$leaf, filter) : PsiUtilsKt.prevLeaf((PsiElement)$this$leaf, filter);
    }

    public static /* synthetic */ PsiElement leaf$default(PsiElement psiElement, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return FormatterUtilKt.leaf(psiElement, bl, (Function1<? super PsiElement, Boolean>)function1);
    }

    public static final boolean isComma(@NotNull PsiElement $this$isComma) {
        Intrinsics.checkNotNullParameter((Object)$this$isComma, (String)"$this$isComma");
        return Intrinsics.areEqual((Object)PsiUtil.getElementType((PsiElement)$this$isComma), (Object)KtTokens.COMMA);
    }

    public static final boolean containsLineBreakInChild(@NotNull PsiElement $this$containsLineBreakInChild, int globalStartOffset, int globalEndOffset) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$containsLineBreakInChild, (String)"$this$containsLineBreakInChild");
            Integer n = FormatterUtilKt.getLineCountByDocument($this$containsLineBreakInChild, globalStartOffset, globalEndOffset);
            if (n != null) {
                Integer n2 = n;
                boolean bl2 = false;
                boolean bl3 = false;
                int it = ((Number)n2).intValue();
                boolean bl4 = false;
                bl = it > 1;
            } else {
                PsiElement psiElement = $this$containsLineBreakInChild.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"firstChild");
                Sequence $this$any$iv = SequencesKt.takeWhile((Sequence)SequencesKt.dropWhile((Sequence)PsiUtilsKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true), (Function1)((Function1)new Function1<PsiElement, Boolean>(globalStartOffset){
                    final /* synthetic */ int $globalStartOffset;

                    public final boolean invoke(@NotNull PsiElement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return PsiUtilsKt.getStartOffset((PsiElement)it) < this.$globalStartOffset;
                    }
                    {
                        this.$globalStartOffset = n;
                        super(1);
                    }
                })), (Function1)((Function1)new Function1<PsiElement, Boolean>(globalEndOffset){
                    final /* synthetic */ int $globalEndOffset;

                    public final boolean invoke(@NotNull PsiElement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return PsiUtilsKt.getEndOffset((PsiElement)it) <= this.$globalEndOffset;
                    }
                    {
                        this.$globalEndOffset = n;
                        super(1);
                    }
                }));
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl5 = false;
                    if (!(it.textContains('\n') || it.textContains('\r'))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void applyKotlinCodeStyle(@Nullable String codeStyleId, @NotNull KotlinCodeStyleSettings codeStyleSettings, boolean modifyCodeStyle) {
        Intrinsics.checkNotNullParameter((Object)((Object)codeStyleSettings), (String)"codeStyleSettings");
        String string = codeStyleId;
        if (string == null) {
            return;
        }
        switch (string) {
            case "KOTLIN_OFFICIAL": {
                KotlinStyleGuideCodeStyle.Companion.applyToKotlinCustomSettings(codeStyleSettings, modifyCodeStyle);
                return;
            }
            case "KOTLIN_OLD_DEFAULTS": {
                KotlinObsoleteCodeStyle.Companion.applyToKotlinCustomSettings(codeStyleSettings, modifyCodeStyle);
                return;
            }
        }
    }

    public static /* synthetic */ void applyKotlinCodeStyle$default(String string, KotlinCodeStyleSettings kotlinCodeStyleSettings, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        FormatterUtilKt.applyKotlinCodeStyle(string, kotlinCodeStyleSettings, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void applyKotlinCodeStyle(@Nullable String codeStyleId, @NotNull CommonCodeStyleSettings codeStyleSettings, boolean modifyCodeStyle) {
        Intrinsics.checkNotNullParameter((Object)codeStyleSettings, (String)"codeStyleSettings");
        String string = codeStyleId;
        if (string == null) {
            return;
        }
        switch (string) {
            case "KOTLIN_OFFICIAL": {
                KotlinStyleGuideCodeStyle.Companion.applyToCommonSettings(codeStyleSettings, modifyCodeStyle);
                return;
            }
            case "KOTLIN_OLD_DEFAULTS": {
                KotlinObsoleteCodeStyle.Companion.applyToCommonSettings(codeStyleSettings, modifyCodeStyle);
                return;
            }
        }
    }

    public static /* synthetic */ void applyKotlinCodeStyle$default(String string, CommonCodeStyleSettings commonCodeStyleSettings, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        FormatterUtilKt.applyKotlinCodeStyle(string, commonCodeStyleSettings, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean applyKotlinCodeStyle(@Nullable String codeStyleId, @NotNull CodeStyleSettings codeStyleSettings) {
        Intrinsics.checkNotNullParameter((Object)codeStyleSettings, (String)"codeStyleSettings");
        String string = codeStyleId;
        if (string == null) return false;
        switch (string) {
            case "KOTLIN_OFFICIAL": {
                KotlinStyleGuideCodeStyle.Companion.apply(codeStyleSettings);
                return true;
            }
            case "KOTLIN_OLD_DEFAULTS": {
                KotlinObsoleteCodeStyle.Companion.apply(codeStyleSettings);
                return true;
            }
            default: {
                return false;
            }
        }
    }
}

