/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.osgi.p2;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.internal.impldep.org.apache.ivy.osgi.p2.P2Artifact;
import org.gradle.internal.impldep.org.apache.ivy.osgi.p2.P2Descriptor;
import org.gradle.internal.impldep.org.apache.ivy.osgi.p2.PropertiesParser;
import org.gradle.internal.impldep.org.apache.ivy.osgi.p2.XMLInputParser;
import org.gradle.internal.impldep.org.apache.ivy.osgi.util.DelegetingHandler;
import org.gradle.internal.impldep.org.apache.ivy.osgi.util.Version;
import org.gradle.internal.impldep.org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class P2ArtifactParser
implements XMLInputParser {
    private final P2Descriptor p2Descriptor;
    private final String repoUrl;

    public P2ArtifactParser(P2Descriptor p2Descriptor, String repoUrl) {
        this.p2Descriptor = p2Descriptor;
        this.repoUrl = repoUrl;
    }

    public void parse(InputStream in) throws ParseException, IOException, SAXException {
        RepositoryHandler handler = new RepositoryHandler(this.p2Descriptor, this.repoUrl);
        try {
            XMLHelper.parse(in, null, (DefaultHandler)handler, null);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    static class ArtifactHandler
    extends DelegetingHandler {
        private static final String ARTIFACT = "artifact";
        private static final String CLASSIFIER = "classifier";
        private static final String ID = "id";
        private static final String VERSION = "version";
        P2Artifact p2Artifact;

        public ArtifactHandler() {
            super(ARTIFACT);
            this.addChild(new PropertiesParser.PropertiesHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                }
            });
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            Version version;
            String id = atts.getValue(ID);
            try {
                version = new Version(atts.getValue(VERSION));
            }
            catch (ParseException e) {
                throw new SAXException("Incorrect version attribute on artifact '" + id + "': " + atts.getValue(VERSION) + " (" + e.getMessage() + ")");
            }
            String classifier = atts.getValue(CLASSIFIER);
            this.p2Artifact = new P2Artifact(id, version, classifier);
        }
    }

    static class ArtifactsHandler
    extends DelegetingHandler {
        private static final String ARTIFACTS = "artifacts";

        public ArtifactsHandler(final P2Descriptor p2Descriptor, final Map patternsByClassifier, final String repoUrl) {
            super(ARTIFACTS);
            this.addChild(new ArtifactHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    P2Artifact a = ((ArtifactHandler)child).p2Artifact;
                    String url = (String)patternsByClassifier.get(a.getClassifier());
                    url = url.replaceAll("\\$\\{repoUrl\\}", repoUrl);
                    p2Descriptor.addArtifactUrl(a.getClassifier(), a.getId(), a.getVersion(), url);
                }
            });
        }
    }

    static class RuleHandler
    extends DelegetingHandler {
        private static final String RULE = "rule";
        private static final String FILTER = "filter";
        private static final String OUTPUT = "output";
        private String filter;
        private String output;

        public RuleHandler() {
            super(RULE);
        }

        protected void handleAttributes(Attributes atts) {
            this.filter = atts.getValue(FILTER);
            this.output = atts.getValue(OUTPUT);
        }
    }

    static class MappingsHandler
    extends DelegetingHandler {
        private static final String MAPPINGS = "mappings";
        private static final String SIZE = "size";
        Map outputByFilter;

        public MappingsHandler() {
            super(MAPPINGS);
            this.addChild(new RuleHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    MappingsHandler.this.outputByFilter.put(((RuleHandler)child).filter, ((RuleHandler)child).output);
                }
            });
        }

        protected void handleAttributes(Attributes atts) {
            int size = Integer.parseInt(atts.getValue(SIZE));
            this.outputByFilter = new HashMap(size);
        }
    }

    static class RepositoryHandler
    extends DelegetingHandler {
        private static final String REPOSITORY = "repository";
        private Map patternsByClassifier = new HashMap();

        public RepositoryHandler(P2Descriptor p2Descriptor, String repoUrl) {
            super(REPOSITORY);
            this.addChild(new MappingsHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    Iterator it = ((MappingsHandler)child).outputByFilter.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        String filter = (String)entry.getKey();
                        if (filter.startsWith("(& (classifier=") && filter.endsWith("")) {
                            String classifier = filter.substring(15, filter.length() - 2);
                            RepositoryHandler.this.patternsByClassifier.put(classifier, entry.getValue());
                            continue;
                        }
                        throw new IllegalStateException();
                    }
                }
            });
            this.addChild(new ArtifactsHandler(p2Descriptor, this.patternsByClassifier, repoUrl), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                }
            });
        }
    }
}

