/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.commons.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.gradle.internal.impldep.org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="1.0")
public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static RuntimeException throwAsUncheckedException(Throwable t) {
        Preconditions.notNull(t, "Throwable must not be null");
        ExceptionUtils.throwAs(t);
        return null;
    }

    private static <T extends Throwable> void throwAs(Throwable t) throws T {
        throw t;
    }

    public static String readStackTrace(Throwable throwable) {
        Preconditions.notNull(throwable, "Throwable must not be null");
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }
}

