/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.util.lease;

import java.util.concurrent.TimeUnit;
import org.gradle.internal.impldep.org.simpleframework.util.lease.Cleaner;
import org.gradle.internal.impldep.org.simpleframework.util.lease.Contract;
import org.gradle.internal.impldep.org.simpleframework.util.lease.ContractQueue;
import org.gradle.internal.impldep.org.simpleframework.util.lease.LeaseException;
import org.gradle.internal.impldep.org.simpleframework.util.thread.Daemon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LeaseCleaner<T>
extends Daemon {
    private ContractQueue<T> queue = new ContractQueue();
    private Cleaner<T> cleaner;
    private volatile boolean dead;

    public LeaseCleaner(Cleaner<T> cleaner) {
        this.cleaner = cleaner;
        this.start();
    }

    public boolean revoke(Contract<T> contract) throws LeaseException {
        if (this.dead) {
            throw new LeaseException("Lease can not be revoked", new Object[0]);
        }
        return this.queue.remove(contract);
    }

    public boolean issue(Contract<T> contract) throws LeaseException {
        if (this.dead) {
            throw new LeaseException("Lease can not be issued", new Object[0]);
        }
        return this.queue.offer(contract);
    }

    @Override
    public void run() {
        while (!this.dead) {
            try {
                this.clean();
            }
            catch (Throwable e) {}
        }
        this.purge();
    }

    private void clean() throws Exception {
        Contract next = (Contract)this.queue.take();
        Object key = next.getKey();
        if (key != null) {
            this.cleaner.clean(key);
        }
    }

    private void purge() {
        for (Contract contract : this.queue) {
            Object key = contract.getKey();
            try {
                contract.setDelay(0L, TimeUnit.NANOSECONDS);
                this.cleaner.clean(key);
            }
            catch (Throwable e) {}
        }
    }

    public void close() {
        this.dead = true;
        this.interrupt();
    }
}

