/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection.metadata;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.intellij.internal.statistic.StatisticsStringUtil;
import com.intellij.internal.statistic.eventLog.connection.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupFilterRules;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupRemoteDescriptors;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupsFilterRules;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataLoadException;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataParseException;
import com.intellij.internal.statistic.eventLog.connection.request.StatsHttpRequests;
import com.intellij.internal.statistic.eventLog.connection.request.StatsRequestResult;
import com.intellij.internal.statistic.eventLog.connection.request.StatsResponseException;
import java.io.IOException;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventLogMetadataUtils {
    @NotNull
    public static EventGroupsFilterRules loadAndParseGroupsFilterRules(@NotNull String serviceUrl, @NotNull EventLogConnectionSettings settings) {
        if (serviceUrl == null) {
            EventLogMetadataUtils.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            EventLogMetadataUtils.$$$reportNull$$$0(1);
        }
        try {
            String content = EventLogMetadataUtils.loadMetadataFromServer(serviceUrl, settings);
            return EventLogMetadataUtils.parseGroupFilterRules(content);
        }
        catch (EventLogMetadataLoadException | EventLogMetadataParseException e) {
            EventGroupsFilterRules eventGroupsFilterRules = EventGroupsFilterRules.empty();
            if (eventGroupsFilterRules == null) {
                EventLogMetadataUtils.$$$reportNull$$$0(2);
            }
            return eventGroupsFilterRules;
        }
    }

    @NotNull
    public static EventGroupsFilterRules parseGroupFilterRules(@Nullable String content) throws EventLogMetadataParseException {
        EventGroupRemoteDescriptors groups = EventLogMetadataUtils.parseGroupRemoteDescriptors(content);
        HashMap<String, EventGroupFilterRules> groupToCondition = new HashMap<String, EventGroupFilterRules>();
        for (EventGroupRemoteDescriptors.EventGroupRemoteDescriptor group : groups.groups) {
            groupToCondition.put(group.id, EventGroupFilterRules.create(group));
        }
        EventGroupsFilterRules eventGroupsFilterRules = EventGroupsFilterRules.create(groupToCondition);
        if (eventGroupsFilterRules == null) {
            EventLogMetadataUtils.$$$reportNull$$$0(3);
        }
        return eventGroupsFilterRules;
    }

    @NotNull
    public static EventGroupRemoteDescriptors parseGroupRemoteDescriptors(@Nullable String content) throws EventLogMetadataParseException {
        block6: {
            if (StatisticsStringUtil.isEmptyOrSpaces((String)content)) {
                throw new EventLogMetadataParseException(EventLogMetadataParseException.EventLogMetadataParseErrorType.EMPTY_CONTENT);
            }
            EventGroupRemoteDescriptors groups = (EventGroupRemoteDescriptors)new GsonBuilder().create().fromJson(content, EventGroupRemoteDescriptors.class);
            if (groups == null) break block6;
            EventGroupRemoteDescriptors eventGroupRemoteDescriptors = groups;
            if (eventGroupRemoteDescriptors == null) {
                EventLogMetadataUtils.$$$reportNull$$$0(4);
            }
            return eventGroupRemoteDescriptors;
        }
        try {
            throw new EventLogMetadataParseException(EventLogMetadataParseException.EventLogMetadataParseErrorType.INVALID_JSON);
        }
        catch (JsonSyntaxException e) {
            throw new EventLogMetadataParseException(EventLogMetadataParseException.EventLogMetadataParseErrorType.INVALID_JSON, (Throwable)e);
        }
        catch (Exception e) {
            throw new EventLogMetadataParseException(EventLogMetadataParseException.EventLogMetadataParseErrorType.UNKNOWN, (Throwable)e);
        }
    }

    @NotNull
    public static String loadMetadataFromServer(@Nullable String serviceUrl, @NotNull EventLogConnectionSettings settings) throws EventLogMetadataLoadException {
        StatsRequestResult<String> result;
        block6: {
            if (settings == null) {
                EventLogMetadataUtils.$$$reportNull$$$0(5);
            }
            if (StatisticsStringUtil.isEmptyOrSpaces((String)serviceUrl)) {
                throw new EventLogMetadataLoadException(EventLogMetadataLoadException.EventLogMetadataLoadErrorType.EMPTY_SERVICE_URL);
            }
            result = StatsHttpRequests.request(serviceUrl, settings).send(r -> r.readAsString());
            if (!result.isSucceed()) break block6;
            String string = result.getResult();
            if (string == null) {
                EventLogMetadataUtils.$$$reportNull$$$0(6);
            }
            return string;
        }
        try {
            throw new EventLogMetadataLoadException(EventLogMetadataLoadException.EventLogMetadataLoadErrorType.UNREACHABLE_SERVICE, result.getError());
        }
        catch (StatsResponseException | IOException e) {
            throw new EventLogMetadataLoadException(EventLogMetadataLoadException.EventLogMetadataLoadErrorType.ERROR_ON_LOAD, (Throwable)e);
        }
    }

    public static long lastModifiedMetadata(@Nullable String serviceUrl, @NotNull EventLogConnectionSettings settings) {
        if (settings == null) {
            EventLogMetadataUtils.$$$reportNull$$$0(7);
        }
        if (StatisticsStringUtil.isEmptyOrSpaces((String)serviceUrl)) {
            return 0L;
        }
        try {
            StatsRequestResult<Long> result = StatsHttpRequests.head(serviceUrl, settings).send(r -> r.lastModified());
            return result.getResult() != null ? result.getResult() : 0L;
        }
        catch (StatsResponseException | IOException e) {
            return 0L;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceUrl";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/connection/metadata/EventLogMetadataUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/connection/metadata/EventLogMetadataUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndParseGroupsFilterRules";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseGroupFilterRules";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseGroupRemoteDescriptors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadMetadataFromServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadAndParseGroupsFilterRules";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadMetadataFromServer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lastModifiedMetadata";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

