/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.InstallMetrics;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.AndroidVersion;
import com.android.tools.deployer.ApkInstaller;
import com.android.tools.deployer.InstallStatus;
import com.android.tools.tracer.Trace;
import com.android.utils.ILogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class AdbClient {
    private final IDevice device;
    private final ILogger logger;
    public static final long DEFAULT_TIMEOUT = 5L;
    public static final TimeUnit DEFAULT_TIMEUNIT = TimeUnit.MINUTES;

    public AdbClient(IDevice device, ILogger logger) {
        this.device = device;
        this.logger = logger;
    }

    public byte[] shell(String[] parameters) throws IOException {
        return this.shell(parameters, null);
    }

    public byte[] shell(String[] parameters, InputStream input) throws IOException {
        return this.shell(parameters, input, 5L, DEFAULT_TIMEUNIT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] shell(String[] parameters, InputStream input, long maxTimeOutMs, TimeUnit timeUnit) throws IOException {
        try (Trace ignored = Trace.begin((String)("adb shell" + Arrays.toString(parameters)));){
            ByteArrayOutputReceiver receiver = new ByteArrayOutputReceiver();
            this.device.executeShellCommand(String.join((CharSequence)" ", parameters), (IShellOutputReceiver)receiver, maxTimeOutMs, timeUnit, input);
            byte[] byArray = receiver.toByteArray();
            return byArray;
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] binder(String[] parameters, InputStream input) throws IOException {
        this.logger.info("BINDER: " + String.join((CharSequence)" ", parameters), new Object[0]);
        try (Trace ignored = Trace.begin((String)("binder" + Arrays.toString(parameters)));){
            ByteArrayOutputReceiver receiver = new ByteArrayOutputReceiver();
            this.device.executeBinderCommand(parameters, (IShellOutputReceiver)receiver, 5L, TimeUnit.MINUTES, input);
            byte[] byArray = receiver.toByteArray();
            return byArray;
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException e) {
            throw new IOException(e);
        }
    }

    public InstallResult install(List<String> apks, List<String> options, boolean reinstall) {
        List files = apks.stream().map(File::new).collect(Collectors.toList());
        try {
            if (this.device.getVersion().isGreaterOrEqualThan(21)) {
                this.device.installPackages(files, reinstall, options, 5L, TimeUnit.MINUTES);
                return new InstallResult(InstallStatus.OK, null, this.device.getLastInstallMetrics());
            }
            if (apks.size() != 1) {
                return new InstallResult(InstallStatus.MULTI_APKS_NO_SUPPORTED_BELOW21);
            }
            this.device.installPackage(apks.get(0), reinstall, options.toArray(new String[0]));
            return new InstallResult(InstallStatus.OK, null, this.device.getLastInstallMetrics());
        }
        catch (InstallException e) {
            String code = e.getErrorCode();
            if (code != null) {
                try {
                    return ApkInstaller.parseInstallerResultErrorCode(code);
                }
                catch (IllegalArgumentException | NullPointerException ignored) {
                    this.logger.warning("Unrecognized Installation Failure: %s\n%s\n", new Object[]{code, e.getMessage()});
                }
            } else {
                Throwable cause = e.getCause();
                if (cause instanceof ShellCommandUnresponsiveException) {
                    return new InstallResult(InstallStatus.SHELL_UNRESPONSIVE);
                }
                this.logger.warning("Installation Failure: %s\n", new Object[]{e.getMessage()});
                return new InstallResult(InstallStatus.UNKNOWN_ERROR, e.getMessage(), null);
            }
            return new InstallResult(InstallStatus.UNKNOWN_ERROR);
        }
    }

    public boolean uninstall(String packageName) {
        try {
            this.device.uninstallPackage(packageName);
            return true;
        }
        catch (InstallException installException) {
            return false;
        }
    }

    public List<String> getAbis() {
        return this.device.getAbis();
    }

    public void push(String from, String to) throws IOException {
        try (Trace ignored = Trace.begin((String)"adb push");){
            this.device.pushFile(from, to);
        }
        catch (AdbCommandRejectedException | SyncException | TimeoutException e) {
            throw new IOException(e);
        }
    }

    public AndroidVersion getVersion() {
        return this.device.getVersion();
    }

    public String abortSession(String sessionId) {
        String response;
        String prefix = this.device.getVersion().isGreaterOrEqualThan(24) ? "cmd package" : "pm";
        String[] command = new String[]{prefix, "install-abandon", sessionId};
        try {
            byte[] bytes = this.shell(command);
            response = new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            response = e.getMessage();
        }
        return response;
    }

    private class ByteArrayOutputReceiver
    implements IShellOutputReceiver {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();

        private ByteArrayOutputReceiver() {
        }

        public void addOutput(byte[] data, int offset, int length) {
            this.stream.write(data, offset, length);
        }

        public void flush() {
        }

        public boolean isCancelled() {
            return false;
        }

        byte[] toByteArray() {
            return this.stream.toByteArray();
        }
    }

    static class InstallResult {
        public final InstallStatus status;
        public final String reason;
        public final InstallMetrics metrics;

        InstallResult(InstallStatus status) {
            this.status = status;
            this.reason = null;
            this.metrics = null;
        }

        InstallResult(InstallStatus status, String reason, InstallMetrics metrics) {
            this.status = status;
            this.reason = reason;
            this.metrics = metrics;
        }
    }
}

