/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.ApkDiffer;
import com.android.tools.deployer.ApkFileDatabase;
import com.android.tools.deployer.ApkInstaller;
import com.android.tools.deployer.ApkParser;
import com.android.tools.deployer.ApkPreInstaller;
import com.android.tools.deployer.ApkSwapper;
import com.android.tools.deployer.ApplicationDumper;
import com.android.tools.deployer.CachedDexSplitter;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.D8DexSplitter;
import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DexComparator;
import com.android.tools.deployer.DexSplitter;
import com.android.tools.deployer.InstallOptions;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.SwapVerifier;
import com.android.tools.deployer.UIService;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.tasks.Task;
import com.android.tools.deployer.tasks.TaskResult;
import com.android.tools.deployer.tasks.TaskRunner;
import com.android.tools.tracer.Trace;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Deployer {
    public static final String BASE_DIRECTORY = "/data/local/tmp/.studio";
    public static final String INSTALLER_DIRECTORY = "/data/local/tmp/.studio/bin";
    private final AdbClient adb;
    private final ApkFileDatabase db;
    private final Installer installer;
    private final TaskRunner runner;
    private final UIService service;
    private final Collection<DeployMetric> metrics;
    private final ILogger logger;

    public Deployer(AdbClient adb, ApkFileDatabase db, TaskRunner runner, Installer installer, UIService service, Collection<DeployMetric> metrics, ILogger logger) {
        this.adb = adb;
        this.db = db;
        this.runner = runner;
        this.installer = installer;
        this.service = service;
        this.metrics = metrics;
        this.logger = logger;
    }

    public Result install(String packageName, List<String> apks, InstallOptions options, InstallMode installMode) throws DeployerException {
        Result result = new Result();
        try (Trace ignored = Trace.begin((String)"install");){
            ApkInstaller apkInstaller = new ApkInstaller(this.adb, this.service, this.installer, this.logger);
            result.skippedInstall = !apkInstaller.install(packageName, apks, options, installMode, this.metrics);
            Task<List<String>> paths = this.runner.create(apks);
            CachedDexSplitter splitter = new CachedDexSplitter(this.db, new D8DexSplitter());
            Task<List> apkList = this.runner.create(Tasks.PARSE_PATHS, new ApkParser()::parsePaths, paths);
            this.runner.create(Tasks.CACHE, splitter::cache, apkList);
            this.runner.runAsync();
            Result result2 = result;
            return result2;
        }
    }

    public Result codeSwap(List<String> apks, Map<Integer, ClassRedefiner> redefiners) throws DeployerException {
        try (Trace ignored = Trace.begin((String)"codeSwap");){
            Result result = this.swap(apks, false, redefiners);
            return result;
        }
    }

    public Result fullSwap(List<String> apks) throws DeployerException {
        try (Trace ignored = Trace.begin((String)"fullSwap");){
            Result result = this.swap(apks, true, (Map<Integer, ClassRedefiner>)ImmutableMap.of());
            return result;
        }
    }

    private Result swap(List<String> argPaths, boolean argRestart, Map<Integer, ClassRedefiner> redefiners) throws DeployerException {
        if (!this.adb.getVersion().isGreaterOrEqualThan(26)) {
            throw DeployerException.apiNotSupported();
        }
        Task<List<String>> paths = this.runner.create(argPaths);
        Task<Boolean> restart = this.runner.create(argRestart);
        Task<CachedDexSplitter> splitter = this.runner.create(new CachedDexSplitter(this.db, new D8DexSplitter()));
        Task<List> newFiles = this.runner.create(Tasks.PARSE_PATHS, new ApkParser()::parsePaths, paths);
        Task<ApplicationDumper.Dump> dumps = this.runner.create(Tasks.DUMP, new ApplicationDumper(this.installer)::dump, newFiles);
        Task<List> diffs = this.runner.create(Tasks.DIFF, (dump, newApks) -> new ApkDiffer().diff(dump.apks, (List<Apk>)newApks), dumps, newFiles);
        Task<String> sessionId = this.runner.create(Tasks.PREINSTALL, new ApkPreInstaller(this.adb, this.installer, this.logger)::preinstall, dumps, newFiles, diffs);
        Task<List> dexDiffs = this.runner.create(Tasks.VERIFY, new SwapVerifier()::verify, diffs, restart);
        Task<DexComparator.ChangedClasses> toSwap = this.runner.create(Tasks.COMPARE, new DexComparator()::compare, dexDiffs, splitter);
        ApkSwapper swapper = new ApkSwapper(this.installer, redefiners, argRestart, this.adb, this.logger);
        this.runner.create(Tasks.SWAP, swapper::swap, swapper::error, dumps, sessionId, toSwap);
        TaskResult result = this.runner.run();
        result.getMetrics().forEach(this.metrics::add);
        if (!result.isSuccess()) {
            throw result.getException();
        }
        this.runner.create(Tasks.CACHE, DexSplitter::cache, splitter, newFiles);
        this.runner.runAsync();
        Result deployResult = new Result();
        deployResult.skippedInstall = sessionId.get().equals("<SKIPPED-INSTALLATION>");
        return deployResult;
    }

    public class Result {
        public boolean skippedInstall = false;
    }

    public static enum InstallMode {
        DELTA,
        FULL;

    }

    static enum Tasks {
        CACHE,
        DUMP,
        DIFF,
        PREINSTALL,
        VERIFY,
        COMPARE,
        SWAP,
        PARSE_PATHS;

    }
}

