/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Functions;
import com.google.common.io.BaseEncoding;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ZipUtils {
    private static final int CENTRAL_DIRECTORY_FILE_HEADER_MAGIC = 33639248;
    private static final int CENTRAL_DIRECTORY_FILE_HEADER_SIZE = 46;
    private static final int LOCAL_DIRECTORY_FILE_HEADER_SIZE = 30;
    private static final String DIGEST_ALGORITHM = "SHA-1";

    @VisibleForTesting
    public static Map<String, ZipEntry> readZipEntries(byte[] buf) {
        ByteBuffer buffer = ByteBuffer.wrap(buf);
        return ZipUtils.readZipEntries(buffer).stream().collect(Collectors.toMap(e -> e.name, Functions.identity()));
    }

    public static List<ZipEntry> readZipEntries(ByteBuffer buf) {
        buf.order(ByteOrder.LITTLE_ENDIAN);
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        while (buf.remaining() >= 46 && buf.getInt() == 33639248) {
            short version = buf.getShort();
            short versionNeeded = buf.getShort();
            short flags = buf.getShort();
            short compression = buf.getShort();
            short modTime = buf.getShort();
            short modDate = buf.getShort();
            long crc = ZipUtils.uintToLong(buf.getInt());
            long compressedSize = ZipUtils.uintToLong(buf.getInt());
            long decompressedSize = ZipUtils.uintToLong(buf.getInt());
            int pathLength = ZipUtils.ushortToInt(buf.getShort());
            int extraLength = ZipUtils.ushortToInt(buf.getShort());
            int commentLength = ZipUtils.ushortToInt(buf.getShort());
            buf.position(buf.position() + 8);
            long start = ZipUtils.uintToLong(buf.getInt());
            byte[] pathBytes = new byte[pathLength];
            buf.get(pathBytes);
            String name = new String(pathBytes, Charset.forName("UTF-8"));
            buf.position(buf.position() + extraLength + commentLength);
            byte[] localFileHeader = new byte[30 + pathBytes.length];
            ByteBuffer fakeEntry = ByteBuffer.wrap(localFileHeader).order(ByteOrder.LITTLE_ENDIAN);
            fakeEntry.putLong(start);
            fakeEntry.putShort(versionNeeded);
            fakeEntry.putShort(modTime);
            fakeEntry.putShort(modDate);
            fakeEntry.putInt((int)crc);
            fakeEntry.putInt(ZipUtils.longToUint(compressedSize));
            fakeEntry.putInt(ZipUtils.longToUint(decompressedSize));
            fakeEntry.putShort(ZipUtils.intToUShort(pathLength));
            fakeEntry.putShort(ZipUtils.intToUShort(extraLength));
            fakeEntry.put(pathBytes);
            long approx_end = start + 30L + (long)pathLength - 1L;
            ZipEntry entry = new ZipEntry(crc, name, start, approx_end += compression == 0 ? decompressedSize : compressedSize, localFileHeader);
            entries.add(entry);
        }
        return entries;
    }

    public static String digest(ByteBuffer buffer) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MessageDigest:SHA-1 unavailable.", e);
        }
        messageDigest.update(buffer);
        byte[] digestBytes = messageDigest.digest();
        return BaseEncoding.base16().lowerCase().encode(digestBytes);
    }

    public static short intToUShort(int integer) {
        if ((integer & 0xFFFF0000) != 0) {
            throw new IllegalStateException("Cannot cast int to uint16 (does not fit)");
        }
        return (short)integer;
    }

    public static long uintToLong(int integer) {
        return (long)integer & 0xFFFFFFFFL;
    }

    public static int longToUint(long integer) {
        if ((integer & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalStateException("Cannot cast long to uint32 (does not fit)");
        }
        return (int)integer;
    }

    public static int ushortToInt(short integer) {
        return integer & 0xFFFF;
    }

    public static class ZipEntry {
        public final long crc;
        public final String name;
        public final long start;
        public final long approx_end;
        public final byte[] localFileHeader;

        ZipEntry(long crc, String name, long start, long approx_end, byte[] localFileHeader) {
            this.crc = crc;
            this.name = name;
            this.start = start;
            this.approx_end = approx_end;
            this.localFileHeader = localFileHeader;
        }
    }
}

