/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.tasks;

import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.tasks.Task;
import com.android.tools.deployer.tasks.TaskResult;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;

public class TaskRunner {
    private final ExecutorService executor;
    private final ArrayList<Task<?>> tasks;
    private final Semaphore running;

    public TaskRunner(ExecutorService executor) {
        this.executor = executor;
        this.tasks = new ArrayList();
        this.running = new Semaphore(1);
    }

    public <T> Task<T> create(T value) {
        Task<Object> task = new Task<Object>("", () -> value, new Task[0]);
        this.tasks.add(task);
        return task;
    }

    public <I, O, E extends Enum> Task<O> create(E id, ThrowingFunction<I, O> function, Task<I> input) {
        return this.create(id, function, null, input);
    }

    public <I, O, E extends Enum> Task<O> create(E id, ThrowingFunction<I, O> function, ThrowingFunction<I, Void> errorFunction, Task<I> input) {
        Callable<Object> callable = () -> {
            try {
                return function.apply(input.future.get());
            }
            catch (Exception e) {
                if (errorFunction != null) {
                    Object value = this.getTaskValue(input);
                    errorFunction.apply(value);
                }
                throw e;
            }
        };
        Task<Object> task = new Task<Object>(id.name(), callable, input);
        this.tasks.add(task);
        return task;
    }

    public <T, U, O, E extends Enum> Task<O> create(E id, ThrowingBiFunction<T, U, O> function, Task<T> input1, Task<U> input2) {
        return this.create(id, function, null, input1, input2);
    }

    public <T, U, O, E extends Enum> Task<O> create(E id, ThrowingBiFunction<T, U, O> function, ThrowingBiFunction<T, U, Void> errorFunction, Task<T> input1, Task<U> input2) {
        Callable<Object> callable = () -> {
            try {
                Object value1 = input1.future.get();
                Object value2 = input2.future.get();
                return function.apply(value1, value2);
            }
            catch (Exception e) {
                Object value1 = this.getTaskValue(input1);
                Object value2 = this.getTaskValue(input2);
                if (errorFunction != null) {
                    errorFunction.apply(value1, value2);
                }
                throw e;
            }
        };
        Task<Object> task = new Task<Object>(id.name(), callable, input1, input2);
        this.tasks.add(task);
        return task;
    }

    public <T, U, V, O, E extends Enum> Task<O> create(E id, ThrowingTriFunction<T, U, V, O> function, Task<T> input1, Task<U> input2, Task<V> input3) {
        return this.create(id, function, null, input1, input2, input3);
    }

    public <T, U, V, O, E extends Enum> Task<O> create(E id, ThrowingTriFunction<T, U, V, O> function, ThrowingTriFunction<T, U, V, Void> errorFunction, Task<T> input1, Task<U> input2, Task<V> input3) {
        Callable<Object> callable = () -> {
            try {
                Object value1 = input1.future.get();
                Object value2 = input2.future.get();
                Object value3 = input3.future.get();
                return function.apply(value1, value2, value3);
            }
            catch (Exception e) {
                Object value1 = this.getTaskValue(input1);
                Object value2 = this.getTaskValue(input2);
                Object value3 = this.getTaskValue(input3);
                if (errorFunction != null) {
                    errorFunction.apply(value1, value2, value3);
                }
                throw e;
            }
        };
        Task<Object> task = new Task<Object>(id.name(), callable, input1, input2, input3);
        this.tasks.add(task);
        return task;
    }

    private <O> O getTaskValue(Task<O> task) {
        try {
            return task.get();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void runInternal(ArrayList<Task<?>> batch) throws DeployerException {
        for (Task<?> task : batch) {
            task.run(this.executor);
        }
        this.joinAllTasks(batch, false);
        this.joinAllTasks(batch, true);
    }

    private void joinAllTasks(ArrayList<Task<?>> batch, boolean throwExceptionOnTaskFail) throws DeployerException {
        for (Task<?> task : batch) {
            try {
                task.get();
            }
            catch (Exception e) {
                if (!throwExceptionOnTaskFail) continue;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult run() {
        this.running.acquireUninterruptibly();
        ArrayList batch = new ArrayList(this.tasks);
        try {
            this.tasks.clear();
            this.runInternal(batch);
            TaskResult taskResult = new TaskResult(batch);
            return taskResult;
        }
        catch (DeployerException e) {
            TaskResult taskResult = new TaskResult(batch, e);
            return taskResult;
        }
        finally {
            this.running.release();
        }
    }

    public void runAsync(Executor executor) {
        ArrayList batch = new ArrayList(this.tasks);
        this.tasks.clear();
        this.running.acquireUninterruptibly();
        executor.execute(() -> {
            try {
                this.runInternal(batch);
            }
            catch (DeployerException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.running.release();
            }
        });
    }

    public void runAsync() {
        this.runAsync(this.executor);
    }

    public static interface ThrowingTriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3) throws Exception;
    }

    public static interface ThrowingBiFunction<T, U, R> {
        public R apply(T var1, U var2) throws Exception;
    }

    public static interface ThrowingFunction<I, O> {
        public O apply(I var1) throws Exception;
    }
}

