/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.AstLoadingFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.LazyContractProvider;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingServices;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationSplitter;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.DslMarkerUtils;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.FunctionTypeResolveUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016JH\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'H\u0002J6\u0010(\u001a\b\u0012\u0004\u0012\u00020)0$2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u00100\u001a\u000201H\u0002J2\u00102\u001a\u0004\u0018\u0001032\u0006\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00104\u001a\u0002052\u0006\u0010*\u001a\u00020+H\u0002J>\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020'2\u0006\u00100\u001a\u0002012\u0006\u00104\u001a\u000205J0\u0010:\u001a\u0002072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020;2\u0006\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020'2\u0006\u00104\u001a\u000205H\u0002Jd\u0010<\u001a\u00020=2*\u0010>\u001a&\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020-0?2\u0006\u0010D\u001a\u0002092\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020;2\u0006\u0010&\u001a\u00020'2\u0006\u00104\u001a\u0002052\u0006\u00100\u001a\u000201H\u0002J.\u0010<\u001a\u00020=2\u0006\u0010D\u001a\u0002092\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020;2\u0006\u0010&\u001a\u00020'2\u0006\u00104\u001a\u000205J6\u0010E\u001a\u00020=2\u0006\u0010D\u001a\u0002092\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020;2\u0006\u0010&\u001a\u00020'2\u0006\u00104\u001a\u0002052\u0006\u00100\u001a\u000201J(\u0010F\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010G\u001a\u00020H2\u0006\u0010&\u001a\u00020'J&\u0010I\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010J\u001a\u00020K2\u0006\u0010&\u001a\u00020'JD\u0010L\u001a\b\u0012\u0004\u0012\u00020)0$2\u0006\u0010,\u001a\u00020M2\u0006\u0010N\u001a\u00020/2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'2\u000e\u0010O\u001a\n\u0012\u0004\u0012\u000201\u0018\u00010$H\u0002J\f\u0010P\u001a\u00020\u001e*\u000201H\u0002J\u000e\u0010Q\u001a\u0004\u0018\u000101*\u000201H\u0002J\u001c\u0010R\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010$*\u0002012\u0006\u0010S\u001a\u00020MH\u0002J\f\u0010T\u001a\u000201*\u000201H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lorg/jetbrains/kotlin/resolve/FunctionDescriptorResolver;", "", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "descriptorResolver", "Lorg/jetbrains/kotlin/resolve/DescriptorResolver;", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "overloadChecker", "Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "contractParsingServices", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "(Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/OverloadChecker;Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "createConstructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isPrimary", "", "modifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "declarationToTrace", "Lorg/jetbrains/kotlin/psi/KtPureElement;", "valueParameters", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "createValueParameterDescriptors", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;", "innerScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "expectedFunctionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getContractProvider", "Lorg/jetbrains/kotlin/contracts/description/LazyContractProvider;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "initializeFunctionDescriptorAndExplicitReturnType", "", "container", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "initializeFunctionReturnTypeBasedOnFunctionBody", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "resolveFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "functionConstructor", "Lkotlin/Function5;", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor$Kind;", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "containingDescriptor", "resolveFunctionExpressionDescriptor", "resolvePrimaryConstructorDescriptor", "classElement", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "resolveSecondaryConstructorDescriptor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "resolveValueParameters", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parameterScope", "expectedParameterTypes", "functionTypeExpected", "getReceiverType", "getValueParameters", "owner", "removeParameterNameAnnotation", "frontend"})
public final class FunctionDescriptorResolver {
    private final TypeResolver typeResolver;
    private final DescriptorResolver descriptorResolver;
    private final AnnotationResolver annotationResolver;
    private final KotlinBuiltIns builtIns;
    private final ModifiersChecker modifiersChecker;
    private final OverloadChecker overloadChecker;
    private final ContractParsingServices contractParsingServices;
    private final ExpressionTypingServices expressionTypingServices;
    private final LanguageVersionSettings languageVersionSettings;
    private final StorageManager storageManager;

    @NotNull
    public final SimpleFunctionDescriptor resolveFunctionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope2, @NotNull KtNamedFunction function2, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        Intrinsics.checkNotNullParameter((Object)containingDescriptor, (String)"containingDescriptor");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)dataFlowInfo, (String)"dataFlowInfo");
        if (function2.getName() == null) {
            trace.report(Errors.FUNCTION_DECLARATION_WITH_NO_NAME.on((KtFunction)((PsiElement)function2)));
        }
        Function5 function5 = resolveFunctionDescriptor.1.INSTANCE;
        SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"TypeUtils.NO_EXPECTED_TYPE");
        return this.resolveFunctionDescriptor((Function5<? super DeclarationDescriptor, ? super Annotations, ? super Name, ? super CallableMemberDescriptor.Kind, ? super SourceElement, ? extends SimpleFunctionDescriptorImpl>)function5, containingDescriptor, scope2, function2, trace, dataFlowInfo, simpleType2);
    }

    @NotNull
    public final SimpleFunctionDescriptor resolveFunctionExpressionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope2, @NotNull KtNamedFunction function2, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @NotNull KotlinType expectedFunctionType) {
        Intrinsics.checkNotNullParameter((Object)containingDescriptor, (String)"containingDescriptor");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)dataFlowInfo, (String)"dataFlowInfo");
        Intrinsics.checkNotNullParameter((Object)expectedFunctionType, (String)"expectedFunctionType");
        return this.resolveFunctionDescriptor((Function5<? super DeclarationDescriptor, ? super Annotations, ? super Name, ? super CallableMemberDescriptor.Kind, ? super SourceElement, ? extends SimpleFunctionDescriptorImpl>)((Function5)resolveFunctionExpressionDescriptor.1.INSTANCE), containingDescriptor, scope2, function2, trace, dataFlowInfo, expectedFunctionType);
    }

    private final SimpleFunctionDescriptor resolveFunctionDescriptor(Function5<? super DeclarationDescriptor, ? super Annotations, ? super Name, ? super CallableMemberDescriptor.Kind, ? super SourceElement, ? extends SimpleFunctionDescriptorImpl> functionConstructor, DeclarationDescriptor containingDescriptor, LexicalScope scope2, KtNamedFunction function2, BindingTrace trace, DataFlowInfo dataFlowInfo, KotlinType expectedFunctionType) {
        Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, function2.getModifierList(), trace);
        Name name = function2.getNameAsSafeName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"function.nameAsSafeName");
        SimpleFunctionDescriptorImpl functionDescriptor = (SimpleFunctionDescriptorImpl)functionConstructor.invoke((Object)containingDescriptor, (Object)annotations2, (Object)name, (Object)CallableMemberDescriptor.Kind.DECLARATION, (Object)KotlinSourceElementKt.toSourceElement(function2));
        this.initializeFunctionDescriptorAndExplicitReturnType(containingDescriptor, scope2, function2, functionDescriptor, trace, expectedFunctionType, dataFlowInfo);
        this.initializeFunctionReturnTypeBasedOnFunctionBody(scope2, function2, functionDescriptor, trace, dataFlowInfo);
        BindingContextUtils.recordFunctionDeclarationToDescriptor(trace, function2, functionDescriptor);
        return functionDescriptor;
    }

    private final void initializeFunctionReturnTypeBasedOnFunctionBody(LexicalScope scope2, KtNamedFunction function2, SimpleFunctionDescriptorImpl functionDescriptor, BindingTrace trace, DataFlowInfo dataFlowInfo) {
        if (functionDescriptor.getReturnType() != null) {
            return;
        }
        boolean bl = function2.getTypeReference() == null;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Return type must be initialized early for function: " + function2.getText() + ", at: " + PsiDiagnosticUtils.atLocation(function2);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        KotlinType kotlinType = function2.hasBlockBody() ? (KotlinType)this.builtIns.getUnitType() : (function2.hasBody() ? this.descriptorResolver.inferReturnTypeFromExpressionBody(trace, scope2, dataFlowInfo, function2, functionDescriptor) : (KotlinType)ErrorUtils.createErrorType("No type, no body"));
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"when {\n            funct\u2026type, no body\")\n        }");
        KotlinType inferredReturnType = kotlinType;
        functionDescriptor.setReturnType(inferredReturnType);
    }

    public final void initializeFunctionDescriptorAndExplicitReturnType(@NotNull DeclarationDescriptor container, @NotNull LexicalScope scope2, @NotNull KtFunction function2, @NotNull SimpleFunctionDescriptorImpl functionDescriptor, @NotNull BindingTrace trace, @NotNull KotlinType expectedFunctionType, @NotNull DataFlowInfo dataFlowInfo) {
        ReceiverParameterDescriptor receiverParameterDescriptor;
        KotlinType kotlinType;
        boolean $i$a$-let-FunctionDescriptorResolver$initializeFunctionDescriptorAndExplicitReturnType$returnType$22;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)expectedFunctionType, (String)"expectedFunctionType");
        Intrinsics.checkNotNullParameter((Object)dataFlowInfo, (String)"dataFlowInfo");
        LexicalWritableScope headerScope = new LexicalWritableScope(scope2, functionDescriptor, true, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.FUNCTION_HEADER);
        List<TypeParameterDescriptorImpl> typeParameterDescriptors = this.descriptorResolver.resolveTypeParametersForDescriptor(functionDescriptor, headerScope, scope2, function2.getTypeParameters(), trace);
        this.descriptorResolver.resolveGenericBounds(function2, functionDescriptor, headerScope, typeParameterDescriptors, trace);
        KtTypeReference receiverTypeRef = function2.getReceiverTypeReference();
        KotlinType receiverType = receiverTypeRef != null ? this.typeResolver.resolveType(headerScope, receiverTypeRef, trace, true) : (function2 instanceof KtFunctionLiteral ? this.getReceiverType(expectedFunctionType) : null);
        List<ValueParameterDescriptor> valueParameterDescriptors = this.createValueParameterDescriptors(function2, functionDescriptor, headerScope, trace, expectedFunctionType);
        headerScope.freeze();
        KtTypeReference ktTypeReference = function2.getTypeReference();
        if (ktTypeReference != null) {
            KtTypeReference ktTypeReference2 = ktTypeReference;
            boolean bl = false;
            boolean bl2 = false;
            KtTypeReference it = ktTypeReference2;
            $i$a$-let-FunctionDescriptorResolver$initializeFunctionDescriptorAndExplicitReturnType$returnType$22 = false;
            LexicalScope lexicalScope = headerScope;
            KtTypeReference ktTypeReference3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference3, (String)"it");
            kotlinType = this.typeResolver.resolveType(lexicalScope, ktTypeReference3, trace, true);
        } else {
            kotlinType = null;
        }
        KotlinType returnType2 = kotlinType;
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(function2, DescriptorResolver.getDefaultVisibility(function2, container));
        Intrinsics.checkNotNullExpressionValue((Object)visibility, (String)"resolveVisibilityFromMod\u2026ity(function, container))");
        Visibility visibility2 = visibility;
        Modality modality = ModifiersChecker.resolveMemberModalityFromModifiers(function2, DescriptorResolver.getDefaultModality(container, visibility2, function2.hasBody()), trace.getBindingContext(), container);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)modality), (String)"resolveMemberModalityFro\u2026text, container\n        )");
        Modality modality2 = modality;
        LazyContractProvider contractProvider = this.getContractProvider(functionDescriptor, trace, scope2, dataFlowInfo, function2);
        $i$a$-let-FunctionDescriptorResolver$initializeFunctionDescriptorAndExplicitReturnType$returnType$22 = false;
        Map $i$a$-let-FunctionDescriptorResolver$initializeFunctionDescriptorAndExplicitReturnType$returnType$22 = new LinkedHashMap();
        boolean bl = false;
        boolean bl3 = false;
        Map $this$apply = $i$a$-let-FunctionDescriptorResolver$initializeFunctionDescriptorAndExplicitReturnType$returnType$22;
        boolean bl4 = false;
        if (contractProvider != null) {
            $this$apply.put(ContractProviderKey.INSTANCE, contractProvider);
        }
        if (receiverType != null && this.functionTypeExpected(expectedFunctionType) && !expectedFunctionType.getAnnotations().isEmpty()) {
            $this$apply.put(DslMarkerUtils.FunctionTypeAnnotationsKey.INSTANCE, expectedFunctionType.getAnnotations());
        }
        Map userData = $i$a$-let-FunctionDescriptorResolver$initializeFunctionDescriptorAndExplicitReturnType$returnType$22;
        KotlinType kotlinType2 = receiverType;
        if (kotlinType2 != null) {
            KotlinType kotlinType3 = kotlinType2;
            bl3 = false;
            boolean bl5 = false;
            KotlinType it = kotlinType3;
            boolean bl6 = false;
            Annotations annotations2 = receiverType.getAnnotations();
            EnumSet<Enum> enumSet = EnumSet.of((Enum)AnnotationUseSiteTarget.RECEIVER);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"EnumSet.of(AnnotationUseSiteTarget.RECEIVER)");
            AnnotationSplitter splitter = new AnnotationSplitter(this.storageManager, annotations2, (Set<? extends AnnotationUseSiteTarget>)enumSet);
            receiverParameterDescriptor = DescriptorFactory.createExtensionReceiverParameterForCallable(functionDescriptor, it, splitter.getAnnotationsForTarget(AnnotationUseSiteTarget.RECEIVER));
        } else {
            receiverParameterDescriptor = null;
        }
        ReceiverParameterDescriptor extensionReceiver = receiverParameterDescriptor;
        Object object = userData;
        bl3 = false;
        boolean bl7 = false;
        Object it = object;
        Visibility visibility3 = visibility2;
        Modality modality3 = modality2;
        KotlinType kotlinType4 = returnType2;
        List<ValueParameterDescriptor> list2 = valueParameterDescriptors;
        List<TypeParameterDescriptorImpl> list3 = typeParameterDescriptors;
        ReceiverParameterDescriptor receiverParameterDescriptor2 = DescriptorUtils.getDispatchReceiverParameterIfNeeded(container);
        ReceiverParameterDescriptor receiverParameterDescriptor3 = extensionReceiver;
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        boolean bl8 = false;
        Map map2 = it;
        boolean bl9 = false;
        boolean bl10 = !map2.isEmpty();
        simpleFunctionDescriptorImpl.initialize(receiverParameterDescriptor3, receiverParameterDescriptor2, (List<? extends TypeParameterDescriptor>)list3, list2, kotlinType4, modality3, visibility3, (Map<? extends CallableDescriptor.UserDataKey<?>, ?>)(bl10 ? object : null));
        functionDescriptor.setOperator(function2.hasModifier(KtTokens.OPERATOR_KEYWORD));
        functionDescriptor.setInfix(function2.hasModifier(KtTokens.INFIX_KEYWORD));
        functionDescriptor.setExternal(function2.hasModifier(KtTokens.EXTERNAL_KEYWORD));
        functionDescriptor.setInline(function2.hasModifier(KtTokens.INLINE_KEYWORD));
        functionDescriptor.setTailrec(function2.hasModifier(KtTokens.TAILREC_KEYWORD));
        functionDescriptor.setSuspend(function2.hasModifier(KtTokens.SUSPEND_KEYWORD));
        functionDescriptor.setExpect(container instanceof PackageFragmentDescriptor && PsiUtilsKt.hasExpectModifier(function2) || container instanceof ClassDescriptor && ((ClassDescriptor)container).isExpect());
        functionDescriptor.setActual(PsiUtilsKt.hasActualModifier(function2));
        KotlinType kotlinType5 = receiverType;
        if (kotlinType5 != null) {
            object = kotlinType5;
            bl3 = false;
            bl7 = false;
            it = object;
            boolean bl11 = false;
            ForceResolveUtil.forceResolveAllContents(it.getAnnotations());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : valueParameterDescriptors) {
            ForceResolveUtil.forceResolveAllContents(valueParameterDescriptor.getType().getAnnotations());
        }
    }

    private final LazyContractProvider getContractProvider(SimpleFunctionDescriptorImpl functionDescriptor, BindingTrace trace, LexicalScope scope2, DataFlowInfo dataFlowInfo, KtFunction function2) {
        if (!(function2 instanceof KtNamedFunction)) {
            return null;
        }
        boolean isContractsEnabled = this.languageVersionSettings.supportsFeature(LanguageFeature.AllowContractsForCustomFunctions);
        boolean isAllowedOnMembers = this.languageVersionSettings.supportsFeature(LanguageFeature.AllowContractsForNonOverridableMembers);
        if (!isContractsEnabled || !((KtNamedFunction)function2).mayHaveContract(isAllowedOnMembers)) {
            return null;
        }
        return new LazyContractProvider(this.storageManager, (Function0<? extends Object>)((Function0)new Function0<Object>(this, function2, trace, scope2, dataFlowInfo, functionDescriptor){
            final /* synthetic */ FunctionDescriptorResolver this$0;
            final /* synthetic */ KtFunction $function;
            final /* synthetic */ BindingTrace $trace;
            final /* synthetic */ LexicalScope $scope;
            final /* synthetic */ DataFlowInfo $dataFlowInfo;
            final /* synthetic */ SimpleFunctionDescriptorImpl $functionDescriptor;

            @Nullable
            public final Object invoke() {
                return AstLoadingFilter.forceAllowTreeLoading((PsiFile)((KtNamedFunction)this.$function).getContainingFile(), (ThrowableComputable)((ThrowableComputable)new ThrowableComputable<KotlinType, Throwable>(this){
                    final /* synthetic */ getContractProvider.1 this$0;

                    public final KotlinType compute() {
                        return FunctionDescriptorResolver.access$getExpressionTypingServices$p(this.this$0.this$0).getBodyExpressionType(this.this$0.$trace, this.this$0.$scope, this.this$0.$dataFlowInfo, this.this$0.$function, this.this$0.$functionDescriptor);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
            }
            {
                this.this$0 = functionDescriptorResolver;
                this.$function = ktFunction;
                this.$trace = bindingTrace;
                this.$scope = lexicalScope;
                this.$dataFlowInfo = dataFlowInfo;
                this.$functionDescriptor = simpleFunctionDescriptorImpl;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ValueParameterDescriptor> createValueParameterDescriptors(KtFunction function2, SimpleFunctionDescriptorImpl functionDescriptor, LexicalWritableScope innerScope, BindingTrace trace, KotlinType expectedFunctionType) {
        List expectedParameterTypes;
        List list2;
        List<ValueParameterDescriptor> expectedValueParameters;
        List<ValueParameterDescriptor> list3 = expectedValueParameters = this.getValueParameters(expectedFunctionType, functionDescriptor);
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                KotlinType kotlinType = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
                KotlinType kotlinType2 = this.removeParameterNameAnnotation(kotlinType);
                collection.add(kotlinType2);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = expectedParameterTypes = null;
        }
        if (expectedValueParameters != null) {
            if (expectedValueParameters.size() == 1 && function2 instanceof KtFunctionLiteral && function2.getValueParameterList() == null) {
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.single(expectedValueParameters);
                CallableDescriptor callableDescriptor = functionDescriptor;
                Annotations annotations2 = Annotations.Companion.getEMPTY();
                Name name = Name.identifier("it");
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(\"it\")");
                List list4 = expectedParameterTypes;
                Intrinsics.checkNotNull((Object)list4);
                KotlinType kotlinType = (KotlinType)CollectionsKt.single((List)list4);
                boolean bl = valueParameterDescriptor.declaresDefaultValue();
                boolean bl2 = valueParameterDescriptor.isCrossinline();
                boolean bl3 = valueParameterDescriptor.isNoinline();
                KotlinType kotlinType3 = valueParameterDescriptor.getVarargElementType();
                SourceElement sourceElement = SourceElement.NO_SOURCE;
                Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"SourceElement.NO_SOURCE");
                ValueParameterDescriptorImpl it = new ValueParameterDescriptorImpl(callableDescriptor, null, 0, annotations2, name, kotlinType, bl, bl2, bl3, kotlinType3, sourceElement);
                trace.record(BindingContext.AUTO_CREATED_IT, it);
                return CollectionsKt.listOf((Object)it);
            }
            if (function2.getValueParameters().size() != expectedValueParameters.size()) {
                PsiElement psiElement = function2;
                List list5 = expectedParameterTypes;
                Intrinsics.checkNotNull(list5);
                trace.report(Errors.EXPECTED_PARAMETERS_NUMBER_MISMATCH.on((KtFunction)psiElement, list5.size(), expectedParameterTypes));
            }
        }
        BindingContextUtilsKt.recordScope(trace, innerScope, function2.getValueParameterList());
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        List<KtParameter> list6 = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list6, (String)"function.valueParameters");
        return this.resolveValueParameters(functionDescriptor2, innerScope, list6, trace, expectedParameterTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType removeParameterNameAnnotation(KotlinType $this$removeParameterNameAnnotation) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        if ($this$removeParameterNameAnnotation instanceof TypeUtils.SpecialType) {
            return $this$removeParameterNameAnnotation;
        }
        Annotations annotations2 = $this$removeParameterNameAnnotation.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.parameterName;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.parameterName");
        AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation(fqName2);
        if (annotationDescriptor == null) {
            return $this$removeParameterNameAnnotation;
        }
        AnnotationDescriptor parameterNameAnnotation = annotationDescriptor;
        Iterable iterable = $this$removeParameterNameAnnotation.getAnnotations();
        Annotations.Companion companion = Annotations.Companion;
        KotlinType kotlinType = $this$removeParameterNameAnnotation;
        boolean $i$f$filter = false;
        void var5_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AnnotationDescriptor it = (AnnotationDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)parameterNameAnnotation) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return TypeUtilsKt.replaceAnnotations(kotlinType, companion.create(list2));
    }

    private final boolean functionTypeExpected(KotlinType $this$functionTypeExpected) {
        return !TypeUtils.noExpectedType($this$functionTypeExpected) && FunctionTypesKt.isBuiltinFunctionalType($this$functionTypeExpected);
    }

    private final KotlinType getReceiverType(KotlinType $this$getReceiverType) {
        return this.functionTypeExpected($this$getReceiverType) ? FunctionTypesKt.getReceiverTypeFromFunctionType($this$getReceiverType) : null;
    }

    private final List<ValueParameterDescriptor> getValueParameters(KotlinType $this$getValueParameters, FunctionDescriptor owner) {
        return this.functionTypeExpected($this$getValueParameters) ? FunctionTypeResolveUtilsKt.createValueParametersForInvokeInFunctionType(owner, FunctionTypesKt.getValueParameterTypesFromFunctionType($this$getValueParameters)) : null;
    }

    @Nullable
    public final ClassConstructorDescriptorImpl resolvePrimaryConstructorDescriptor(@NotNull LexicalScope scope2, @NotNull ClassDescriptor classDescriptor2, @NotNull KtPureClassOrObject classElement, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)classDescriptor2, (String)"classDescriptor");
        Intrinsics.checkNotNullParameter((Object)classElement, (String)"classElement");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        if (classDescriptor2.getKind() == ClassKind.ENUM_ENTRY || !classElement.hasPrimaryConstructor()) {
            return null;
        }
        KtModifierList ktModifierList = classElement.getPrimaryConstructorModifierList();
        KtPrimaryConstructor ktPrimaryConstructor = classElement.getPrimaryConstructor();
        KtPureElement ktPureElement = ktPrimaryConstructor != null ? (KtPureElement)ktPrimaryConstructor : (KtPureElement)classElement;
        List<KtParameter> list2 = classElement.getPrimaryConstructorParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"classElement.primaryConstructorParameters");
        return this.createConstructorDescriptor(scope2, classDescriptor2, true, ktModifierList, ktPureElement, list2, trace);
    }

    @NotNull
    public final ClassConstructorDescriptorImpl resolveSecondaryConstructorDescriptor(@NotNull LexicalScope scope2, @NotNull ClassDescriptor classDescriptor2, @NotNull KtSecondaryConstructor constructor, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)classDescriptor2, (String)"classDescriptor");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        return this.createConstructorDescriptor(scope2, classDescriptor2, false, constructor.getModifierList(), constructor, constructor.getValueParameters(), trace);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ClassConstructorDescriptorImpl createConstructorDescriptor(LexicalScope scope2, ClassDescriptor classDescriptor2, boolean isPrimary, KtModifierList modifierList2, KtPureElement declarationToTrace, List<? extends KtParameter> valueParameters2, BindingTrace trace) {
        ClassConstructorDescriptorImpl constructor;
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = ClassConstructorDescriptorImpl.create(classDescriptor2, this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, modifierList2, trace), isPrimary, KotlinSourceElementKt.toSourceElement(declarationToTrace));
        Intrinsics.checkNotNullExpressionValue((Object)classConstructorDescriptorImpl, (String)"ClassConstructorDescript\u2026SourceElement()\n        )");
        ClassConstructorDescriptorImpl constructorDescriptor = classConstructorDescriptorImpl;
        constructorDescriptor.setExpect(classDescriptor2.isExpect());
        KtModifierList ktModifierList = modifierList2;
        constructorDescriptor.setActual(ktModifierList != null && PsiUtilsKt.hasActualModifier(ktModifierList) || classDescriptor2.getKind() == ClassKind.ANNOTATION_CLASS && classDescriptor2.isActual());
        if (declarationToTrace instanceof PsiElement) {
            trace.record(BindingContext.CONSTRUCTOR, declarationToTrace, constructorDescriptor);
        }
        LexicalWritableScope parameterScope = new LexicalWritableScope(scope2, constructorDescriptor, false, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.CONSTRUCTOR_HEADER);
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl2 = constructor = constructorDescriptor.initialize(this.resolveValueParameters(constructorDescriptor, parameterScope, valueParameters2, trace, null), ModifiersChecker.resolveVisibilityFromModifiers(modifierList2, DescriptorUtils.getDefaultConstructorVisibility(classDescriptor2)));
        Intrinsics.checkNotNullExpressionValue((Object)classConstructorDescriptorImpl2, (String)"constructor");
        classConstructorDescriptorImpl2.setReturnType(classDescriptor2.getDefaultType());
        if (DescriptorUtils.isAnnotationClass(classDescriptor2)) {
            CompileTimeConstantUtils.checkConstructorParametersType(valueParameters2, trace);
        }
        return constructor;
    }

    /*
     * Unable to fully structure code
     */
    private final List<ValueParameterDescriptor> resolveValueParameters(FunctionDescriptor functionDescriptor, LexicalWritableScope parameterScope, List<? extends KtParameter> valueParameters, BindingTrace trace, List<? extends KotlinType> expectedParameterTypes) {
        result = new ArrayList<ValueParameterDescriptorImpl>();
        var7_7 = 0;
        var8_8 = ((Collection)valueParameters).size();
        while (var7_7 < var8_8) {
            valueParameter = valueParameters.get((int)i);
            typeReference = valueParameter.getTypeReference();
            v0 = expectedParameterTypes;
            if (v0 == null) ** GOTO lbl-1000
            var12_12 = v0;
            var13_14 = false;
            var14_15 = false;
            it = var12_12;
            $i$a$-let-FunctionDescriptorResolver$resolveValueParameters$expectedType$1 = false;
            v0 = i < it.size() ? it.get((int)i) : null;
            if (v0 != null) {
                var12_12 = v0;
                var13_14 = false;
                var14_15 = false;
                it = var12_12;
                $i$a$-takeUnless-FunctionDescriptorResolver$resolveValueParameters$expectedType$2 = false;
                v1 = !TypeUtils.noExpectedType(it) ? var12_12 : null;
            } else lbl-1000:
            // 2 sources

            {
                v1 = null;
            }
            expectedType = v1;
            type = null;
            if (typeReference != null) {
                type = this.typeResolver.resolveType(parameterScope, typeReference, trace, true);
                if (expectedType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(expectedType, type)) {
                    trace.report(Errors.EXPECTED_PARAMETER_TYPE_MISMATCH.on((KtParameter)((PsiElement)valueParameter), expectedType));
                }
            } else {
                if (ExpressionTypingUtils.isFunctionLiteral(functionDescriptor) || ExpressionTypingUtils.isFunctionExpression(functionDescriptor)) {
                    containsUninferredParameter = TypeUtils.contains(expectedType, (Function1<UnwrappedType, Boolean>)((Function1)resolveValueParameters.containsUninferredParameter.1.INSTANCE));
                    if (expectedType == null || containsUninferredParameter) {
                        trace.report(Errors.CANNOT_INFER_PARAMETER_TYPE.on((KtParameter)((PsiElement)valueParameter)));
                    }
                    if ((v2 = expectedType) == null) {
                        v2 = TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE;
                    }
                } else {
                    trace.report(Errors.VALUE_PARAMETER_WITH_NO_TYPE_ANNOTATION.on((KtParameter)((PsiElement)valueParameter)));
                    v2 = ErrorUtils.createErrorType("Type annotation was missing for parameter " + valueParameter.getNameAsSafeName());
                }
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"if (isFunctionLiteral(fu\u2026Name}\")\n                }");
                type = v2;
            }
            if (!(functionDescriptor instanceof ConstructorDescriptor) || !((ConstructorDescriptor)functionDescriptor).isPrimary()) {
                isConstructor = functionDescriptor instanceof ConstructorDescriptor;
                var14_16 = this.modifiersChecker.withTrace(trace);
                var15_18 = false;
                var16_19 = false;
                $this$with = var14_16;
                $i$a$-with-FunctionDescriptorResolver$resolveValueParameters$1 = false;
                $this$with.checkParameterHasNoValOrVar(valueParameter, isConstructor != false ? Errors.VAL_OR_VAR_ON_SECONDARY_CONSTRUCTOR_PARAMETER : Errors.VAL_OR_VAR_ON_FUN_PARAMETER);
            }
            Intrinsics.checkNotNullExpressionValue((Object)this.descriptorResolver.resolveValueParameterDescriptor(parameterScope, functionDescriptor, valueParameter, (int)i, type, trace, Annotations.Companion.getEMPTY()), (String)"descriptorResolver.resol\u2026tions.EMPTY\n            )");
            ExpressionTypingUtils.checkVariableShadowing(parameterScope, trace, valueParameterDescriptor);
            parameterScope.addVariableDescriptor(valueParameterDescriptor);
            result.add(valueParameterDescriptor);
            ++i;
        }
        return result;
    }

    public FunctionDescriptorResolver(@NotNull TypeResolver typeResolver, @NotNull DescriptorResolver descriptorResolver, @NotNull AnnotationResolver annotationResolver, @NotNull KotlinBuiltIns builtIns, @NotNull ModifiersChecker modifiersChecker, @NotNull OverloadChecker overloadChecker, @NotNull ContractParsingServices contractParsingServices, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter((Object)typeResolver, (String)"typeResolver");
        Intrinsics.checkNotNullParameter((Object)descriptorResolver, (String)"descriptorResolver");
        Intrinsics.checkNotNullParameter((Object)annotationResolver, (String)"annotationResolver");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)modifiersChecker, (String)"modifiersChecker");
        Intrinsics.checkNotNullParameter((Object)overloadChecker, (String)"overloadChecker");
        Intrinsics.checkNotNullParameter((Object)contractParsingServices, (String)"contractParsingServices");
        Intrinsics.checkNotNullParameter((Object)expressionTypingServices, (String)"expressionTypingServices");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        this.typeResolver = typeResolver;
        this.descriptorResolver = descriptorResolver;
        this.annotationResolver = annotationResolver;
        this.builtIns = builtIns;
        this.modifiersChecker = modifiersChecker;
        this.overloadChecker = overloadChecker;
        this.contractParsingServices = contractParsingServices;
        this.expressionTypingServices = expressionTypingServices;
        this.languageVersionSettings = languageVersionSettings;
        this.storageManager = storageManager;
    }

    public static final /* synthetic */ ExpressionTypingServices access$getExpressionTypingServices$p(FunctionDescriptorResolver $this) {
        return $this.expressionTypingServices;
    }
}

