/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeProject;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.LintIdeUtilsKt;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.detector.api.Project;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.plugins.groovy.GroovyLanguage;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\f\u0010\u001a\u001a\u00020\u0016*\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u0016*\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/lint/common/SuppressLintQuickFix;", "Lcom/intellij/codeInspection/SuppressQuickFix;", "id", "", "element", "Lcom/intellij/psi/PsiElement;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "label", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "handleBinary", "handleGroovy", "handleJava", "handleKotlin", "handleXml", "isAvailable", "", "context", "isSuppressAll", "startInWriteAction", "isNewLineNeededForAnnotation", "Lorg/jetbrains/kotlin/psi/KtElement;", "isSuppressLintTarget", "Companion", "intellij.android.lint"})
public final class SuppressLintQuickFix
implements SuppressQuickFix {
    private final String label;
    private final String id;
    private static final String NO_INSPECTION_PREFIX = "//noinspection ";
    private static final FqName FQNAME_SUPPRESS_LINT;
    public static final Companion Companion;

    public boolean isAvailable(@NotNull com.intellij.openapi.project.Project project, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return true;
    }

    public boolean isSuppressAll() {
        return false;
    }

    @NotNull
    public String getName() {
        return this.label;
    }

    @NotNull
    public String getFamilyName() {
        return "Suppress";
    }

    public void applyFix(@NotNull com.intellij.openapi.project.Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        if (psiElement == null) {
            return;
        }
        PsiElement element = psiElement;
        this.applyFix(element);
    }

    public final void applyFix(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Language language = element.getLanguage();
        if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
            this.handleJava(element);
        } else if (Intrinsics.areEqual((Object)language, (Object)XMLLanguage.INSTANCE)) {
            this.handleXml(element);
        } else if (Intrinsics.areEqual((Object)language, (Object)GroovyLanguage.INSTANCE)) {
            this.handleGroovy(element);
        } else if (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) {
            this.handleKotlin(element);
        } else {
            PsiFile psiFile = element.getContainingFile();
            if (psiFile == null) {
                return;
            }
            PsiFile file = psiFile;
            if (file instanceof PsiBinaryFile) {
                this.handleBinary(element);
            }
        }
    }

    private final void handleXml(PsiElement element) throws IncorrectOperationException {
        XmlFile xmlFile;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
        if (xmlTag == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"PsiTreeUtil.getParentOfT\u2026ss.java, false) ?: return");
        XmlTag tag = xmlTag;
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)tag)) {
            return;
        }
        if (tag instanceof XmlFile) {
            xmlFile = (XmlFile)tag;
        } else {
            PsiFile psiFile = tag.getContainingFile();
            if (!(psiFile instanceof XmlFile)) {
                psiFile = null;
            }
            if ((xmlFile = (XmlFile)psiFile) == null) {
                return;
            }
        }
        XmlFile file = xmlFile;
        String lintId = Companion.getLintId(this.id);
        SuppressLintQuickFix.Companion.addSuppressAttribute(file, tag, lintId);
    }

    private final void handleJava(PsiElement element) throws IncorrectOperationException {
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class);
        if (psiModifierListOwner == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiModifierListOwner, (String)"PsiTreeUtil.getParentOfT\u2026er::class.java) ?: return");
        PsiModifierListOwner container = psiModifierListOwner;
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)container)) {
            return;
        }
        com.intellij.openapi.project.Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        com.intellij.openapi.project.Project project2 = project;
        String lintId = StringsKt.removePrefix((String)this.id, (CharSequence)"AndroidLint");
        SuppressLintQuickFix.Companion.addSuppressAnnotation(project2, (PsiElement)container, container, lintId);
    }

    private final void handleGroovy(PsiElement element) throws IncorrectOperationException {
        int nonSpace;
        PsiFile psiFile;
        if (element instanceof PsiFile) {
            psiFile = (PsiFile)element;
        } else {
            psiFile = element.getContainingFile();
            if (psiFile == null) {
                return;
            }
        }
        PsiFile file = psiFile;
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file)) {
            return;
        }
        com.intellij.openapi.project.Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        com.intellij.openapi.project.Project project2 = project;
        Document document = PsiDocumentManager.getInstance((com.intellij.openapi.project.Project)project2).getDocument(file);
        if (document == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"PsiDocumentManager.getIn\u2026tDocument(file) ?: return");
        Document document2 = document;
        int offset = element.getTextOffset();
        int line = document2.getLineNumber(offset);
        int lineStart = document2.getLineStartOffset(line);
        if (lineStart > 0) {
            int prevLineStart = document2.getLineStartOffset(line - 1);
            int prevLineEnd = document2.getLineEndOffset(line - 1);
            String string = document2.getText(new TextRange(prevLineStart, prevLineEnd));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.getText(TextRan\u2026vLineStart, prevLineEnd))");
            String prevLine = string;
            int index = StringsKt.indexOf$default((CharSequence)prevLine, (String)NO_INSPECTION_PREFIX, (int)0, (boolean)false, (int)6, null);
            if (index != -1) {
                document2.insertString(prevLineStart + index + NO_INSPECTION_PREFIX.length(), (CharSequence)(Companion.getLintId(this.id) + ","));
                return;
            }
        }
        String string = document2.getText(new TextRange(lineStart, offset));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.getText(TextRange(lineStart, offset))");
        String linePrefix = string;
        for (nonSpace = 0; nonSpace < linePrefix.length() && Character.isWhitespace(linePrefix.charAt(nonSpace)); ++nonSpace) {
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        StringBuilder stringBuilder = new StringBuilder().append(NO_INSPECTION_PREFIX).append(Companion.getLintId(this.id)).append("\n");
        String string2 = linePrefix;
        int n = 0;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, nonSpace);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        document2.insertString(lineStart + nonSpace, (CharSequence)stringBuilder.append(string4).toString());
    }

    private final void handleBinary(PsiElement element) throws IncorrectOperationException {
        PsiFile file;
        PsiFile psiFile = file = element instanceof PsiFile ? (PsiFile)element : element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null) {
            File dir;
            File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"VfsUtilCore.virtualToIoFile(virtualFile)");
            File binaryFile = file2;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file));
            if (module != null && (dir = LintIdeProject.getLintProjectDirectory(module)) != null) {
                com.intellij.openapi.project.Project project = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
                com.intellij.openapi.project.Project project2 = project;
                LintIdeClient client = LintIdeSupport.createClient$default(LintIdeSupport.Companion.get(), project2, null, 2, null);
                Project lintProject = client.getProject(dir, dir);
                Configuration configuration = client.getConfiguration(lintProject, null);
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"client.getConfiguration(lintProject, null)");
                Configuration configuration2 = configuration;
                configuration2.ignore(this.id, binaryFile);
            }
        }
    }

    private final void handleKotlin(PsiElement element) throws IncorrectOperationException {
        block2: {
            PsiElement psiElement = PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)true, (Condition)((Condition)new Condition<PsiElement>(this){
                final /* synthetic */ SuppressLintQuickFix this$0;

                public final boolean value(PsiElement it) {
                    PsiElement psiElement = it;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it");
                    return SuppressLintQuickFix.access$isSuppressLintTarget(this.this$0, psiElement);
                }
                {
                    this.this$0 = suppressLintQuickFix;
                }
            }));
            if (psiElement == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"PsiTreeUtil.findFirstPar\u2026sLintTarget() } ?: return");
            PsiElement annotationContainer2 = psiElement;
            if (!FileModificationService.getInstance().preparePsiElementForWrite(annotationContainer2)) {
                return;
            }
            String argument = '\"' + Companion.getLintId(this.id) + '\"';
            PsiElement psiElement2 = annotationContainer2;
            if (!(psiElement2 instanceof KtModifierListOwner)) break block2;
            ModifierListModifactorKt.addAnnotation((KtModifierListOwner)((KtModifierListOwner)annotationContainer2), (FqName)FQNAME_SUPPRESS_LINT, (String)argument, (String)(this.isNewLineNeededForAnnotation((KtElement)annotationContainer2) ? "\n" : " "), (Function1)((Function1)new Function1<KtAnnotationEntry, Boolean>(argument){
                final /* synthetic */ String $argument;

                public final boolean invoke(@NotNull KtAnnotationEntry entry) {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    return com.android.tools.idea.lint.common.SuppressLintQuickFix$Companion.access$addArgumentToAnnotation(SuppressLintQuickFix.Companion, entry, this.$argument);
                }
                {
                    this.$argument = string;
                    super(1);
                }
            }));
        }
    }

    private final boolean isNewLineNeededForAnnotation(KtElement $this$isNewLineNeededForAnnotation) {
        return !($this$isNewLineNeededForAnnotation instanceof KtParameter) && !($this$isNewLineNeededForAnnotation instanceof KtTypeParameter) && !($this$isNewLineNeededForAnnotation instanceof KtPropertyAccessor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSuppressLintTarget(PsiElement $this$isSuppressLintTarget) {
        if (!($this$isSuppressLintTarget instanceof KtDeclaration)) return false;
        PsiElement psiElement = $this$isSuppressLintTarget;
        if (!(psiElement instanceof KtProperty)) {
            psiElement = null;
        }
        KtProperty ktProperty = (KtProperty)psiElement;
        if (!(ktProperty != null ? LintIdeUtilsKt.hasBackingField(ktProperty) : true)) return false;
        if ($this$isSuppressLintTarget instanceof KtFunctionLiteral) return false;
        if ($this$isSuppressLintTarget instanceof KtDestructuringDeclaration) return false;
        return true;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public SuppressLintQuickFix(@NotNull String id, @Nullable PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.label = Companion.displayName(element, this.id);
    }

    public /* synthetic */ SuppressLintQuickFix(String string, PsiElement psiElement, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            psiElement = null;
        }
        this(string, psiElement);
    }

    static {
        Companion = new Companion(null);
        FQNAME_SUPPRESS_LINT = new FqName("android.annotation.SuppressLint");
    }

    public static final /* synthetic */ boolean access$isSuppressLintTarget(SuppressLintQuickFix $this, PsiElement $this$access_u24isSuppressLintTarget) {
        return $this.isSuppressLintTarget($this$access_u24isSuppressLintTarget);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J \u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J,\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0018\u0010\u001d\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/lint/common/SuppressLintQuickFix$Companion;", "", "()V", "FQNAME_SUPPRESS_LINT", "Lorg/jetbrains/kotlin/name/FqName;", "NO_INSPECTION_PREFIX", "", "addArgumentToAnnotation", "", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "argument", "addSuppressAnnotation", "", "project", "Lcom/intellij/openapi/project/Project;", "container", "Lcom/intellij/psi/PsiElement;", "modifierOwner", "Lcom/intellij/psi/PsiModifierListOwner;", "id", "addSuppressAttribute", "file", "Lcom/intellij/psi/xml/XmlFile;", "element", "Lcom/intellij/psi/xml/XmlTag;", "createNewAnnotation", "Lcom/intellij/psi/PsiAnnotation;", "annotation", "displayName", "inspectionId", "getLintId", "intentionId", "intellij.android.lint"})
    public static final class Companion {
        @NotNull
        public final String getLintId(@NotNull String intentionId) {
            Intrinsics.checkNotNullParameter((Object)intentionId, (String)"intentionId");
            return StringsKt.removePrefix((String)intentionId, (CharSequence)"AndroidLint");
        }

        private final void addSuppressAttribute(XmlFile file, XmlTag element, String id) throws IncorrectOperationException {
            XmlAttribute attribute = element.getAttribute("ignore", "http://schemas.android.com/tools");
            String value = null;
            if (attribute == null || attribute.getValue() == null) {
                value = id;
            } else {
                ArrayList<String> ids = new ArrayList<String>();
                Splitter splitter = Splitter.on((char)',').trimResults();
                String string = attribute.getValue();
                Intrinsics.checkNotNull((Object)string);
                for (String existing : splitter.split((CharSequence)string)) {
                    if (!(Intrinsics.areEqual((Object)existing, (Object)id) ^ true)) continue;
                    ids.add(existing);
                }
                ids.add(id);
                CollectionsKt.sort((List)ids);
                String string2 = Joiner.on((char)',').join((Iterable)ids);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Joiner.on(',').join(ids)");
                value = string2;
            }
            LintIdeSupport.Companion.get().ensureNamespaceImported(file, "http://schemas.android.com/tools", null);
            element.setAttribute("ignore", "http://schemas.android.com/tools", value);
        }

        private final void addSuppressAnnotation(com.intellij.openapi.project.Project project, PsiElement container, PsiModifierListOwner modifierOwner, String id) throws IncorrectOperationException {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierOwner, (String[])new String[]{"android.annotation.SuppressLint"});
            PsiAnnotation newAnnotation = this.createNewAnnotation(project, container, annotation, id);
            if (newAnnotation != null) {
                if (annotation != null && annotation.isPhysical()) {
                    annotation.replace((PsiElement)newAnnotation);
                } else {
                    PsiAnnotationParameterList psiAnnotationParameterList = newAnnotation.getParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationParameterList, (String)"newAnnotation.parameterList");
                    PsiNameValuePair[] attributes = psiAnnotationParameterList.getAttributes();
                    new AddAnnotationFix("android.annotation.SuppressLint", modifierOwner, attributes, new String[0]).invoke(project, null, container.getContainingFile());
                }
            }
        }

        private final PsiAnnotation createNewAnnotation(com.intellij.openapi.project.Project project, PsiElement container, PsiAnnotation annotation, String id) {
            if (annotation != null) {
                String annotationText;
                String currentSuppressedId = "\"" + id + "\"";
                String string = annotationText = annotation.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"annotationText");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"{", (boolean)false, (int)2, null)) {
                    PsiAnnotationParameterList psiAnnotationParameterList = annotation.getParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationParameterList, (String)"annotation.parameterList");
                    PsiNameValuePair[] attributes = psiAnnotationParameterList.getAttributes();
                    if (attributes.length == 1) {
                        PsiAnnotation psiAnnotation;
                        String suppressedWarnings;
                        PsiNameValuePair psiNameValuePair = attributes[0];
                        Intrinsics.checkNotNullExpressionValue((Object)psiNameValuePair, (String)"attributes[0]");
                        String string2 = suppressedWarnings = psiNameValuePair.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"suppressedWarnings");
                        if (StringsKt.contains$default((CharSequence)string2, (CharSequence)currentSuppressedId, (boolean)false, (int)2, null)) {
                            psiAnnotation = null;
                        } else {
                            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project);
                            Intrinsics.checkNotNullExpressionValue((Object)javaPsiFacade, (String)"JavaPsiFacade.getInstance(\n              project)");
                            psiAnnotation = javaPsiFacade.getElementFactory().createAnnotationFromText("@android.annotation.SuppressLint({" + suppressedWarnings + ", " + currentSuppressedId + "})", container);
                        }
                        return psiAnnotation;
                    }
                } else {
                    int curlyBraceIndex = StringsKt.lastIndexOf$default((CharSequence)annotationText, (char)'}', (int)0, (boolean)false, (int)6, null);
                    if (curlyBraceIndex > 0) {
                        PsiAnnotation psiAnnotation;
                        String string3 = annotationText;
                        int n = 0;
                        boolean bl = false;
                        String string4 = string3.substring(n, curlyBraceIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String oldSuppressWarning = string4;
                        if (StringsKt.contains$default((CharSequence)oldSuppressWarning, (CharSequence)currentSuppressedId, (boolean)false, (int)2, null)) {
                            psiAnnotation = null;
                        } else {
                            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project);
                            Intrinsics.checkNotNullExpressionValue((Object)javaPsiFacade, (String)"JavaPsiFacade.getInstance(\n              project)");
                            psiAnnotation = javaPsiFacade.getElementFactory().createAnnotationFromText(oldSuppressWarning + ", " + currentSuppressedId + "})", container);
                        }
                        return psiAnnotation;
                    }
                }
            } else {
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)javaPsiFacade, (String)"JavaPsiFacade.getInstance(project)");
                return javaPsiFacade.getElementFactory().createAnnotationFromText("@android.annotation.SuppressLint(\"" + id + "\")", container);
            }
            return null;
        }

        private final boolean addArgumentToAnnotation(KtAnnotationEntry entry, String argument) {
            block5: {
                boolean bl;
                KtValueArgumentList newArgList;
                KtValueArgumentList args;
                block3: {
                    block6: {
                        block4: {
                            args = entry.getValueArgumentList();
                            KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)entry), (boolean)false, (int)2, null);
                            newArgList = psiFactory.createCallArguments('(' + argument + ')');
                            if (args != null) break block4;
                            entry.addAfter((PsiElement)newArgList, entry.getLastChild());
                            break block5;
                        }
                        if (!args.getArguments().isEmpty()) break block6;
                        args.replace((PsiElement)newArgList);
                        break block5;
                    }
                    List list = args.getArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"args.arguments");
                    Iterable $this$none$iv = list;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            KtValueArgument it = (KtValueArgument)element$iv;
                            boolean bl2 = false;
                            if (!it.textMatches((CharSequence)argument)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block5;
                args.addArgument((KtValueArgument)newArgList.getArguments().get(0));
            }
            return true;
        }

        @NotNull
        public final String displayName(@Nullable PsiElement element, @NotNull String inspectionId) {
            Language language;
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            String id = this.getLintId(inspectionId);
            PsiElement psiElement = element;
            Object object = language = psiElement != null ? psiElement.getLanguage() : null;
            return Intrinsics.areEqual((Object)language, (Object)XMLLanguage.INSTANCE) ? LintBundle.Companion.message("android.lint.fix.suppress.lint.api.attr", id) : (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE) || Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE) ? LintBundle.Companion.message("android.lint.fix.suppress.lint.api.annotation", id) : (Intrinsics.areEqual((Object)language, (Object)GroovyLanguage.INSTANCE) ? "Suppress: Add //noinspection " + id : "Suppress " + id));
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$addArgumentToAnnotation(Companion $this, KtAnnotationEntry entry, String argument) {
            return $this.addArgumentToAnnotation(entry, argument);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

