/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.forward;

import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.io.ByteSequenceDataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentMapBasedForwardIndex
implements ForwardIndex {
    @NotNull
    private volatile PersistentHashMap<Integer, ByteArraySequence> myPersistentMap;
    @NotNull
    private final Path myMapFile;
    private final boolean myUseChunks;
    private final boolean myReadOnly;

    public PersistentMapBasedForwardIndex(@NotNull Path mapFile, boolean isReadOnly) throws IOException {
        if (mapFile == null) {
            PersistentMapBasedForwardIndex.$$$reportNull$$$0(0);
        }
        this(mapFile, true, isReadOnly);
    }

    public PersistentMapBasedForwardIndex(@NotNull Path mapFile, boolean useChunks, boolean isReadOnly) throws IOException {
        if (mapFile == null) {
            PersistentMapBasedForwardIndex.$$$reportNull$$$0(1);
        }
        this.myPersistentMap = PersistentMapBasedForwardIndex.createMap(mapFile, useChunks, isReadOnly);
        this.myMapFile = mapFile;
        this.myUseChunks = useChunks;
        this.myReadOnly = isReadOnly;
    }

    @Override
    @Nullable
    public ByteArraySequence get(@NotNull Integer key) throws IOException {
        if (key == null) {
            PersistentMapBasedForwardIndex.$$$reportNull$$$0(2);
        }
        return this.myPersistentMap.get(key);
    }

    @Override
    public void put(@NotNull Integer key, @Nullable ByteArraySequence value) throws IOException {
        if (key == null) {
            PersistentMapBasedForwardIndex.$$$reportNull$$$0(3);
        }
        if (value == null) {
            this.myPersistentMap.remove(key);
        } else {
            this.myPersistentMap.put(key, value);
        }
    }

    @Override
    public void force() {
        this.myPersistentMap.force();
    }

    @Override
    public void clear() throws IOException {
        PersistentHashMap.deleteMap(this.myPersistentMap);
        this.myPersistentMap = PersistentMapBasedForwardIndex.createMap(this.myMapFile, this.myUseChunks, this.myReadOnly);
    }

    @Override
    public void close() throws IOException {
        this.myPersistentMap.close();
    }

    public boolean containsMapping(int key) throws IOException {
        return this.myPersistentMap.containsMapping(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static PersistentHashMap<Integer, ByteArraySequence> createMap(@NotNull Path file, boolean useChunks, boolean isReadOnly) throws IOException {
        if (file == null) {
            PersistentMapBasedForwardIndex.$$$reportNull$$$0(4);
        }
        Boolean oldHasNoChunksValue = PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.get();
        PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(!useChunks);
        Boolean previousReadOnly = PersistentHashMapValueStorage.CreationTimeOptions.READONLY.get();
        PersistentHashMapValueStorage.CreationTimeOptions.READONLY.set(isReadOnly);
        PersistentHashMap<Integer, ByteArraySequence> persistentHashMap = new PersistentHashMap<Integer, ByteArraySequence>(file, EnumeratorIntegerDescriptor.INSTANCE, ByteSequenceDataExternalizer.INSTANCE);
        PersistentHashMap<Integer, ByteArraySequence> persistentHashMap2 = persistentHashMap;
        if (persistentHashMap2 == null) {
            PersistentMapBasedForwardIndex.$$$reportNull$$$0(5);
        }
        return persistentHashMap2;
        finally {
            PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(oldHasNoChunksValue);
            PersistentHashMapValueStorage.CreationTimeOptions.READONLY.set(previousReadOnly);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/forward/PersistentMapBasedForwardIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/forward/PersistentMapBasedForwardIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createMap";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

