/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant;

import com.intellij.buildfiles.ForcedBuildFileAttribute;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import java.io.DataInputStream;
import java.io.IOException;

public final class ForcedAntFileAttribute
extends FileAttribute {
    private static final Logger LOG = Logger.getInstance(ForcedAntFileAttribute.class);
    private static final String ANT_ID = "ant";
    private static final ForcedAntFileAttribute ourAttribute = new ForcedAntFileAttribute();
    private static final Key<Boolean> ourAntFileMarker = Key.create((String)"_forced_ant_attribute_");

    public ForcedAntFileAttribute() {
        super("_forced_ant_attribute_", 1, true);
    }

    public static boolean isAntFile(VirtualFile file) {
        String id = ForcedBuildFileAttribute.getFrameworkIdOfBuildFile((VirtualFile)file);
        return ANT_ID.equals(id) || StringUtil.isEmpty((String)id) && ForcedAntFileAttribute.isAntFileOld(file);
    }

    public static boolean mayBeAntFile(VirtualFile file) {
        String id = ForcedBuildFileAttribute.getFrameworkIdOfBuildFile((VirtualFile)file);
        return StringUtil.isEmpty((String)id) || ANT_ID.equals(id);
    }

    private static boolean isAntFileOld(VirtualFile file) {
        if (file instanceof NewVirtualFile) {
            DataInputStream is = ourAttribute.readAttribute(file);
            if (is != null) {
                boolean bl;
                try {
                    bl = is.readBoolean();
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
                is.close();
                return bl;
            }
            return false;
        }
        return Boolean.TRUE.equals(file.getUserData(ourAntFileMarker));
    }

    public static void forceAntFile(VirtualFile file, boolean value) {
        ForcedBuildFileAttribute.forceFileToFramework((VirtualFile)file, (String)ANT_ID, (boolean)value);
    }
}

