/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.AbstractValidatingNamedDomainObjectContainer;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.ConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DefaultConfiguration;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.DetachedConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.dsl.CapabilityNotationParserFactory;
import org.gradle.api.internal.artifacts.dsl.PublishArtifactNotationParserFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionRules;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.DefaultRootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.LocalComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.CapabilitiesResolutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultCapabilitiesResolution;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultResolutionStrategy;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.notations.ComponentIdentifierParserFactory;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.model.ObjectFactory;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.initialization.ProjectAccessListener;
import org.gradle.internal.Factory;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.vcs.internal.VcsMappingsStore;

public class DefaultConfigurationContainer
extends AbstractValidatingNamedDomainObjectContainer<Configuration>
implements ConfigurationContainerInternal,
ConfigurationsProvider {
    public static final String DETACHED_CONFIGURATION_DEFAULT_NAME = "detachedConfiguration";
    private final ConfigurationResolver resolver;
    private final Instantiator instantiator;
    private final DomainObjectContext context;
    private final ListenerManager listenerManager;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final ProjectAccessListener projectAccessListener;
    private final FileCollectionFactory fileCollectionFactory;
    private final BuildOperationExecutor buildOperationExecutor;
    private final UserCodeApplicationContext userCodeApplicationContext;
    private final NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser;
    private final NotationParser<Object, Capability> capabilityNotationParser;
    private final ImmutableAttributesFactory attributesFactory;
    private final ProjectStateRegistry projectStateRegistry;
    private final DocumentationRegistry documentationRegistry;
    private final AtomicInteger detachedConfigurationDefaultNameCounter = new AtomicInteger(1);
    private final Factory<ResolutionStrategyInternal> resolutionStrategyFactory;
    private final DefaultRootComponentMetadataBuilder rootComponentMetadataBuilder;
    private final DomainObjectCollectionFactory domainObjectCollectionFactory;

    public DefaultConfigurationContainer(ConfigurationResolver resolver, Instantiator instantiator, DomainObjectContext context, ListenerManager listenerManager, DependencyMetaDataProvider dependencyMetaDataProvider, ProjectAccessListener projectAccessListener, LocalComponentMetadataBuilder localComponentMetadataBuilder, FileCollectionFactory fileCollectionFactory, DependencySubstitutionRules globalDependencySubstitutionRules, VcsMappingsStore vcsMappingsStore, ComponentIdentifierFactory componentIdentifierFactory, BuildOperationExecutor buildOperationExecutor, TaskResolver taskResolver, ImmutableAttributesFactory attributesFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ComponentSelectorConverter componentSelectorConverter, DependencyLockingProvider dependencyLockingProvider, ProjectStateRegistry projectStateRegistry, DocumentationRegistry documentationRegistry, CollectionCallbackActionDecorator callbackDecorator, UserCodeApplicationContext userCodeApplicationContext, DomainObjectCollectionFactory domainObjectCollectionFactory, NotationParser<Object, ComponentSelector> moduleSelectorNotationParser, ObjectFactory objectFactory) {
        super(Configuration.class, instantiator, new Configuration.Namer(), callbackDecorator);
        this.resolver = resolver;
        this.instantiator = instantiator;
        this.context = context;
        this.listenerManager = listenerManager;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.projectAccessListener = projectAccessListener;
        this.fileCollectionFactory = fileCollectionFactory;
        this.buildOperationExecutor = buildOperationExecutor;
        this.userCodeApplicationContext = userCodeApplicationContext;
        this.domainObjectCollectionFactory = domainObjectCollectionFactory;
        this.artifactNotationParser = new PublishArtifactNotationParserFactory(instantiator, dependencyMetaDataProvider, taskResolver).create();
        this.capabilityNotationParser = new CapabilityNotationParserFactory(true).create();
        this.attributesFactory = attributesFactory;
        this.projectStateRegistry = projectStateRegistry;
        this.documentationRegistry = documentationRegistry;
        Object dependencyCapabilityNotationParser = new CapabilityNotationParserFactory(false).create();
        this.resolutionStrategyFactory = () -> DefaultConfigurationContainer.lambda$new$0(instantiator, globalDependencySubstitutionRules, vcsMappingsStore, componentIdentifierFactory, moduleIdentifierFactory, componentSelectorConverter, dependencyLockingProvider, objectFactory, attributesFactory, moduleSelectorNotationParser, (NotationParser)dependencyCapabilityNotationParser);
        this.rootComponentMetadataBuilder = new DefaultRootComponentMetadataBuilder(dependencyMetaDataProvider, componentIdentifierFactory, moduleIdentifierFactory, localComponentMetadataBuilder, this, projectStateRegistry, dependencyLockingProvider);
    }

    @Override
    protected Configuration doCreate(String name) {
        DefaultConfiguration configuration = this.instantiator.newInstance(DefaultConfiguration.class, this.context, name, this, this.resolver, this.listenerManager, this.dependencyMetaDataProvider, this.resolutionStrategyFactory, this.projectAccessListener, this.fileCollectionFactory, this.buildOperationExecutor, this.instantiator, this.artifactNotationParser, this.capabilityNotationParser, this.attributesFactory, this.rootComponentMetadataBuilder, this.documentationRegistry, this.userCodeApplicationContext, this.context, this.projectStateRegistry, this.domainObjectCollectionFactory);
        configuration.addMutationValidator(this.rootComponentMetadataBuilder.getValidator());
        return configuration;
    }

    @Override
    public Set<? extends ConfigurationInternal> getAll() {
        return this.withType(ConfigurationInternal.class);
    }

    @Override
    public ConfigurationInternal getByName(String name) {
        return (ConfigurationInternal)super.getByName(name);
    }

    @Override
    public String getTypeDisplayName() {
        return "configuration";
    }

    @Override
    protected UnknownDomainObjectException createNotFoundException(String name) {
        return new UnknownConfigurationException(String.format("Configuration with name '%s' not found.", name));
    }

    @Override
    public ConfigurationInternal detachedConfiguration(Dependency ... dependencies) {
        String name = DETACHED_CONFIGURATION_DEFAULT_NAME + this.detachedConfigurationDefaultNameCounter.getAndIncrement();
        DetachedConfigurationsProvider detachedConfigurationsProvider = new DetachedConfigurationsProvider();
        DefaultConfiguration detachedConfiguration = this.instantiator.newInstance(DefaultConfiguration.class, this.context, name, detachedConfigurationsProvider, this.resolver, this.listenerManager, this.dependencyMetaDataProvider, this.resolutionStrategyFactory, this.projectAccessListener, this.fileCollectionFactory, this.buildOperationExecutor, this.instantiator, this.artifactNotationParser, this.capabilityNotationParser, this.attributesFactory, this.rootComponentMetadataBuilder.withConfigurationsProvider(detachedConfigurationsProvider), this.documentationRegistry, this.userCodeApplicationContext, this.context, this.projectStateRegistry, this.domainObjectCollectionFactory);
        DependencySet detachedDependencies = detachedConfiguration.getDependencies();
        for (Dependency dependency : dependencies) {
            detachedDependencies.add(dependency.copy());
        }
        detachedConfigurationsProvider.setTheOnlyConfiguration(detachedConfiguration);
        return detachedConfiguration;
    }

    public String dump() {
        StringBuilder reply = new StringBuilder();
        reply.append("Configuration of type: ").append(this.getTypeDisplayName());
        Set<? extends ConfigurationInternal> configs = this.getAll();
        for (Configuration configuration : configs) {
            reply.append("\n  ").append(configuration.toString());
        }
        return reply.toString();
    }

    private static /* synthetic */ ResolutionStrategyInternal lambda$new$0(Instantiator instantiator, DependencySubstitutionRules globalDependencySubstitutionRules, VcsMappingsStore vcsMappingsStore, ComponentIdentifierFactory componentIdentifierFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ComponentSelectorConverter componentSelectorConverter, DependencyLockingProvider dependencyLockingProvider, ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory, NotationParser moduleSelectorNotationParser, NotationParser dependencyCapabilityNotationParser) {
        CapabilitiesResolutionInternal capabilitiesResolutionInternal = instantiator.newInstance(DefaultCapabilitiesResolution.class, new CapabilityNotationParserFactory(false).create(), new ComponentIdentifierParserFactory().create());
        return instantiator.newInstance(DefaultResolutionStrategy.class, globalDependencySubstitutionRules, vcsMappingsStore, componentIdentifierFactory, moduleIdentifierFactory, componentSelectorConverter, dependencyLockingProvider, capabilitiesResolutionInternal, instantiator, objectFactory, attributesFactory, moduleSelectorNotationParser, dependencyCapabilityNotationParser);
    }
}

