/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipFile;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.api.internal.file.archive.ZipInput;
import org.gradle.api.internal.file.archive.impl.JdkZipEntry;
import org.gradle.api.internal.file.archive.impl.StreamZipInput;
import org.gradle.internal.file.FileException;
import org.gradle.internal.impldep.com.google.common.base.Supplier;
import org.gradle.internal.impldep.com.google.common.collect.AbstractIterator;

public class FileZipInput
implements ZipInput {
    private final ZipFile file;
    private final Enumeration<? extends java.util.zip.ZipEntry> entries;

    public static ZipInput create(File file) throws FileException {
        if (FileZipInput.isZipFileSafeToUse()) {
            return new FileZipInput(file);
        }
        try {
            return new StreamZipInput(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new FileException(e);
        }
    }

    private static boolean isZipFileSafeToUse() {
        String versionString = System.getProperty("java.specification.version");
        String[] versionParts = versionString.split("\\.");
        if (versionParts.length < 1) {
            throw new IllegalArgumentException("Could not determine java version from '" + versionString + "'.");
        }
        return Integer.parseInt(versionParts[0]) >= 11;
    }

    private FileZipInput(File file) {
        try {
            this.file = new ZipFile(file);
        }
        catch (IOException e) {
            throw new FileException(e);
        }
        this.entries = this.file.entries();
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        return new AbstractIterator<ZipEntry>(){

            protected ZipEntry computeNext() {
                if (!FileZipInput.this.entries.hasMoreElements()) {
                    return (ZipEntry)this.endOfData();
                }
                final java.util.zip.ZipEntry zipEntry = (java.util.zip.ZipEntry)FileZipInput.this.entries.nextElement();
                return new JdkZipEntry(zipEntry, new Supplier<InputStream>(){

                    public InputStream get() {
                        try {
                            return FileZipInput.this.file.getInputStream(zipEntry);
                        }
                        catch (IOException e) {
                            throw new FileException(e);
                        }
                    }
                });
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }
}

