/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import java.io.File;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotData;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.MinimalPersistentCache;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.vfs.FileSystemAccess;

public class DefaultClasspathEntrySnapshotCache
implements ClasspathEntrySnapshotCache {
    private final FileSystemAccess fileSystemAccess;
    private final MinimalPersistentCache<HashCode, ClasspathEntrySnapshotData> cache;

    public DefaultClasspathEntrySnapshotCache(FileSystemAccess fileSystemAccess, PersistentIndexedCache<HashCode, ClasspathEntrySnapshotData> persistentCache) {
        this.fileSystemAccess = fileSystemAccess;
        this.cache = new MinimalPersistentCache<HashCode, ClasspathEntrySnapshotData>(persistentCache);
    }

    @Override
    public ClasspathEntrySnapshot get(File file, HashCode hash) {
        ClasspathEntrySnapshotData data = this.cache.get(hash);
        return data != null ? new ClasspathEntrySnapshot(data) : null;
    }

    @Override
    public ClasspathEntrySnapshot get(File key, Factory<ClasspathEntrySnapshot> factory) {
        HashCode fileContentHash = this.fileSystemAccess.read(key.getAbsolutePath(), CompleteFileSystemLocationSnapshot::getHash);
        return new ClasspathEntrySnapshot(this.cache.get(fileContentHash, () -> ((ClasspathEntrySnapshot)factory.create()).getData()));
    }
}

