/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.DefaultProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.plugins.BuildConfigurationRule;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.plugins.UploadRule;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.internal.DefaultBasePluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Upload;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.configuration.project.ProjectConfigurationActionContainer;
import org.gradle.internal.Describables;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.jvm.tasks.Jar;
import org.gradle.language.base.plugins.LifecycleBasePlugin;

public class BasePlugin
implements Plugin<Project> {
    public static final String CLEAN_TASK_NAME = "clean";
    public static final String ASSEMBLE_TASK_NAME = "assemble";
    public static final String BUILD_GROUP = "build";
    public static final String UPLOAD_ARCHIVES_TASK_NAME = "uploadArchives";
    public static final String UPLOAD_GROUP = "upload";
    private final ProjectPublicationRegistry publicationRegistry;
    private final ProjectConfigurationActionContainer configurationActionContainer;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    @Inject
    public BasePlugin(ProjectPublicationRegistry publicationRegistry, ProjectConfigurationActionContainer configurationActionContainer, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.publicationRegistry = publicationRegistry;
        this.configurationActionContainer = configurationActionContainer;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        DefaultBasePluginConvention convention = new DefaultBasePluginConvention(project);
        project.getConvention().getPlugins().put("base", convention);
        this.configureBuildConfigurationRule(project);
        this.configureUploadRules(project);
        this.configureUploadArchivesTask();
        this.configureArchiveDefaults(project, convention);
        this.configureConfigurations(project);
        this.configureAssemble((ProjectInternal)project);
    }

    private void configureArchiveDefaults(Project project, BasePluginConvention pluginConvention) {
        project.getTasks().withType(AbstractArchiveTask.class).configureEach(task -> {
            if (task instanceof Jar) {
                task.getDestinationDirectory().convention((Provider)pluginConvention.getLibsDirectory());
            } else {
                task.getDestinationDirectory().convention((Provider)pluginConvention.getDistsDirectory());
            }
            task.getArchiveVersion().convention(project.provider(() -> project.getVersion() == "unspecified" ? null : project.getVersion().toString()));
            task.getArchiveBaseName().convention(project.provider(() -> pluginConvention.getArchivesBaseName()));
        });
    }

    private void configureBuildConfigurationRule(Project project) {
        project.getTasks().addRule(new BuildConfigurationRule(project.getConfigurations(), project.getTasks()));
    }

    private void configureUploadRules(Project project) {
        project.getTasks().addRule(new UploadRule(project));
    }

    private void configureUploadArchivesTask() {
        this.configurationActionContainer.add(project -> {
            boolean hasIvyRepo;
            Upload uploadArchives = (Upload)project.getTasks().withType(Upload.class).findByName(UPLOAD_ARCHIVES_TASK_NAME);
            if (uploadArchives == null) {
                return;
            }
            AtomicBoolean usesMaven = new AtomicBoolean();
            project.getPluginManager().withPlugin("maven", p -> usesMaven.set(true));
            uploadArchives.doFirst(SerializableLambdas.action(task -> ((DeprecationMessageBuilder.DeprecateTask)DeprecationLogger.deprecateTask(UPLOAD_ARCHIVES_TASK_NAME).withAdvice("Use the " + (usesMaven.get() ? "'maven-publish'" : "'ivy-publish'") + " plugin instead.")).willBeRemovedInGradle7().withUpgradeGuideSection(5, "legacy_publication_system_is_deprecated_and_replaced_with_the_publish_plugins").nagUser()));
            boolean bl = hasIvyRepo = !uploadArchives.getRepositories().withType(IvyArtifactRepository.class).isEmpty();
            if (!hasIvyRepo) {
                return;
            }
            ConfigurationInternal configuration = (ConfigurationInternal)uploadArchives.getConfiguration();
            Module module = configuration.getModule();
            ModuleVersionIdentifier publicationId = this.moduleIdentifierFactory.moduleWithVersion(module.getGroup(), module.getName(), module.getVersion());
            this.publicationRegistry.registerPublication((ProjectInternal)project, new DefaultProjectPublication(Describables.of("Ivy publication"), publicationId, true));
        });
    }

    private void configureConfigurations(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        project.setStatus("integration");
        DeprecatableConfiguration archivesConfiguration = (DeprecatableConfiguration)((Configuration)configurations.maybeCreate("archives")).setDescription("Configuration for archive artifacts.");
        DeprecatableConfiguration defaultConfiguration = (DeprecatableConfiguration)((Configuration)configurations.maybeCreate("default")).setDescription("Configuration for default artifacts.");
        DefaultArtifactPublicationSet defaultArtifacts = project.getExtensions().create("defaultArtifacts", DefaultArtifactPublicationSet.class, archivesConfiguration.getArtifacts());
        archivesConfiguration.deprecateForResolution("compileClasspath", "runtimeClasspath");
        defaultConfiguration.deprecateForResolution("compileClasspath", "runtimeClasspath");
        archivesConfiguration.deprecateForDeclaration("implementation", "api");
        defaultConfiguration.deprecateForDeclaration("implementation", "api");
        configurations.all(configuration -> {
            if (!configuration.equals(archivesConfiguration)) {
                configuration.getArtifacts().configureEach(artifact -> {
                    if (configuration.isVisible()) {
                        defaultArtifacts.addCandidate((PublishArtifact)artifact);
                    }
                });
            }
        });
    }

    private void configureAssemble(ProjectInternal project) {
        project.getTasks().named(ASSEMBLE_TASK_NAME, task -> task.dependsOn(task.getProject().getConfigurations().getByName("archives").getAllArtifacts().getBuildDependencies()));
    }
}

