/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util.lifetime;

import com.jetbrains.rd.util.BitHacksKt;
import com.jetbrains.rd.util.BitSlice;
import com.jetbrains.rd.util.BitSliceKt;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.PlatformDependentKt;
import com.jetbrains.rd.util.lifetime.ClearLifetimeMarker;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.LifetimeStatus;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.threading.SpinWait;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 02\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b\u0013J5\u0010\u0014\u001a\u0004\u0018\u0001H\u0015\"\b\b\u0000\u0010\u0015*\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0011H\u0002J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J'\u0010\u001e\u001a\u0004\u0018\u0001H\u0015\"\b\b\u0000\u0010\u0015*\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017H\u0016\u00a2\u0006\u0002\u0010 J\u001d\u0010!\u001a\u00020\u001d2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001d0#H\u0082\bJ\b\u0010%\u001a\u00020\u001dH\u0002J\u0016\u0010&\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017H\u0016J\u0014\u0010&\u001a\u00020\u001d2\n\u0010'\u001a\u00060(j\u0002`)H\u0016J\u0010\u0010*\u001a\u00020\u001d2\b\b\u0002\u0010+\u001a\u00020\u001dJ\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\bH\u0002J4\u0010-\u001a\u0004\u0018\u0001H\u0015\"\u0004\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u00172\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001d0#H\u0082\f\u00a2\u0006\u0002\u0010.J4\u0010/\u001a\u0004\u0018\u0001H\u0015\"\u0004\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u00172\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001d0#H\u0082\f\u00a2\u0006\u0002\u0010.R\u0011\u0010\u0003\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00061"}, d2={"Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "()V", "lifetime", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "resources", "", "", "state", "Ljava/util/concurrent/atomic/AtomicInteger;", "Lcom/jetbrains/rd/util/AtomicInteger;", "status", "Lcom/jetbrains/rd/util/lifetime/LifetimeStatus;", "getStatus", "()Lcom/jetbrains/rd/util/lifetime/LifetimeStatus;", "attach", "", "child", "attach$rd_core", "bracket", "T", "opening", "Lkotlin/Function0;", "terminationAction", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "clearObsoleteAttachedLifetimes", "destruct", "supportsRecursion", "", "executeIfAlive", "action", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "incrementStatusIf", "check", "Lkotlin/Function1;", "", "markCanceledRecursively", "onTerminationIfAlive", "closeable", "Ljava/io/Closeable;", "Lcom/jetbrains/rd/util/Closeable;", "terminate", "supportsTerminationUnderExecuting", "tryAdd", "executeIf", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "underMutexIf", "Companion", "rd-core"})
public final class LifetimeDefinition
extends Lifetime {
    private AtomicInteger state = new AtomicInteger();
    private List<Object> resources;
    @NotNull
    private static final LifetimeDefinition eternal;
    private static final Lazy log$delegate;
    private static final BitSlice.TypedBitSlice<Integer> executingSlice;
    private static final BitSlice.TypedBitSlice<LifetimeStatus> statusSlice;
    private static final BitSlice.TypedBitSlice<Boolean> mutexSlice;
    @NotNull
    private static final LifetimeDefinition Terminated;
    public static final Companion Companion;

    @NotNull
    public final Lifetime getLifetime() {
        return this;
    }

    @Override
    @NotNull
    public LifetimeStatus getStatus() {
        return BitSliceKt.get(statusSlice, this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T executeIf(Function0<? extends T> $this$executeIf, Function1<? super Integer, Boolean> check) {
        int s;
        int $i$f$executeIf = 0;
        do {
            if (((Boolean)check.invoke((Object)(s = this.state.get()))).booleanValue()) continue;
            return null;
        } while (!this.state.compareAndSet(s, s + 1));
        Lifetime.Companion.getThreadLocalExecuting$rd_core().add(this, 1);
        try {
            Object object = $this$executeIf.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            Lifetime.Companion.getThreadLocalExecuting$rd_core().add(this, -1);
            this.state.decrementAndGet();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T underMutexIf(Function0<? extends T> $this$underMutexIf, Function1<? super Integer, Boolean> check) {
        int s;
        int $i$f$underMutexIf = 0;
        do {
            if (((Boolean)check.invoke((Object)(s = this.state.get()))).booleanValue()) continue;
            return null;
        } while (((Boolean)LifetimeDefinition.mutexSlice.get(s)).booleanValue() || !this.state.compareAndSet(s, LifetimeDefinition.mutexSlice.updated(s, true)));
        try {
            Object object = $this$underMutexIf.invoke();
            return (T)object;
        }
        finally {
            int s2;
            InlineMarker.finallyStart((int)1);
            do {
                s2 = this.state.get();
                PlatformDependentKt.assert((Boolean)LifetimeDefinition.mutexSlice.get(s2));
            } while (!this.state.compareAndSet(s2, LifetimeDefinition.mutexSlice.updated(s2, false)));
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T executeIfAlive(@NotNull Function0<? extends T> action) {
        Object object;
        block4: {
            int s$iv;
            Intrinsics.checkNotNullParameter(action, (String)"action");
            Function0<? extends T> $this$executeIf$iv = action;
            LifetimeDefinition this_$iv = this;
            boolean $i$f$executeIf = false;
            do {
                int state = s$iv = this_$iv.state.get();
                boolean bl = false;
                if (statusSlice.get(state) == LifetimeStatus.Alive) continue;
                object = null;
                break block4;
            } while (!this_$iv.state.compareAndSet(s$iv, s$iv + 1));
            Lifetime.Companion.getThreadLocalExecuting$rd_core().add(this_$iv, 1);
            try {
                Object object2 = $this$executeIf$iv.invoke();
                object = object2;
            }
            finally {
                Lifetime.Companion.getThreadLocalExecuting$rd_core().add(this_$iv, -1);
                this_$iv.state.decrementAndGet();
            }
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean tryAdd(Object action) {
        Object object;
        block6: {
            int s$iv;
            if (this.getLifetime() == eternal) {
                return true;
            }
            Function0 $this$underMutexIf$iv = (Function0)new Function0<Boolean>(this, action){
                final /* synthetic */ LifetimeDefinition this$0;
                final /* synthetic */ Object $action;

                public final boolean invoke() {
                    LifetimeDefinition.access$getResources$p(this.this$0).add(this.$action);
                    return true;
                }
                {
                    this.this$0 = lifetimeDefinition;
                    this.$action = object;
                    super(0);
                }
            };
            LifetimeDefinition this_$iv = this;
            boolean $i$f$underMutexIf = false;
            do {
                int it = s$iv = this_$iv.state.get();
                boolean bl = false;
                if (statusSlice.get(it).compareTo((Enum)LifetimeStatus.Terminating) < 0) continue;
                object = null;
                break block6;
            } while (((Boolean)LifetimeDefinition.mutexSlice.get(s$iv)).booleanValue() || !this_$iv.state.compareAndSet(s$iv, LifetimeDefinition.mutexSlice.updated(s$iv, true)));
            try {
                Object object2 = $this$underMutexIf$iv.invoke();
                object = object2;
            }
            finally {
                int s$iv2;
                do {
                    s$iv2 = this_$iv.state.get();
                    PlatformDependentKt.assert((Boolean)LifetimeDefinition.mutexSlice.get(s$iv2));
                } while (!this_$iv.state.compareAndSet(s$iv2, LifetimeDefinition.mutexSlice.updated(s$iv2, false)));
            }
        }
        Boolean bl = (Boolean)object;
        return bl != null ? bl : false;
    }

    private final boolean incrementStatusIf(Function1<? super Integer, Boolean> check) {
        int newS;
        int s;
        int $i$f$incrementStatusIf = 0;
        boolean value$iv = this != Companion.getEternal$rd_core();
        boolean $i$f$assert = false;
        boolean bl = false;
        if (_Assertions.ENABLED && !value$iv) {
            boolean bl2 = false;
            String string = "Trying to change eternal lifetime";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        do {
            if (!((Boolean)check.invoke((Object)(s = this.state.get()))).booleanValue()) {
                return false;
            }
            LifetimeStatus nextStatus = LifetimeStatus.values()[((LifetimeStatus)((Object)LifetimeDefinition.statusSlice.get(s))).ordinal() + 1];
            newS = LifetimeDefinition.statusSlice.updated(s, nextStatus);
        } while (!this.state.compareAndSet(s, newS));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean markCanceledRecursively() {
        Object object;
        block12: {
            int s$iv;
            boolean bl;
            LifetimeDefinition this_$iv;
            block11: {
                int newS$iv;
                int s$iv2;
                boolean value$iv = this != eternal;
                boolean $i$f$assert = false;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !value$iv) {
                    boolean $i$a$-assert-LifetimeDefinition$markCanceledRecursively$22 = false;
                    String $i$a$-assert-LifetimeDefinition$markCanceledRecursively$22 = "Trying to terminate eternal lifetime";
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-LifetimeDefinition$markCanceledRecursively$22));
                }
                this_$iv = this;
                boolean $i$f$incrementStatusIf = false;
                boolean value$iv$iv = this_$iv != Companion.getEternal$rd_core();
                boolean $i$f$assert2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !value$iv$iv) {
                    boolean $i$a$-assert-LifetimeDefinition$incrementStatusIf$1$iv22 = false;
                    String $i$a$-assert-LifetimeDefinition$incrementStatusIf$1$iv22 = "Trying to change eternal lifetime";
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-LifetimeDefinition$incrementStatusIf$1$iv22));
                }
                do {
                    int it = s$iv2 = this_$iv.state.get();
                    boolean bl4 = false;
                    if (!(statusSlice.get(it) == LifetimeStatus.Alive)) {
                        bl = false;
                        break block11;
                    }
                    LifetimeStatus nextStatus$iv = LifetimeStatus.values()[((LifetimeStatus)((Object)LifetimeDefinition.statusSlice.get(s$iv2))).ordinal() + 1];
                    newS$iv = LifetimeDefinition.statusSlice.updated(s$iv2, nextStatus$iv);
                } while (!this_$iv.state.compareAndSet(s$iv2, newS$iv));
                bl = true;
            }
            if (!bl) {
                return false;
            }
            Function0 $this$underMutexIf$iv = (Function0)new Function0<Unit>(this){
                final /* synthetic */ LifetimeDefinition this$0;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    int n = CollectionsKt.getLastIndex((List)LifetimeDefinition.access$getResources$p(this.this$0));
                    boolean bl = false;
                    while (n >= 0) {
                        void i;
                        E e = LifetimeDefinition.access$getResources$p(this.this$0).get((int)i);
                        if (!(e instanceof LifetimeDefinition)) {
                            e = null;
                        }
                        if ((LifetimeDefinition)e == null) {
                        } else {
                            LifetimeDefinition def;
                            LifetimeDefinition.access$markCanceledRecursively(def);
                        }
                        --i;
                    }
                }
                {
                    this.this$0 = lifetimeDefinition;
                    super(0);
                }
            };
            this_$iv = this;
            boolean $i$f$underMutexIf = false;
            do {
                int it = s$iv = this_$iv.state.get();
                boolean bl5 = false;
                if (statusSlice.get(it).compareTo((Enum)LifetimeStatus.Terminating) < 0) continue;
                object = null;
                break block12;
            } while (((Boolean)LifetimeDefinition.mutexSlice.get(s$iv)).booleanValue() || !this_$iv.state.compareAndSet(s$iv, LifetimeDefinition.mutexSlice.updated(s$iv, true)));
            try {
                Object object2 = $this$underMutexIf$iv.invoke();
                object = object2;
            }
            finally {
                int s$iv3;
                do {
                    s$iv3 = this_$iv.state.get();
                    PlatformDependentKt.assert((Boolean)LifetimeDefinition.mutexSlice.get(s$iv3));
                } while (!this_$iv.state.compareAndSet(s$iv3, LifetimeDefinition.mutexSlice.updated(s$iv3, false)));
            }
        }
        return (Unit)object != null;
        {
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean terminate(boolean supportsTerminationUnderExecuting) {
        boolean bl;
        boolean $i$f$spinUntil5;
        block14: {
            int newS$iv;
            int s$iv;
            boolean $i$f$log;
            boolean bl2;
            block13: {
                void this_$iv$iv$iv;
                if (RLifetimeKt.isEternal(this)) {
                    return false;
                }
                if (((Number)Lifetime.Companion.getThreadLocalExecuting$rd_core().get((Object)this)).intValue() > 0 && !supportsTerminationUnderExecuting) {
                    String string = "Can't terminate lifetime under `executeIfAlive` because termination doesn't support this. Use `terminate(true)`";
                    boolean bl3 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                this.markCanceledRecursively();
                long timeoutMs$iv = Lifetime.Companion.getWaitForExecutingInTerminationTimeout();
                $i$f$spinUntil5 = false;
                SpinWait.Companion this_$iv$iv = SpinWait.Companion;
                boolean $i$f$spinUntil2 = false;
                SpinWait.Companion companion = this_$iv$iv;
                Lifetime lifetime$iv$iv$iv = Lifetime.Companion.getEternal();
                boolean $i$f$spinUntil3 = false;
                void var10_26 = this_$iv$iv$iv;
                Duration duration = Duration.ofMillis(timeoutMs$iv);
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ofMillis(timeoutMs)");
                Duration duration$iv$iv$iv$iv = duration;
                boolean $i$f$spinUntil4 = false;
                long start$iv$iv$iv$iv = System.nanoTime();
                long spins$iv$iv$iv$iv = 0L;
                while (true) {
                    boolean bl4 = false;
                    if (((Number)BitSliceKt.get(executingSlice, this.state)).intValue() <= ((Number)Lifetime.Companion.getThreadLocalExecuting$rd_core().get((Object)this)).intValue()) break;
                    if (!RLifetimeKt.isAlive(lifetime$iv$iv$iv) || System.nanoTime() - start$iv$iv$iv$iv > duration$iv$iv$iv$iv.toNanos()) {
                        bl2 = false;
                        break block13;
                    }
                    long l = spins$iv$iv$iv$iv;
                    spins$iv$iv$iv$iv = l + 1L;
                    if (l < (long)100) {
                        Thread.yield();
                        continue;
                    }
                    Thread.sleep(spins$iv$iv$iv$iv / (long)100);
                }
                bl2 = true;
            }
            if (!bl2) {
                void $this$log$iv$iv;
                Logger $this$error$iv = LifetimeDefinition.Companion.getLog();
                boolean $i$f$error = false;
                Logger $i$f$spinUntil5 = $this$error$iv;
                LogLevel level$iv$iv = LogLevel.Error;
                $i$f$log = false;
                if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                    LogLevel logLevel = level$iv$iv;
                    void var20_34 = $this$log$iv$iv;
                    boolean bl5 = false;
                    String string = "Can't wait for executeIfAlive for more than " + Lifetime.Companion.getWaitForExecutingInTerminationTimeout() + " ms. Keep termination.";
                    var20_34.log(logLevel, string, null);
                }
            }
            LifetimeDefinition this_$iv = this;
            boolean $i$f$incrementStatusIf = false;
            boolean value$iv$iv = this_$iv != Companion.getEternal$rd_core();
            boolean $i$f$assert = false;
            $i$f$log = false;
            if (_Assertions.ENABLED && !value$iv$iv) {
                boolean $i$a$-assert-LifetimeDefinition$incrementStatusIf$1$iv22 = false;
                String $i$a$-assert-LifetimeDefinition$incrementStatusIf$1$iv22 = "Trying to change eternal lifetime";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-LifetimeDefinition$incrementStatusIf$1$iv22));
            }
            do {
                int it = s$iv = this_$iv.state.get();
                boolean bl6 = false;
                if (!(statusSlice.get(it) == LifetimeStatus.Canceled)) {
                    bl = false;
                    break block14;
                }
                LifetimeStatus nextStatus$iv = LifetimeStatus.values()[((LifetimeStatus)((Object)LifetimeDefinition.statusSlice.get(s$iv))).ordinal() + 1];
                newS$iv = LifetimeDefinition.statusSlice.updated(s$iv, nextStatus$iv);
            } while (!this_$iv.state.compareAndSet(s$iv, newS$iv));
            bl = true;
        }
        if (!bl) {
            return false;
        }
        boolean $i$f$spinUntil6 = false;
        SpinWait.Companion this_$iv$iv = SpinWait.Companion;
        $i$f$spinUntil5 = false;
        long spins$iv$iv = 0L;
        while (true) {
            boolean bl7 = false;
            if (BitSliceKt.get(mutexSlice, this.state) == false) break;
            long l = spins$iv$iv;
            spins$iv$iv = l + 1L;
            if (l < (long)100) {
                Thread.yield();
                continue;
            }
            Thread.sleep(spins$iv$iv / (long)100);
        }
        this.destruct(supportsTerminationUnderExecuting);
        return true;
    }

    public static /* synthetic */ boolean terminate$default(LifetimeDefinition lifetimeDefinition, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return lifetimeDefinition.terminate(bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void destruct(boolean supportsRecursion) {
        boolean bl;
        boolean bl2;
        block23: {
            int newS$iv;
            int s$iv;
            int value$iv = this.getStatus() == LifetimeStatus.Terminating ? 1 : 0;
            boolean $i$f$assert = false;
            bl2 = false;
            if (_Assertions.ENABLED && value$iv == 0) {
                boolean $i$a$-assert-LifetimeDefinition$destruct$22 = false;
                String $i$a$-assert-LifetimeDefinition$destruct$22 = "Bad status for destructuring start: " + (Object)((Object)this.getStatus());
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-LifetimeDefinition$destruct$22));
            }
            value$iv = CollectionsKt.getLastIndex(this.resources);
            $i$f$assert = false;
            while (value$iv >= 0) {
                Object action;
                Object $i$a$-assert-LifetimeDefinition$destruct$22;
                void i;
                Object resource = this.resources.get((int)i);
                Object object = resource;
                if (!TypeIntrinsics.isFunctionOfArity((Object)object, (int)0)) {
                    object = null;
                }
                if ((Function0)object != null) {
                    boolean bl3 = false;
                    boolean bl4 = false;
                    action = $i$a$-assert-LifetimeDefinition$destruct$22;
                    boolean bl5 = false;
                    Logger $this$catch$iv = LifetimeDefinition.Companion.getLog();
                    boolean $i$f$catch = false;
                    Logger logger2 = $this$catch$iv;
                    Object comment$iv$iv = null;
                    boolean $i$f$catch2 = false;
                    try {
                        boolean bl6 = false;
                        action.invoke();
                    }
                    catch (Throwable e$iv$iv) {
                        void $this$catch$iv$iv;
                        CharSequence bl6 = comment$iv$iv;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        String sfx$iv$iv = "";
                        LoggerKt.error((Logger)$this$catch$iv$iv, "Catch" + sfx$iv$iv, e$iv$iv);
                    }
                } else {
                    Logger $this$catch$iv$iv;
                    boolean $i$f$catch;
                    $i$a$-assert-LifetimeDefinition$destruct$22 = resource;
                    if ($i$a$-assert-LifetimeDefinition$destruct$22 instanceof Closeable) {
                        Logger $this$catch$iv = LifetimeDefinition.Companion.getLog();
                        $i$f$catch = false;
                        action = $this$catch$iv;
                        Object comment$iv$iv = null;
                        boolean $i$f$catch3 = false;
                        try {
                            boolean bl9 = false;
                            ((Closeable)resource).close();
                        }
                        catch (Throwable e$iv$iv) {
                            CharSequence bl9 = comment$iv$iv;
                            boolean bl10 = false;
                            boolean $i$f$catch2 = false;
                            String sfx$iv$iv = "";
                            LoggerKt.error($this$catch$iv$iv, "Catch" + sfx$iv$iv, e$iv$iv);
                        }
                    } else if ($i$a$-assert-LifetimeDefinition$destruct$22 instanceof LifetimeDefinition) {
                        boolean bl11;
                        Logger $this$catch$iv = LifetimeDefinition.Companion.getLog();
                        $i$f$catch = false;
                        $this$catch$iv$iv = $this$catch$iv;
                        Object comment$iv$iv = null;
                        boolean $i$f$catch4 = false;
                        try {
                            bl11 = false;
                            ((LifetimeDefinition)resource).terminate(supportsRecursion);
                        }
                        catch (Throwable e$iv$iv) {
                            CharSequence charSequence = comment$iv$iv;
                            bl11 = false;
                            boolean $i$f$catch2 = false;
                            String sfx$iv$iv = "";
                            LoggerKt.error($this$catch$iv$iv, "Catch" + sfx$iv$iv, e$iv$iv);
                        }
                    } else if ($i$a$-assert-LifetimeDefinition$destruct$22 instanceof ClearLifetimeMarker) {
                        ((ClearLifetimeMarker)resource).getParentToClear().clearObsoleteAttachedLifetimes();
                    } else {
                        Logger $this$catch$iv = LifetimeDefinition.Companion.getLog();
                        $i$f$catch = false;
                        $this$catch$iv$iv = $this$catch$iv;
                        Object comment$iv$iv = null;
                        boolean $i$f$catch5 = false;
                        try {
                            boolean bl12 = false;
                            String string = "Unknown termination resource: " + resource;
                            boolean bl13 = false;
                            throw (Throwable)new IllegalStateException(string.toString());
                        }
                        catch (Throwable e$iv$iv) {
                            CharSequence charSequence = comment$iv$iv;
                            boolean bl14 = false;
                            boolean bl15 = false;
                            String sfx$iv$iv = "";
                            LoggerKt.error($this$catch$iv$iv, "Catch" + sfx$iv$iv, e$iv$iv);
                        }
                    }
                }
                this.resources.remove((int)i);
                --i;
            }
            LifetimeDefinition this_$iv = this;
            boolean $i$f$incrementStatusIf = false;
            boolean value$iv$iv = this_$iv != Companion.getEternal$rd_core();
            boolean $i$f$assert2 = false;
            boolean $this$catch$iv = false;
            if (_Assertions.ENABLED && !value$iv$iv) {
                boolean bl16 = false;
                String string = "Trying to change eternal lifetime";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            do {
                int it = s$iv = this_$iv.state.get();
                boolean bl17 = false;
                if (!(statusSlice.get(it) == LifetimeStatus.Terminating)) {
                    bl = false;
                    break block23;
                }
                LifetimeStatus nextStatus$iv = LifetimeStatus.values()[((LifetimeStatus)((Object)LifetimeDefinition.statusSlice.get(s$iv))).ordinal() + 1];
                newS$iv = LifetimeDefinition.statusSlice.updated(s$iv, nextStatus$iv);
            } while (!this_$iv.state.compareAndSet(s$iv, newS$iv));
            bl = true;
        }
        boolean bl18 = bl;
        boolean bl19 = false;
        bl2 = false;
        if (!bl18) {
            boolean bl20 = false;
            String string = "Bad status for destructuring finish: " + (Object)((Object)this.getStatus());
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public boolean onTerminationIfAlive(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return this.tryAdd(action);
    }

    @Override
    public boolean onTerminationIfAlive(@NotNull Closeable closeable) {
        Intrinsics.checkNotNullParameter((Object)closeable, (String)"closeable");
        return this.tryAdd(closeable);
    }

    @Override
    public void attach$rd_core(@NotNull LifetimeDefinition child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        boolean bl = !RLifetimeKt.isEternal(child);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Can't attach eternal lifetime";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (child.tryAdd(new ClearLifetimeMarker(this)) && !this.tryAdd(child)) {
            LifetimeDefinition.terminate$default(child, false, 1, null);
        }
    }

    @Override
    @Nullable
    public <T> T bracket(@NotNull Function0<? extends T> opening, @NotNull Function0<Unit> terminationAction) {
        Intrinsics.checkNotNullParameter(opening, (String)"opening");
        Intrinsics.checkNotNullParameter(terminationAction, (String)"terminationAction");
        return this.executeIfAlive((Function0)new Function0<T>(this, opening, terminationAction){
            final /* synthetic */ LifetimeDefinition this$0;
            final /* synthetic */ Function0 $opening;
            final /* synthetic */ Function0 $terminationAction;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final T invoke() {
                void var1_1;
                Object res = this.$opening.invoke();
                if (!LifetimeDefinition.access$tryAdd(this.this$0, this.$terminationAction)) {
                    this.$terminationAction.invoke();
                }
                return var1_1;
            }
            {
                this.this$0 = lifetimeDefinition;
                this.$opening = function0;
                this.$terminationAction = function02;
                super(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearObsoleteAttachedLifetimes() {
        block5: {
            int s$iv;
            Function0 $this$underMutexIf$iv = (Function0)new Function0<Unit>(this){
                final /* synthetic */ LifetimeDefinition this$0;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    int n = CollectionsKt.getLastIndex((List)LifetimeDefinition.access$getResources$p(this.this$0));
                    boolean bl = false;
                    while (n >= 0) {
                        LifetimeDefinition lifetimeDefinition;
                        void i;
                        E e = LifetimeDefinition.access$getResources$p(this.this$0).get((int)i);
                        if (!(e instanceof LifetimeDefinition)) {
                            e = null;
                        }
                        if ((LifetimeDefinition)e == null) break;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        LifetimeDefinition it = lifetimeDefinition;
                        boolean bl4 = false;
                        if (!(it.getStatus().compareTo((Enum)LifetimeStatus.Terminating) >= 0)) break;
                        LifetimeDefinition.access$getResources$p(this.this$0).remove((int)i);
                        --i;
                    }
                }
                {
                    this.this$0 = lifetimeDefinition;
                    super(0);
                }
            };
            LifetimeDefinition this_$iv = this;
            boolean $i$f$underMutexIf = false;
            do {
                int state = s$iv = this_$iv.state.get();
                boolean bl = false;
                if (!(statusSlice.get(state) == LifetimeStatus.Alive)) break block5;
            } while (((Boolean)LifetimeDefinition.mutexSlice.get(s$iv)).booleanValue() || !this_$iv.state.compareAndSet(s$iv, LifetimeDefinition.mutexSlice.updated(s$iv, true)));
            try {
                Object object = $this$underMutexIf$iv.invoke();
            }
            finally {
                int s$iv2;
                do {
                    s$iv2 = this_$iv.state.get();
                    PlatformDependentKt.assert((Boolean)LifetimeDefinition.mutexSlice.get(s$iv2));
                } while (!this_$iv.state.compareAndSet(s$iv2, LifetimeDefinition.mutexSlice.updated(s$iv2, false)));
            }
        }
    }

    public LifetimeDefinition() {
        super(null);
        boolean bl = false;
        this.resources = new ArrayList();
    }

    static {
        Companion = new Companion(null);
        eternal = new LifetimeDefinition();
        log$delegate = LazyKt.lazy((Function0)Companion.log.2.INSTANCE);
        executingSlice = BitSlice.Companion.int$default(BitSlice.Companion, 20, null, 2, null);
        BitSlice.Companion companion = BitSlice.Companion;
        BitSlice prev$iv = executingSlice;
        boolean $i$f$enum = false;
        Enum[] values$iv = LifetimeStatus.values();
        boolean bl = values$iv.length >= 2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Bit slice for enums with " + values$iv + " values is meaningless";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        statusSlice = new BitSlice.TypedBitSlice<LifetimeStatus>(values$iv, prev$iv, BitSliceKt.nextSliceLow(prev$iv), BitHacksKt.log2ceil(values$iv.length)){
            final /* synthetic */ Enum[] $values;
            final /* synthetic */ BitSlice $prev;
            {
                this.$values = $captured_local_variable$0;
                this.$prev = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }

            @NotNull
            public LifetimeStatus get(int host) {
                return this.$values[this.getRaw(host)];
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int updated(int host, @NotNull Enum value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                return this.updatedRaw(host, value2.ordinal());
            }
        };
        mutexSlice = BitSlice.Companion.bool(statusSlice);
        Terminated = new LifetimeDefinition();
        LifetimeDefinition.terminate$default(Terminated, false, 1, null);
    }

    public static final /* synthetic */ void access$setState$p(LifetimeDefinition $this, AtomicInteger atomicInteger) {
        $this.state = atomicInteger;
    }

    public static final /* synthetic */ List access$getResources$p(LifetimeDefinition $this) {
        return $this.resources;
    }

    public static final /* synthetic */ void access$setResources$p(LifetimeDefinition $this, List list) {
        $this.resources = list;
    }

    public static final /* synthetic */ boolean access$markCanceledRecursively(LifetimeDefinition $this) {
        return $this.markCanceledRecursively();
    }

    public static final /* synthetic */ boolean access$tryAdd(LifetimeDefinition $this, Object action) {
        return $this.tryAdd(action);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition$Companion;", "", "()V", "Terminated", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getTerminated", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "eternal", "getEternal$rd_core", "executingSlice", "Lcom/jetbrains/rd/util/BitSlice$TypedBitSlice;", "", "log", "Lcom/jetbrains/rd/util/Logger;", "getLog", "()Lcom/jetbrains/rd/util/Logger;", "log$delegate", "Lkotlin/Lazy;", "mutexSlice", "", "statusSlice", "Lcom/jetbrains/rd/util/lifetime/LifetimeStatus;", "rd-core"})
    public static final class Companion {
        @NotNull
        public final LifetimeDefinition getEternal$rd_core() {
            return eternal;
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final LifetimeDefinition getTerminated() {
            return Terminated;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

