/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.PackageChunk;
import com.google.devrel.gmscore.tools.apk.arsc.StringPoolChunk;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public final class TypeSpecChunk
extends Chunk {
    private final int id;
    private final int[] resources;

    protected TypeSpecChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.id = UnsignedBytes.toInt((byte)buffer.get());
        buffer.position(buffer.position() + 3);
        int resourceCount = buffer.getInt();
        this.resources = new int[resourceCount];
        for (int i = 0; i < resourceCount; ++i) {
            this.resources[i] = buffer.getInt();
        }
    }

    public int getId() {
        return this.id;
    }

    public int getResourceCount() {
        return this.resources.length;
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.TABLE_TYPE_SPEC;
    }

    public String getTypeName() {
        PackageChunk packageChunk = this.getPackageChunk();
        Preconditions.checkNotNull((Object)packageChunk, (String)"%s has no parent package.", this.getClass());
        StringPoolChunk typePool = packageChunk.getTypeStringPool();
        Preconditions.checkNotNull((Object)typePool, (String)"%s's parent package has no type pool.", this.getClass());
        return typePool.getString(this.getId() - 1);
    }

    @Nullable
    private PackageChunk getPackageChunk() {
        Chunk chunk;
        for (chunk = this.getParent(); chunk != null && !(chunk instanceof PackageChunk); chunk = chunk.getParent()) {
        }
        return chunk != null ? (PackageChunk)chunk : null;
    }

    @Override
    protected void writeHeader(ByteBuffer output) {
        super.writeHeader(output);
        output.putInt(this.id);
        output.putInt(this.resources.length);
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        for (int resource : this.resources) {
            output.writeInt(resource);
        }
    }
}

