/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.formatting;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.formatting.PropertyBlock;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PropertiesRootBlock
extends AbstractBlock {
    private final CodeStyleSettings mySettings;
    private final Alignment mySeparatorAlignment;

    PropertiesRootBlock(@NotNull ASTNode node, CodeStyleSettings settings) {
        if (node == null) {
            PropertiesRootBlock.$$$reportNull$$$0(0);
        }
        super(node, null, Alignment.createAlignment());
        this.mySettings = settings;
        this.mySeparatorAlignment = Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.LEFT);
    }

    protected List<Block> buildChildren() {
        ArrayList<Block> result = new ArrayList<Block>();
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!(child instanceof PsiWhiteSpace)) {
                if (child.getElementType() == PropertiesElementTypes.PROPERTIES_LIST) {
                    for (ASTNode propertyNode = child.getFirstChildNode(); propertyNode != null; propertyNode = propertyNode.getTreeNext()) {
                        if (propertyNode.getElementType() == PropertiesElementTypes.PROPERTY) {
                            this.collectPropertyBlock(propertyNode, result);
                            continue;
                        }
                        if (!PropertiesTokenTypes.END_OF_LINE_COMMENT.equals(propertyNode.getElementType()) && !PropertiesTokenTypes.BAD_CHARACTER.equals(propertyNode.getElementType())) continue;
                        result.add((Block)new PropertyBlock(propertyNode, null));
                    }
                } else if (PropertiesTokenTypes.BAD_CHARACTER.equals(child.getElementType())) {
                    result.add((Block)new PropertyBlock(child, null));
                }
            }
            if (!PropertiesTokenTypes.END_OF_LINE_COMMENT.equals(child.getElementType())) continue;
            result.add((Block)new PropertyBlock(child, null));
        }
        return result;
    }

    @Nullable
    protected Indent getChildIndent() {
        return Indent.getNoneIndent();
    }

    private void collectPropertyBlock(ASTNode propertyNode, List<? super Block> collector) {
        ASTNode[] nonWhiteSpaces;
        for (ASTNode node : nonWhiteSpaces = propertyNode.getChildren(TokenSet.create((IElementType[])new IElementType[]{PropertiesTokenTypes.KEY_CHARACTERS, PropertiesTokenTypes.KEY_VALUE_SEPARATOR, PropertiesTokenTypes.VALUE_CHARACTERS}))) {
            if (node instanceof PropertyKeyImpl) {
                collector.add((Block)new PropertyBlock(node, null));
            }
            if (PropertiesTokenTypes.KEY_VALUE_SEPARATOR.equals(node.getElementType())) {
                collector.add((Block)new PropertyBlock(node, this.mySettings.getCommonSettings((Language)PropertiesLanguage.INSTANCE).ALIGN_GROUP_FIELD_DECLARATIONS ? this.mySeparatorAlignment : null));
            }
            if (!(node instanceof PropertyValueImpl)) continue;
            collector.add((Block)new PropertyBlock(node, null));
        }
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            PropertiesRootBlock.$$$reportNull$$$0(1);
        }
        if (child1 == null) {
            return null;
        }
        return ((PropertiesCodeStyleSettings)this.mySettings.getCustomSettings(PropertiesCodeStyleSettings.class)).SPACES_AROUND_KEY_VALUE_DELIMITER && (PropertiesRootBlock.isSeparator(child1) || PropertiesRootBlock.isSeparator(child2)) || PropertiesRootBlock.isKeyValue(child1, child2) ? Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0) : Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)(((PropertiesCodeStyleSettings)this.mySettings.getCustomSettings(PropertiesCodeStyleSettings.class)).KEEP_BLANK_LINES ? 999 : 0));
    }

    private static boolean isKeyValue(Block maybeKey, Block maybeValue) {
        if (!(maybeKey instanceof PropertyBlock) || !PropertiesTokenTypes.KEY_CHARACTERS.equals(((PropertyBlock)maybeKey).getNode().getElementType())) {
            return false;
        }
        return maybeValue instanceof PropertyBlock && PropertiesTokenTypes.VALUE_CHARACTERS.equals(((PropertyBlock)maybeValue).getNode().getElementType());
    }

    private static boolean isSeparator(Block block) {
        return block instanceof PropertyBlock && PropertiesTokenTypes.KEY_VALUE_SEPARATOR.equals(((PropertyBlock)block).getNode().getElementType());
    }

    public boolean isLeaf() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/properties/formatting/PropertiesRootBlock";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

