/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.migration;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteCodeFix;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteCodeProblemReporter;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteCoroutinesDelegateQuickFix;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteCoroutinesUsageInWholeProjectFix;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteExperimentalCoroutinesInspectionKt;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteExtensionFunctionUsageReporter;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteExtensionFunctionUsageReporter;", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCodeProblemReporter;", "textMarker", "", "oldFqName", "newFqName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "fix", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteExtensionFunctionUsageReporter$Companion$ImportExtensionFunctionFix;", "getNewFqName", "()Ljava/lang/String;", "getOldFqName", "getTextMarker", "report", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "Companion", "kotlin.idea"})
final class ObsoleteExtensionFunctionUsageReporter
implements ObsoleteCodeProblemReporter {
    private final Companion.ImportExtensionFunctionFix fix;
    @NotNull
    private final String textMarker;
    @NotNull
    private final String oldFqName;
    @NotNull
    private final String newFqName;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean report(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull KtSimpleNameExpression simpleNameExpression) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)simpleNameExpression, (String)"simpleNameExpression");
        if (Intrinsics.areEqual((Object)simpleNameExpression.getText(), (Object)this.textMarker) ^ true) {
            return false;
        }
        if (!ObsoleteExperimentalCoroutinesInspectionKt.access$isTopLevelCallForReplace(simpleNameExpression, this.oldFqName, this.newFqName)) {
            return false;
        }
        LocalQuickFix[] localQuickFixArray = ObsoleteExperimentalCoroutinesInspectionKt.fixesWithWholeProject(isOnTheFly, new ObsoleteCoroutinesDelegateQuickFix(this.fix), ObsoleteCoroutinesUsageInWholeProjectFix.INSTANCE);
        holder.registerProblem((PsiElement)simpleNameExpression, KotlinBundle.message("methods.are.absent.in.coroutines.class.since.1.3", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        return true;
    }

    @NotNull
    public final String getTextMarker() {
        return this.textMarker;
    }

    @NotNull
    public final String getOldFqName() {
        return this.oldFqName;
    }

    @NotNull
    public final String getNewFqName() {
        return this.newFqName;
    }

    public ObsoleteExtensionFunctionUsageReporter(@NotNull String textMarker, @NotNull String oldFqName, @NotNull String newFqName) {
        Intrinsics.checkNotNullParameter((Object)textMarker, (String)"textMarker");
        Intrinsics.checkNotNullParameter((Object)oldFqName, (String)"oldFqName");
        Intrinsics.checkNotNullParameter((Object)newFqName, (String)"newFqName");
        this.textMarker = textMarker;
        this.oldFqName = oldFqName;
        this.newFqName = newFqName;
        this.fix = new Companion.ImportExtensionFunctionFix(this.newFqName);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteExtensionFunctionUsageReporter$Companion;", "", "()V", "ImportExtensionFunctionFix", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteExtensionFunctionUsageReporter$Companion$ImportExtensionFunctionFix;", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCodeFix;", "fqName", "", "(Ljava/lang/String;)V", "getFqName", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
        private static final class ImportExtensionFunctionFix
        implements ObsoleteCodeFix {
            @NotNull
            private final String fqName;

            /*
             * Unable to fully structure code
             */
            @Override
            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    element = descriptor.getPsiElement();
                    if (!(element instanceof KtSimpleNameExpression)) {
                        return;
                    }
                    v0 = KotlinTopLevelFunctionFqnNameIndex.getInstance().get(this.fqName, ((KtSimpleNameExpression)element).getProject(), GlobalSearchScope.allScope((Project)((KtSimpleNameExpression)element).getProject()));
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"KotlinTopLevelFunctionFq\u2026llScope(element.project))");
                    var5_4 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)v0), (Function1)applyFix.importFun.1.INSTANCE);
                    var6_5 = false;
                    var7_6 = var5_4;
                    var8_7 = false;
                    for (E var10_9 : var7_6) {
                        it = (FunctionDescriptor)var10_9;
                        $i$a$-find-ObsoleteExtensionFunctionUsageReporter$Companion$ImportExtensionFunctionFix$applyFix$importFun$2 = false;
                        if (it == null) ** GOTO lbl-1000
                        v1 = ImportsUtils.getImportableFqName((DeclarationDescriptor)((DeclarationDescriptor)it));
                        if (Intrinsics.areEqual((Object)(v1 != null ? v1.asString() : null), (Object)this.fqName)) {
                            v2 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = false;
                        }
                        if (!v2) continue;
                        v3 = var10_9;
                        break block5;
                    }
                    v3 = null;
                }
                v4 = v3;
                if (v4 == null) {
                    return;
                }
                importFun = v4;
                v5 = ((KtSimpleNameExpression)element).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"element.project");
                v6 = ImportInsertHelper.Companion.getInstance(v5);
                v7 = ((KtSimpleNameExpression)element).getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"element.containingKtFile");
                v6.importDescriptor(v7, (DeclarationDescriptor)importFun, false);
            }

            @NotNull
            public final String getFqName() {
                return this.fqName;
            }

            public ImportExtensionFunctionFix(@NotNull String fqName) {
                Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
                this.fqName = fqName;
            }
        }
    }
}

