/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.AbstractChopListIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B/\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AbstractJoinListIntention;", "TList", "Lorg/jetbrains/kotlin/psi/KtElement;", "TElement", "Lorg/jetbrains/kotlin/idea/intentions/AbstractChopListIntention;", "listClass", "Ljava/lang/Class;", "elementClass", "textGetter", "Lkotlin/Function0;", "", "(Ljava/lang/Class;Ljava/lang/Class;Lkotlin/jvm/functions/Function0;)V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lcom/intellij/openapi/editor/Editor;)V", "isApplicableTo", "", "(Lorg/jetbrains/kotlin/psi/KtElement;)Z", "kotlin.idea"})
public abstract class AbstractJoinListIntention<TList extends KtElement, TElement extends KtElement>
extends AbstractChopListIntention<TList, TElement> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull TList element3) {
        boolean bl;
        Object element$iv;
        PsiElement it;
        Iterator iterator;
        Intrinsics.checkNotNullParameter(element3, (String)"element");
        List elements2 = this.elements(element3);
        if (elements2.isEmpty()) {
            return false;
        }
        if (!this.hasLineBreakBefore((KtElement)CollectionsKt.first(elements2))) {
            Iterable $this$any$iv = elements2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                element$iv = iterator.next();
                it = (KtElement)element$iv;
                boolean bl2 = false;
            } while (!this.hasLineBreakAfter(it));
            boolean bl3 = true;
            if (!bl3) return false;
        }
        Sequence $this$none$iv = (Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)element3));
        boolean $i$f$none = false;
        iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            element$iv = iterator.next();
            it = (PsiElement)element$iv;
            boolean bl4 = false;
            if (it instanceof PsiComment) {
                ASTNode aSTNode = ((PsiComment)it).getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it.node");
                if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtTokens.EOL_COMMENT)) {
                    return false;
                }
            }
            bl = false;
        } while (!bl);
        return false;
    }

    @Override
    public void applyTo(@NotNull TList element3, @Nullable Editor editor2) {
        block4: {
            Object it;
            Intrinsics.checkNotNullParameter(element3, (String)"element");
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getDocument()) == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"editor?.document ?: return");
            Editor document = editor3;
            List elements2 = this.elements(element3);
            SmartPsiElementPointer pointer = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)element3));
            PsiWhiteSpace psiWhiteSpace = this.nextBreak((KtElement)CollectionsKt.last(elements2));
            if (psiWhiteSpace != null) {
                PsiWhiteSpace psiWhiteSpace2 = psiWhiteSpace;
                boolean bl = false;
                boolean bl2 = false;
                it = psiWhiteSpace2;
                boolean bl3 = false;
                document.deleteString(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)it)));
            }
            Iterable $this$forEach$iv = CollectionsKt.asReversed((List)CollectionsKt.dropLast(elements2, (int)1));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiWhiteSpace psiWhiteSpace3;
                KtElement tElement = (KtElement)element$iv;
                boolean bl = false;
                if (this.nextBreak(tElement) == null) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                PsiWhiteSpace it2 = psiWhiteSpace3;
                boolean bl6 = false;
                document.replaceString(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it2)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)it2)), (CharSequence)" ");
            }
            PsiWhiteSpace psiWhiteSpace4 = this.prevBreak((KtElement)CollectionsKt.first(elements2));
            if (psiWhiteSpace4 != null) {
                $this$forEach$iv = psiWhiteSpace4;
                $i$f$forEach = false;
                boolean bl = false;
                it = $this$forEach$iv;
                boolean bl7 = false;
                document.deleteString(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)it)));
            }
            Project project2 = element3.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
            Project project3 = project2;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project3);
            documentManager.commitDocument((Document)document);
            KtElement ktElement = (KtElement)pointer.getElement();
            if (ktElement == null) break block4;
            KtElement ktElement2 = ktElement;
            boolean bl = false;
            boolean bl8 = false;
            KtElement it3 = ktElement2;
            boolean bl9 = false;
            CodeStyleManager.getInstance((Project)project3).reformat((PsiElement)it3);
        }
    }

    public AbstractJoinListIntention(@NotNull Class<TList> listClass, @NotNull Class<TElement> elementClass, @NotNull Function0<String> textGetter) {
        Intrinsics.checkNotNullParameter(listClass, (String)"listClass");
        Intrinsics.checkNotNullParameter(elementClass, (String)"elementClass");
        Intrinsics.checkNotNullParameter(textGetter, (String)"textGetter");
        super(listClass, elementClass, textGetter);
    }
}

