/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import com.google.gson.Gson;
import com.google.protobuf.Message;
import com.intellij.compiler.notNullVerification.NotNullVerifyingInstrumenter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.thoughtworks.qdox.JavaProjectBuilder;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.NetUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.jps.builders.impl.java.EclipseCompilerTool;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.builders.java.JavaSourceTransformer;
import org.jetbrains.jps.cmdline.BuildMain;
import org.jetbrains.jps.javac.ExternalJavacProcess;
import org.jetbrains.jps.javac.ast.JavacReferenceCollector;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.impl.JpsModelImpl;
import org.jetbrains.jps.model.serialization.JpsProjectLoader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public final class ClasspathBootstrap {
    private static final Logger LOG = Logger.getInstance(ClasspathBootstrap.class);
    private static final Class<?>[] COMMON_REQUIRED_CLASSES = new Class[]{NetUtil.class, EventLoopGroup.class, AddressResolverGroup.class, ByteBufAllocator.class, ProtobufDecoder.class};
    private static final String DEFAULT_MAVEN_REPOSITORY_PATH = ".m2/repository";
    private static final String PROTOBUF_JAVA6_VERSION = "3.5.1";
    private static final String PROTOBUF_JAVA6_JAR_NAME = "protobuf-java-3.5.1.jar";
    private static final String EXTERNAL_JAVAC_MODULE_NAME = "intellij.platform.jps.build.javac.rt.rpc";
    private static final String EXTERNAL_JAVAC_JAR_NAME = "jps-javac-rt-rpc.jar";

    private ClasspathBootstrap() {
    }

    public static List<String> getBuildProcessApplicationClasspath() {
        HashSet<String> cp = new HashSet<String>();
        cp.add(ClasspathBootstrap.getResourcePath(BuildMain.class));
        cp.add(ClasspathBootstrap.getResourcePath(ExternalJavacProcess.class));
        cp.add(ClasspathBootstrap.getResourcePath(JavacReferenceCollector.class));
        cp.addAll(PathManager.getUtilClassPath());
        for (Class<?> aClass : COMMON_REQUIRED_CLASSES) {
            cp.add(ClasspathBootstrap.getResourcePath(aClass));
        }
        cp.add(ClasspathBootstrap.getResourcePath(Message.class));
        cp.add(ClasspathBootstrap.getResourcePath(ClassWriter.class));
        cp.add(ClasspathBootstrap.getResourcePath(ClassVisitor.class));
        cp.add(ClasspathBootstrap.getResourcePath(JpsModel.class));
        cp.add(ClasspathBootstrap.getResourcePath(JpsModelImpl.class));
        cp.add(ClasspathBootstrap.getResourcePath(JpsProjectLoader.class));
        cp.add(ClasspathBootstrap.getResourcePath(AlienFormFileException.class));
        cp.add(ClasspathBootstrap.getResourcePath(GridConstraints.class));
        cp.add(ClasspathBootstrap.getResourcePath(CellConstraints.class));
        cp.addAll(ClasspathBootstrap.getInstrumentationUtilRoots());
        cp.add(ClasspathBootstrap.getResourcePath(IXMLBuilder.class));
        cp.add(ClasspathBootstrap.getResourcePath(JavaProjectBuilder.class));
        cp.add(ClasspathBootstrap.getResourcePath(Gson.class));
        cp.addAll(ContainerUtil.map((Collection)ArtifactRepositoryManager.getClassesFromDependencies(), ClasspathBootstrap::getResourcePath));
        try {
            Class<?> cmdLineWrapper = Class.forName("com.intellij.rt.execution.CommandLineWrapper");
            cp.add(ClasspathBootstrap.getResourcePath(cmdLineWrapper));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new ArrayList<String>(cp);
    }

    public static void appendJavaCompilerClasspath(Collection<? super String> cp, boolean includeEcj) {
        File file;
        if (includeEcj && (file = EclipseCompilerTool.findEcjJarFile()) != null) {
            cp.add(file.getAbsolutePath());
        }
    }

    public static List<File> getExternalJavacProcessClasspath(String sdkHome, JavaCompilingTool compilingTool) {
        LinkedHashSet<File> cp = new LinkedHashSet<File>();
        cp.add(ClasspathBootstrap.getResourceFile(ExternalJavacProcess.class));
        cp.add(ClasspathBootstrap.getResourceFile(JavacReferenceCollector.class));
        for (String path : PathManager.getUtilClassPath()) {
            cp.add(new File(path));
        }
        for (Class<?> aClass : COMMON_REQUIRED_CLASSES) {
            cp.add(ClasspathBootstrap.getResourceFile(aClass));
        }
        ClasspathBootstrap.addExternalJavacRpcClasspath(cp);
        try {
            Class<?> cmdLineWrapper = Class.forName("com.intellij.rt.execution.CommandLineWrapper");
            cp.add(ClasspathBootstrap.getResourceFile(cmdLineWrapper));
        }
        catch (Throwable th) {
            LOG.info(th);
        }
        try {
            String localJavaHome = FileUtil.toSystemIndependentName((String)SystemProperties.getJavaHome());
            File candidate = new File(sdkHome, "lib/tools.jar");
            if (candidate.exists()) {
                cp.add(candidate);
            } else {
                JavaCompiler systemCompiler = ToolProvider.getSystemJavaCompiler();
                Class<?> compilerClass = systemCompiler != null ? systemCompiler.getClass() : Class.forName("com.sun.tools.javac.api.JavacTool", false, ClasspathBootstrap.class.getClassLoader());
                String localJarPath = FileUtil.toSystemIndependentName((String)ClasspathBootstrap.getResourceFile(compilerClass).getPath());
                String relPath = FileUtil.getRelativePath((String)localJavaHome, (String)localJarPath, (char)'/');
                if (relPath != null) {
                    if (relPath.contains("..")) {
                        relPath = FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)new File(localJavaHome).getParent()), (String)localJarPath, (char)'/');
                    }
                    if (relPath != null) {
                        File targetFile = new File(sdkHome, relPath);
                        cp.add(targetFile);
                    }
                }
            }
        }
        catch (Throwable th) {
            LOG.info(th);
        }
        cp.addAll(compilingTool.getAdditionalClasspath());
        for (JavaSourceTransformer t : JavaSourceTransformer.getTransformers()) {
            cp.add(ClasspathBootstrap.getResourceFile(t.getClass()));
        }
        return new ArrayList<File>(cp);
    }

    private static void addExternalJavacRpcClasspath(@NotNull Collection<File> cp) {
        Path rootPath;
        if (cp == null) {
            ClasspathBootstrap.$$$reportNull$$$0(0);
        }
        if (Files.isRegularFile(rootPath = Paths.get(ClasspathBootstrap.getResourcePath(ExternalJavacProcess.class), new String[0]), new LinkOption[0])) {
            Path rtDirPath = rootPath.resolveSibling("rt");
            cp.add(rtDirPath.resolve(EXTERNAL_JAVAC_JAR_NAME).toFile());
            cp.add(rtDirPath.resolve(PROTOBUF_JAVA6_JAR_NAME).toFile());
        } else {
            cp.add(rootPath.resolveSibling(EXTERNAL_JAVAC_MODULE_NAME).toFile());
            File localRepositoryDir = ClasspathBootstrap.getMavenLocalRepositoryDir();
            File protobufJava6File = new File(FileUtil.join((String[])new String[]{localRepositoryDir.getAbsolutePath(), "com", "google", "protobuf", "protobuf-java", PROTOBUF_JAVA6_VERSION, PROTOBUF_JAVA6_JAR_NAME}));
            cp.add(protobufJava6File);
        }
    }

    @NotNull
    private static File getMavenLocalRepositoryDir() {
        String userHome = System.getProperty("user.home", null);
        return userHome != null ? new File(userHome, DEFAULT_MAVEN_REPOSITORY_PATH) : new File(DEFAULT_MAVEN_REPOSITORY_PATH);
    }

    public static String getResourcePath(Class<?> aClass) {
        return PathManager.getResourceRoot(aClass, (String)("/" + aClass.getName().replace('.', '/') + ".class"));
    }

    public static File getResourceFile(Class<?> aClass) {
        return new File(ClasspathBootstrap.getResourcePath(aClass));
    }

    private static List<String> getInstrumentationUtilRoots() {
        String instrumentationUtilPath = ClasspathBootstrap.getResourcePath(NotNullVerifyingInstrumenter.class);
        File instrumentationUtil = new File(instrumentationUtilPath);
        if (instrumentationUtil.isDirectory()) {
            return Arrays.asList(instrumentationUtilPath, new File(instrumentationUtil.getParentFile(), "intellij.java.compiler.instrumentationUtil.java8").getAbsolutePath());
        }
        return Collections.singletonList(instrumentationUtilPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cp", "org/jetbrains/jps/cmdline/ClasspathBootstrap", "addExternalJavacRpcClasspath"));
    }
}

