/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.psi;

import com.intellij.copyright.CopyrightManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.options.LanguageOptions;
import com.maddyhome.idea.copyright.pattern.EntityUtil;
import com.maddyhome.idea.copyright.pattern.VelocityHelper;
import com.maddyhome.idea.copyright.psi.UpdateCopyright;
import com.maddyhome.idea.copyright.util.FileTypeUtil;

public abstract class AbstractUpdateCopyright
implements UpdateCopyright {
    private String commentText = null;
    private final Project project;
    private final Module module;
    private final VirtualFile root;
    private final CopyrightProfile myCopyrightProfile;
    private final PsiManager manager;

    protected AbstractUpdateCopyright(Project project, Module module, VirtualFile root, CopyrightProfile copyrightProfile) {
        this.project = project;
        this.module = module;
        this.root = root;
        this.myCopyrightProfile = copyrightProfile;
        this.manager = PsiManager.getInstance((Project)project);
    }

    protected String getCommentText(String prefix, String suffix) {
        if (this.commentText == null) {
            FileType ftype = this.root.getFileType();
            LanguageOptions opts = CopyrightManager.getInstance(this.project).getOptions().getMergedOptions(ftype.getName());
            String base = EntityUtil.decode(this.myCopyrightProfile.getNotice());
            if (base.isEmpty()) {
                this.commentText = "";
            } else {
                String expanded = VelocityHelper.evaluate(this.manager.findFile(this.root), this.project, this.module, base);
                String cmt = FileTypeUtil.buildComment(this.root.getFileType(), expanded, opts);
                this.commentText = StringUtil.convertLineSeparators((String)(prefix + cmt + suffix));
            }
        }
        return this.commentText;
    }

    @Override
    public VirtualFile getRoot() {
        return this.root;
    }

    public PsiManager getManager() {
        return this.manager;
    }

    protected void resetCommentText() {
        this.commentText = null;
    }

    protected static int countNewline(String text) {
        int cnt = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++cnt;
        }
        return cnt;
    }
}

