/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.analyzers.AnalyzersUtilKt;
import com.android.build.attribution.data.PluginContainer;
import com.android.build.attribution.data.PluginData;
import com.android.build.attribution.data.TaskContainer;
import com.android.build.attribution.data.TaskData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.tooling.events.PluginIdentifier;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0010H\u0004J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u0010H\u0004J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/build/attribution/analyzers/BaseAnalyzer;", "", "taskContainer", "Lcom/android/build/attribution/data/TaskContainer;", "pluginContainer", "Lcom/android/build/attribution/data/PluginContainer;", "(Lcom/android/build/attribution/data/TaskContainer;Lcom/android/build/attribution/data/PluginContainer;)V", "applyWhitelistedTasksFilter", "", "task", "Lcom/android/build/attribution/data/TaskData;", "getPlugin", "Lcom/android/build/attribution/data/PluginData;", "pluginType", "Lcom/android/build/attribution/data/PluginData$PluginType;", "displayName", "", "projectPath", "pluginIdentifier", "Lorg/gradle/tooling/events/PluginIdentifier;", "getTask", "taskPath", "event", "Lorg/gradle/tooling/events/task/TaskFinishEvent;", "onBuildStart", "", "intellij.android.build-attribution"})
public abstract class BaseAnalyzer {
    private final TaskContainer taskContainer;
    private final PluginContainer pluginContainer;

    public void onBuildStart() {
        this.taskContainer.clear();
        this.pluginContainer.clear();
    }

    @NotNull
    protected final PluginData getPlugin(@NotNull PluginData.PluginType pluginType, @NotNull String displayName, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)((Object)pluginType), (String)"pluginType");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        if (pluginType == PluginData.PluginType.SCRIPT) {
            return this.pluginContainer.getPlugin(pluginType, projectPath + ':' + displayName);
        }
        return this.pluginContainer.getPlugin(pluginType, displayName);
    }

    @NotNull
    protected final PluginData getPlugin(@NotNull PluginIdentifier pluginIdentifier, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)pluginIdentifier, (String)"pluginIdentifier");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return this.pluginContainer.getPlugin(pluginIdentifier, projectPath);
    }

    @Nullable
    protected final TaskData getTask(@NotNull String taskPath) {
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        return this.taskContainer.getTask(taskPath);
    }

    @NotNull
    protected final TaskData getTask(@NotNull TaskFinishEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.taskContainer.getTask(event, this.pluginContainer);
    }

    protected final boolean applyWhitelistedTasksFilter(@NotNull TaskData task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        return !AnalyzersUtilKt.isAndroidPlugin(task2.getOriginPlugin()) && !AnalyzersUtilKt.isGradlePlugin(task2.getOriginPlugin()) && (!Intrinsics.areEqual((Object)task2.getTaskName(), (Object)"clean") || !Intrinsics.areEqual((Object)task2.getOriginPlugin().getDisplayName(), (Object)LifecycleBasePlugin.class.getCanonicalName()));
    }

    public BaseAnalyzer(@NotNull TaskContainer taskContainer, @NotNull PluginContainer pluginContainer) {
        Intrinsics.checkNotNullParameter((Object)taskContainer, (String)"taskContainer");
        Intrinsics.checkNotNullParameter((Object)pluginContainer, (String)"pluginContainer");
        this.taskContainer = taskContainer;
        this.pluginContainer = pluginContainer;
    }
}

