/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.BuildAttributionWarningsFilter;
import com.android.build.attribution.analyzers.AlwaysRunTasksAnalyzer;
import com.android.build.attribution.analyzers.AnnotationProcessorsAnalyzer;
import com.android.build.attribution.analyzers.BuildAttributionReportAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalysisResult;
import com.android.build.attribution.analyzers.BuildEventsAnalyzer;
import com.android.build.attribution.analyzers.CriticalPathAnalyzer;
import com.android.build.attribution.analyzers.NoncacheableTasksAnalyzer;
import com.android.build.attribution.analyzers.ProjectConfigurationAnalyzer;
import com.android.build.attribution.analyzers.TasksConfigurationIssuesAnalyzer;
import com.android.build.attribution.data.AlwaysRunTaskData;
import com.android.build.attribution.data.AnnotationProcessorData;
import com.android.build.attribution.data.PluginBuildData;
import com.android.build.attribution.data.PluginConfigurationData;
import com.android.build.attribution.data.PluginContainer;
import com.android.build.attribution.data.PluginData;
import com.android.build.attribution.data.ProjectConfigurationData;
import com.android.build.attribution.data.TaskContainer;
import com.android.build.attribution.data.TaskData;
import com.android.build.attribution.data.TasksSharingOutputData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0016J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0016H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\u0016H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0016H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0016H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020!0\u0016H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0016H\u0016J\b\u0010+\u001a\u00020\u001fH\u0016J\b\u0010,\u001a\u00020'H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersProxy;", "Lcom/android/build/attribution/analyzers/BuildEventsAnalysisResult;", "warningsFilter", "Lcom/android/build/attribution/BuildAttributionWarningsFilter;", "taskContainer", "Lcom/android/build/attribution/data/TaskContainer;", "pluginContainer", "Lcom/android/build/attribution/data/PluginContainer;", "(Lcom/android/build/attribution/BuildAttributionWarningsFilter;Lcom/android/build/attribution/data/TaskContainer;Lcom/android/build/attribution/data/PluginContainer;)V", "alwaysRunTasksAnalyzer", "Lcom/android/build/attribution/analyzers/AlwaysRunTasksAnalyzer;", "annotationProcessorsAnalyzer", "Lcom/android/build/attribution/analyzers/AnnotationProcessorsAnalyzer;", "criticalPathAnalyzer", "Lcom/android/build/attribution/analyzers/CriticalPathAnalyzer;", "noncacheableTasksAnalyzer", "Lcom/android/build/attribution/analyzers/NoncacheableTasksAnalyzer;", "projectConfigurationAnalyzer", "Lcom/android/build/attribution/analyzers/ProjectConfigurationAnalyzer;", "tasksConfigurationIssuesAnalyzer", "Lcom/android/build/attribution/analyzers/TasksConfigurationIssuesAnalyzer;", "getAlwaysRunTasks", "", "Lcom/android/build/attribution/data/AlwaysRunTaskData;", "getAnnotationProcessorsData", "Lcom/android/build/attribution/data/AnnotationProcessorData;", "getBuildAttributionReportAnalyzers", "Lcom/android/build/attribution/analyzers/BuildAttributionReportAnalyzer;", "getBuildEventsAnalyzers", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzer;", "getBuildFinishedTimestamp", "", "getCriticalPathTasks", "Lcom/android/build/attribution/data/TaskData;", "getNonCacheableTasks", "getNonIncrementalAnnotationProcessorsData", "getPluginsDeterminingBuildDuration", "Lcom/android/build/attribution/data/PluginBuildData;", "getProjectsConfigurationData", "Lcom/android/build/attribution/data/ProjectConfigurationData;", "getTasksDeterminingBuildDuration", "getTasksSharingOutput", "Lcom/android/build/attribution/data/TasksSharingOutputData;", "getTotalBuildTimeMs", "getTotalConfigurationData", "intellij.android.build-attribution"})
public final class BuildEventsAnalyzersProxy
implements BuildEventsAnalysisResult {
    private final AlwaysRunTasksAnalyzer alwaysRunTasksAnalyzer;
    private final AnnotationProcessorsAnalyzer annotationProcessorsAnalyzer;
    private final CriticalPathAnalyzer criticalPathAnalyzer;
    private final NoncacheableTasksAnalyzer noncacheableTasksAnalyzer;
    private final ProjectConfigurationAnalyzer projectConfigurationAnalyzer;
    private final TasksConfigurationIssuesAnalyzer tasksConfigurationIssuesAnalyzer;

    @NotNull
    public final List<BuildEventsAnalyzer> getBuildEventsAnalyzers() {
        return CollectionsKt.listOf((Object[])new BuildEventsAnalyzer[]{this.alwaysRunTasksAnalyzer, this.annotationProcessorsAnalyzer, this.criticalPathAnalyzer, this.projectConfigurationAnalyzer});
    }

    @NotNull
    public final List<BuildAttributionReportAnalyzer> getBuildAttributionReportAnalyzers() {
        return CollectionsKt.listOf((Object[])new BuildAttributionReportAnalyzer[]{this.noncacheableTasksAnalyzer, this.tasksConfigurationIssuesAnalyzer});
    }

    @Override
    @NotNull
    public List<AnnotationProcessorData> getAnnotationProcessorsData() {
        return this.annotationProcessorsAnalyzer.getAnnotationProcessorsData();
    }

    @Override
    @NotNull
    public List<AnnotationProcessorData> getNonIncrementalAnnotationProcessorsData() {
        return this.annotationProcessorsAnalyzer.getNonIncrementalAnnotationProcessorsData();
    }

    @Override
    public long getTotalBuildTimeMs() {
        return this.criticalPathAnalyzer.getBuildFinishedTimestamp() - this.criticalPathAnalyzer.getBuildStartedTimestamp();
    }

    public final long getBuildFinishedTimestamp() {
        return this.criticalPathAnalyzer.getBuildFinishedTimestamp();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<TaskData> getCriticalPathTasks() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.criticalPathAnalyzer.getTasksDeterminingBuildDuration();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object receiver = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((TaskData)receiver).isOnTheCriticalPath()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<TaskData> getTasksDeterminingBuildDuration() {
        return this.criticalPathAnalyzer.getTasksDeterminingBuildDuration();
    }

    @Override
    @NotNull
    public List<PluginBuildData> getPluginsDeterminingBuildDuration() {
        return this.criticalPathAnalyzer.getPluginsDeterminingBuildDuration();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ProjectConfigurationData getTotalConfigurationData() {
        void $this$mapTo$iv$iv;
        Object $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        void it2;
        Iterable $this$sumByLong$iv = this.projectConfigurationAnalyzer.getProjectsConfigurationData();
        boolean $i$f$sumByLong = false;
        long sum$iv = 0L;
        for (Object element$iv : $this$sumByLong$iv) {
            ProjectConfigurationData projectConfigurationData = (ProjectConfigurationData)element$iv;
            long l = sum$iv;
            boolean bl = false;
            long l2 = it2.getTotalConfigurationTimeMs();
            sum$iv = l + l2;
        }
        long totalConfigurationTime = sum$iv;
        Map $this$map$iv = this.projectConfigurationAnalyzer.getPluginsConfigurationDataMap();
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        it2 = $this$mapTo$iv$iv2;
        boolean bl = false;
        Iterator iterator = it2.entrySet().iterator();
        while (iterator.hasNext()) {
            void entry;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            object = new PluginConfigurationData((PluginData)entry.getKey(), ((Number)entry.getValue()).longValue());
            collection2.add(object);
        }
        List totalPluginConfiguration = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = this.projectConfigurationAnalyzer.getProjectsConfigurationData();
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ProjectConfigurationData)element$iv$iv;
            boolean bl3 = false;
            list$iv$iv = ((ProjectConfigurationData)it).getConfigurationSteps();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object2;
            Object element$iv$iv;
            element$iv$iv = iterator2.next();
            it = (ProjectConfigurationData.ConfigurationStep)element$iv$iv;
            boolean bl4 = false;
            ProjectConfigurationData.ConfigurationStep.Type key$iv$iv = ((ProjectConfigurationData.ConfigurationStep)it).getType();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl5 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$map$iv2 = destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$groupByTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        iterator2 = $this$mapTo$iv$iv;
        boolean bl6 = false;
        Iterator iterator3 = iterator2.entrySet().iterator();
        while (iterator3.hasNext()) {
            long l;
            void $this$sumByLong$iv2;
            void entry;
            Map.Entry item$iv$iv;
            Map.Entry key$iv$iv = item$iv$iv = iterator3.next();
            Object object3 = destination$iv$iv2;
            boolean bl7 = false;
            Iterable $i$f$getOrPut = (Iterable)entry.getValue();
            ProjectConfigurationData.ConfigurationStep.Type type = (ProjectConfigurationData.ConfigurationStep.Type)((Object)entry.getKey());
            boolean $i$f$sumByLong2 = false;
            long sum$iv2 = 0L;
            for (Object element$iv : $this$sumByLong$iv2) {
                void it3;
                ProjectConfigurationData.ConfigurationStep configurationStep = (ProjectConfigurationData.ConfigurationStep)element$iv;
                l = sum$iv2;
                boolean bl8 = false;
                long l3 = it3.getConfigurationTimeMs();
                sum$iv2 = l + l3;
            }
            long l4 = l = sum$iv2;
            ProjectConfigurationData.ConfigurationStep.Type type2 = type;
            object = new ProjectConfigurationData.ConfigurationStep(type2, l4);
            object3.add(object);
        }
        List totalConfigurationSteps = (List)destination$iv$iv2;
        return new ProjectConfigurationData("Total Configuration Data", totalConfigurationTime, totalPluginConfiguration, totalConfigurationSteps);
    }

    @Override
    @NotNull
    public List<ProjectConfigurationData> getProjectsConfigurationData() {
        return this.projectConfigurationAnalyzer.getProjectsConfigurationData();
    }

    @Override
    @NotNull
    public List<AlwaysRunTaskData> getAlwaysRunTasks() {
        return this.alwaysRunTasksAnalyzer.getAlwaysRunTasks();
    }

    @Override
    @NotNull
    public List<TaskData> getNonCacheableTasks() {
        return this.noncacheableTasksAnalyzer.getNoncacheableTasks();
    }

    @Override
    @NotNull
    public List<TasksSharingOutputData> getTasksSharingOutput() {
        return this.tasksConfigurationIssuesAnalyzer.getTasksSharingOutput();
    }

    public BuildEventsAnalyzersProxy(@NotNull BuildAttributionWarningsFilter warningsFilter, @NotNull TaskContainer taskContainer, @NotNull PluginContainer pluginContainer) {
        Intrinsics.checkNotNullParameter((Object)warningsFilter, (String)"warningsFilter");
        Intrinsics.checkNotNullParameter((Object)taskContainer, (String)"taskContainer");
        Intrinsics.checkNotNullParameter((Object)pluginContainer, (String)"pluginContainer");
        this.alwaysRunTasksAnalyzer = new AlwaysRunTasksAnalyzer(warningsFilter, taskContainer, pluginContainer);
        this.annotationProcessorsAnalyzer = new AnnotationProcessorsAnalyzer(warningsFilter);
        this.criticalPathAnalyzer = new CriticalPathAnalyzer(warningsFilter, taskContainer, pluginContainer);
        this.noncacheableTasksAnalyzer = new NoncacheableTasksAnalyzer(warningsFilter, taskContainer, pluginContainer);
        this.projectConfigurationAnalyzer = new ProjectConfigurationAnalyzer(warningsFilter, taskContainer, pluginContainer);
        this.tasksConfigurationIssuesAnalyzer = new TasksConfigurationIssuesAnalyzer(warningsFilter, taskContainer, pluginContainer);
    }
}

