/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.BuildAttributionWarningsFilter;
import com.android.build.attribution.analyzers.BaseAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzer;
import com.android.build.attribution.data.PluginContainer;
import com.android.build.attribution.data.PluginData;
import com.android.build.attribution.data.ProjectConfigurationData;
import com.android.build.attribution.data.TaskContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.SuccessResult;
import org.gradle.tooling.events.configuration.ProjectConfigurationFinishEvent;
import org.gradle.tooling.events.configuration.ProjectConfigurationOperationDescriptor;
import org.gradle.tooling.events.configuration.ProjectConfigurationStartEvent;
import org.gradle.tooling.events.configuration.ProjectConfigurationSuccessResult;
import org.gradle.tooling.model.ProjectIdentifier;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020!H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000fH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R-\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lcom/android/build/attribution/analyzers/ProjectConfigurationAnalyzer;", "Lcom/android/build/attribution/analyzers/BaseAnalyzer;", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzer;", "warningsFilter", "Lcom/android/build/attribution/BuildAttributionWarningsFilter;", "taskContainer", "Lcom/android/build/attribution/data/TaskContainer;", "pluginContainer", "Lcom/android/build/attribution/data/PluginContainer;", "(Lcom/android/build/attribution/BuildAttributionWarningsFilter;Lcom/android/build/attribution/data/TaskContainer;Lcom/android/build/attribution/data/PluginContainer;)V", "applyPluginEventPrefix", "", "pluginsConfigurationDataMap", "Ljava/util/HashMap;", "Lcom/android/build/attribution/data/PluginData;", "", "Lkotlin/collections/HashMap;", "getPluginsConfigurationDataMap", "()Ljava/util/HashMap;", "projectConfigurationBuilder", "Lcom/android/build/attribution/data/ProjectConfigurationData$Builder;", "projectsConfigurationData", "Ljava/util/ArrayList;", "Lcom/android/build/attribution/data/ProjectConfigurationData;", "Lkotlin/collections/ArrayList;", "getProjectsConfigurationData", "()Ljava/util/ArrayList;", "getWarningsFilter", "()Lcom/android/build/attribution/BuildAttributionWarningsFilter;", "getFirstConfigurationStepInParentEvents", "Lorg/gradle/tooling/events/OperationDescriptor;", "descriptor", "onBuildFailure", "", "onBuildStart", "onBuildSuccess", "receiveEvent", "event", "Lorg/gradle/tooling/events/ProgressEvent;", "updatePluginConfigurationTime", "plugin", "configurationTimeMs", "intellij.android.build-attribution"})
public final class ProjectConfigurationAnalyzer
extends BaseAnalyzer
implements BuildEventsAnalyzer {
    private final String applyPluginEventPrefix;
    @NotNull
    private final HashMap<PluginData, Long> pluginsConfigurationDataMap;
    @NotNull
    private final ArrayList<ProjectConfigurationData> projectsConfigurationData;
    private ProjectConfigurationData.Builder projectConfigurationBuilder;
    @NotNull
    private final BuildAttributionWarningsFilter warningsFilter;

    @NotNull
    public final HashMap<PluginData, Long> getPluginsConfigurationDataMap() {
        return this.pluginsConfigurationDataMap;
    }

    @NotNull
    public final ArrayList<ProjectConfigurationData> getProjectsConfigurationData() {
        return this.projectsConfigurationData;
    }

    private final void updatePluginConfigurationTime(PluginData plugin, long configurationTimeMs) {
        Long l = this.pluginsConfigurationDataMap.getOrDefault(plugin, 0L);
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"pluginsConfigurationData\u2026.getOrDefault(plugin, 0L)");
        long currentConfigurationTime = ((Number)l).longValue();
        ((Map)this.pluginsConfigurationDataMap).put(plugin, currentConfigurationTime + configurationTimeMs);
        ProjectConfigurationData.Builder builder2 = this.projectConfigurationBuilder;
        Intrinsics.checkNotNull((Object)builder2);
        builder2.addPluginConfigurationData(plugin, configurationTimeMs);
    }

    @Override
    public void receiveEvent(@NotNull ProgressEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof ProjectConfigurationStartEvent) {
            ProjectConfigurationOperationDescriptor projectConfigurationOperationDescriptor = ((ProjectConfigurationStartEvent)event).getDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)projectConfigurationOperationDescriptor, (String)"event.descriptor");
            ProjectIdentifier projectIdentifier = projectConfigurationOperationDescriptor.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)projectIdentifier, (String)"event.descriptor.project");
            String string = projectIdentifier.getProjectPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.descriptor.project.projectPath");
            this.projectConfigurationBuilder = new ProjectConfigurationData.Builder(string);
        } else if (this.projectConfigurationBuilder != null) {
            if (event instanceof ProjectConfigurationFinishEvent && ((ProjectConfigurationFinishEvent)event).getResult() instanceof ProjectConfigurationSuccessResult) {
                ProjectConfigurationData.Builder builder2 = this.projectConfigurationBuilder;
                Intrinsics.checkNotNull((Object)builder2);
                OperationResult operationResult = ((ProjectConfigurationFinishEvent)event).getResult();
                Intrinsics.checkNotNullExpressionValue((Object)operationResult, (String)"event.result");
                long l = operationResult.getEndTime();
                OperationResult operationResult2 = ((ProjectConfigurationFinishEvent)event).getResult();
                Intrinsics.checkNotNullExpressionValue((Object)operationResult2, (String)"event.result");
                this.projectsConfigurationData.add(builder2.build(l - operationResult2.getStartTime()));
                this.projectConfigurationBuilder = null;
            } else if (event instanceof FinishEvent && ((FinishEvent)event).getResult() instanceof SuccessResult) {
                OperationDescriptor operationDescriptor = ((FinishEvent)event).getDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)operationDescriptor, (String)"event.descriptor");
                String string = operationDescriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.descriptor.name");
                if (StringsKt.startsWith$default((String)string, (String)this.applyPluginEventPrefix, (boolean)false, (int)2, null)) {
                    OperationDescriptor operationDescriptor2 = ((FinishEvent)event).getDescriptor();
                    Intrinsics.checkNotNullExpressionValue((Object)operationDescriptor2, (String)"event.descriptor");
                    Object object = operationDescriptor2.getParent();
                    if (object == null || (object = object.getName()) == null || !StringsKt.startsWith$default((String)object, (String)this.applyPluginEventPrefix, (boolean)false, (int)2, null)) {
                        OperationDescriptor operationDescriptor3 = ((FinishEvent)event).getDescriptor();
                        Intrinsics.checkNotNullExpressionValue((Object)operationDescriptor3, (String)"event.descriptor");
                        String string2 = operationDescriptor3.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.descriptor.name");
                        String string3 = string2;
                        int n = this.applyPluginEventPrefix.length() + 1;
                        boolean bl = false;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = string4.substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                        String pluginName = string5;
                        ProjectConfigurationData.Builder builder3 = this.projectConfigurationBuilder;
                        Intrinsics.checkNotNull((Object)builder3);
                        PluginData plugin = this.getPlugin(PluginData.PluginType.PLUGIN, pluginName, builder3.getProjectPath());
                        OperationResult operationResult = ((FinishEvent)event).getResult();
                        Intrinsics.checkNotNullExpressionValue((Object)operationResult, (String)"event.result");
                        long l = operationResult.getEndTime();
                        OperationResult operationResult3 = ((FinishEvent)event).getResult();
                        Intrinsics.checkNotNullExpressionValue((Object)operationResult3, (String)"event.result");
                        long pluginConfigurationTime = l - operationResult3.getStartTime();
                        this.updatePluginConfigurationTime(plugin, pluginConfigurationTime);
                        OperationDescriptor configurationStepDescriptor = this.getFirstConfigurationStepInParentEvents(((FinishEvent)event).getDescriptor());
                        if (configurationStepDescriptor != null) {
                            ProjectConfigurationData.Builder builder4 = this.projectConfigurationBuilder;
                            Intrinsics.checkNotNull((Object)builder4);
                            builder4.subtractConfigurationStepTime(configurationStepDescriptor, pluginConfigurationTime);
                        }
                    }
                } else {
                    boolean bl;
                    block14: {
                        ProjectConfigurationData.ConfigurationStep.Type[] $this$any$iv = ProjectConfigurationData.ConfigurationStep.Type.values();
                        boolean $i$f$any = false;
                        ProjectConfigurationData.ConfigurationStep.Type[] typeArray = $this$any$iv;
                        int n = typeArray.length;
                        for (int j = 0; j < n; ++j) {
                            ProjectConfigurationData.ConfigurationStep.Type element$iv;
                            ProjectConfigurationData.ConfigurationStep.Type it = element$iv = typeArray[j];
                            boolean bl2 = false;
                            OperationDescriptor operationDescriptor4 = ((FinishEvent)event).getDescriptor();
                            Intrinsics.checkNotNullExpressionValue((Object)operationDescriptor4, (String)"event.descriptor");
                            if (!it.isDescriptorOfType(operationDescriptor4)) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                    if (bl) {
                        OperationDescriptor operationDescriptor5 = ((FinishEvent)event).getDescriptor();
                        Intrinsics.checkNotNullExpressionValue((Object)operationDescriptor5, (String)"event.descriptor");
                        if (this.getFirstConfigurationStepInParentEvents(operationDescriptor5.getParent()) == null) {
                            ProjectConfigurationData.Builder builder5 = this.projectConfigurationBuilder;
                            Intrinsics.checkNotNull((Object)builder5);
                            OperationDescriptor operationDescriptor6 = ((FinishEvent)event).getDescriptor();
                            Intrinsics.checkNotNullExpressionValue((Object)operationDescriptor6, (String)"event.descriptor");
                            OperationResult operationResult = ((FinishEvent)event).getResult();
                            Intrinsics.checkNotNullExpressionValue((Object)operationResult, (String)"event.result");
                            long l = operationResult.getEndTime();
                            OperationResult operationResult4 = ((FinishEvent)event).getResult();
                            Intrinsics.checkNotNullExpressionValue((Object)operationResult4, (String)"event.result");
                            builder5.addConfigurationStepTime(operationDescriptor6, l - operationResult4.getStartTime());
                        }
                    }
                }
            }
        }
    }

    private final OperationDescriptor getFirstConfigurationStepInParentEvents(OperationDescriptor descriptor2) {
        boolean bl;
        block4: {
            if (descriptor2 == null) {
                return null;
            }
            OperationDescriptor configurationStepDescriptor = this.getFirstConfigurationStepInParentEvents(descriptor2.getParent());
            if (configurationStepDescriptor != null) {
                return configurationStepDescriptor;
            }
            ProjectConfigurationData.ConfigurationStep.Type[] $this$any$iv = ProjectConfigurationData.ConfigurationStep.Type.values();
            boolean $i$f$any = false;
            ProjectConfigurationData.ConfigurationStep.Type[] typeArray = $this$any$iv;
            int n = typeArray.length;
            for (int j = 0; j < n; ++j) {
                ProjectConfigurationData.ConfigurationStep.Type element$iv;
                ProjectConfigurationData.ConfigurationStep.Type it = element$iv = typeArray[j];
                boolean bl2 = false;
                if (!it.isDescriptorOfType(descriptor2)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            return descriptor2;
        }
        return null;
    }

    @Override
    public void onBuildStart() {
        super.onBuildStart();
        this.projectsConfigurationData.clear();
        this.pluginsConfigurationDataMap.clear();
        this.projectConfigurationBuilder = null;
    }

    @Override
    public void onBuildSuccess() {
    }

    @Override
    public void onBuildFailure() {
        this.projectsConfigurationData.clear();
        this.pluginsConfigurationDataMap.clear();
        this.projectConfigurationBuilder = null;
    }

    @Override
    @NotNull
    public BuildAttributionWarningsFilter getWarningsFilter() {
        return this.warningsFilter;
    }

    public ProjectConfigurationAnalyzer(@NotNull BuildAttributionWarningsFilter warningsFilter, @NotNull TaskContainer taskContainer, @NotNull PluginContainer pluginContainer) {
        Intrinsics.checkNotNullParameter((Object)warningsFilter, (String)"warningsFilter");
        Intrinsics.checkNotNullParameter((Object)taskContainer, (String)"taskContainer");
        Intrinsics.checkNotNullParameter((Object)pluginContainer, (String)"pluginContainer");
        super(taskContainer, pluginContainer);
        this.warningsFilter = warningsFilter;
        this.applyPluginEventPrefix = "Apply plugin";
        this.pluginsConfigurationDataMap = new HashMap();
        this.projectsConfigurationData = new ArrayList();
    }
}

