/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.panels;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.DescriptionWithHelpLinkLabel;
import com.android.build.attribution.ui.analytics.BuildAttributionUiAnalytics;
import com.android.build.attribution.ui.data.AnnotationProcessorUiData;
import com.android.build.attribution.ui.panels.BuildAttributionPanelsKt;
import com.android.utils.HtmlBuilder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class AnnotationProcessorIssueInfoPanel
extends JBPanel {
    private static final String DESCRIPTION = "This annotation processor is non-incremental and causes the JavaCompile task to always run non-incrementally. Consider switching to using an incremental annotation processor.";
    private static final String HELP_LINK = "https://d.android.com/r/tools/build-attribution/non-incremental-ap";
    private final BuildAttributionUiAnalytics myAnalytics;

    public AnnotationProcessorIssueInfoPanel(AnnotationProcessorUiData annotationProcessorUiData, BuildAttributionUiAnalytics analytics) {
        super((LayoutManager)new GridBagLayout());
        this.myAnalytics = analytics;
        GridBagConstraints c = new GridBagConstraints();
        c.insets = JBUI.insetsBottom((int)15);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        c.anchor = 23;
        this.add(this.createIssueDescription(), c);
        c.gridy = 3;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)new JBPanel(), c);
        this.withPreferredWidth(500);
    }

    protected JComponent createIssueDescription() {
        String descriptionHtml = new HtmlBuilder().openHtmlBody().addHtml(DESCRIPTION).closeHtmlBody().getHtml();
        String recommendationHtml = new HtmlBuilder().openHtmlBody().addBold("Recommendation").newline().add("Ensure that you are using the most recent version of this annotation processor.").closeHtmlBody().getHtml();
        JLabel iconLabel = new JLabel(BuildAttributionUIUtilKt.warningIcon());
        DescriptionWithHelpLinkLabel issueDescription = new DescriptionWithHelpLinkLabel(descriptionHtml, HELP_LINK, this.myAnalytics);
        JBLabel recommendation = BuildAttributionPanelsKt.htmlTextLabel(recommendationHtml);
        JBPanel panel2 = new JBPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 23;
        panel2.add((Component)iconLabel, (Object)c);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = JBUI.insetsLeft((int)5);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        panel2.add((Component)((Object)issueDescription), (Object)c);
        c.gridx = 1;
        c.gridy = 1;
        c.weighty = 1.0;
        c.insets = JBUI.insets((int)5, (int)5, (int)0, (int)0);
        panel2.add((Component)recommendation, (Object)c);
        return panel2;
    }
}

