/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.panels;

import com.android.build.attribution.ui.data.TaskUiData;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ui.ColorIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JPanel;

public interface CriticalPathChartLegend {
    public static final ChartColor MISC_COLOR = new ChartColor(new Color(0xBDBDBD));
    public static final ChartColor OTHER_TASKS_COLOR = new ChartColor(new Color(10674174));
    public static final Color OTHER_TASKS_TEXT_COLOR = Color.BLACK;
    public static final ChartColor androidPluginColor = new ChartColor(new Color(15101850));
    public static final ChartColor externalPluginColor = new ChartColor(new Color(1735423));
    public static final ChartColor buildsrcPluginColor = new ChartColor(new Color(10980313));
    public static final ChartColor[] categoricalGooglePalette = new ChartColor[]{new ChartColor(new Color(9941440)), new ChartColor(new Color(10674174)), new ChartColor(new Color(16227438)), new ChartColor(new Color(7660168)), new ChartColor(new Color(10980313)), new ChartColor(new Color(15101850)), new ChartColor(new Color(5432783)), new ChartColor(new Color(14666911)), new ChartColor(new Color(37844)), new ChartColor(new Color(1412991)), new ChartColor(new Color(8539103)), new ChartColor(new Color(12670746)), new ChartColor(new Color(3365529)), new ChartColor(new Color(11381816)), new ChartColor(new Color(12073102)), new ChartColor(new Color(1735423))};

    public static JPanel createTasksLegendPanel() {
        JPanel panel2 = new JPanel((LayoutManager)new HorizontalLayout(10));
        panel2.add((Component)new JBLabel("Android/Java/Kotlin Plugin", (Icon)new ColorIcon(10, CriticalPathChartLegend.androidPluginColor.baseColor), 4));
        panel2.add((Component)new JBLabel("Other Plugin", (Icon)new ColorIcon(10, CriticalPathChartLegend.externalPluginColor.baseColor), 4));
        panel2.add((Component)new JBLabel("Project Customization", (Icon)new ColorIcon(10, CriticalPathChartLegend.buildsrcPluginColor.baseColor), 4));
        return panel2;
    }

    public static ChartColor resolveTaskColor(TaskUiData taskData) {
        switch (taskData.getSourceType()) {
            case BUILD_SRC: {
                return buildsrcPluginColor;
            }
            case ANDROID_PLUGIN: {
                return androidPluginColor;
            }
            case THIRD_PARTY: {
                return externalPluginColor;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + taskData.getSourceType());
    }

    public static class PluginColorPalette {
        private int paletteCursor = 0;

        public ChartColor getNewColor() {
            return categoricalGooglePalette[Math.min(this.paletteCursor++, categoricalGooglePalette.length)];
        }
    }

    public static class ChartColor {
        public final Color baseColor;
        public final Color selectionColor;

        public ChartColor(Color baseColor) {
            this.baseColor = baseColor;
            this.selectionColor = new Color(baseColor.getRed() / 2, baseColor.getGreen() / 2, baseColor.getBlue() / 2);
        }
    }
}

