/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.tree;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.data.BuildSummary;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.build.attribution.ui.panels.AbstractBuildAttributionInfoPanel;
import com.android.build.attribution.ui.panels.BuildAttributionPanelsKt;
import com.android.build.attribution.ui.panels.ChartBuildAttributionInfoPanel;
import com.android.build.attribution.ui.panels.CriticalPathChartLegend;
import com.android.build.attribution.ui.panels.TimeDistributionChart;
import com.android.build.attribution.ui.tree.AbstractBuildAttributionNode;
import com.android.build.attribution.ui.tree.ControllersAwareBuildAttributionNode;
import com.android.build.attribution.ui.tree.MiscGradleStepsChartItem;
import com.google.wireless.android.sdk.stats.BuildAttributionUiEvent;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.text.DateFormatUtil;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\fH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/android/build/attribution/ui/tree/BuildSummaryNode;", "Lcom/android/build/attribution/ui/tree/AbstractBuildAttributionNode;", "buildSummary", "Lcom/android/build/attribution/ui/data/BuildSummary;", "parent", "Lcom/android/build/attribution/ui/tree/ControllersAwareBuildAttributionNode;", "(Lcom/android/build/attribution/ui/data/BuildSummary;Lcom/android/build/attribution/ui/tree/ControllersAwareBuildAttributionNode;)V", "getBuildSummary", "()Lcom/android/build/attribution/ui/data/BuildSummary;", "chartItems", "", "Lcom/android/build/attribution/ui/panels/TimeDistributionChart$ChartDataItem;", "", "issuesCountsSuffix", "getIssuesCountsSuffix", "()Ljava/lang/String;", "pageType", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "getPageType", "()Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "presentationIcon", "Ljavax/swing/Icon;", "getPresentationIcon", "()Ljavax/swing/Icon;", "timeSuffix", "getTimeSuffix", "buildChildren", "", "Lcom/intellij/ui/treeStructure/SimpleNode;", "()[Lcom/intellij/ui/treeStructure/SimpleNode;", "buildFinishedTime", "createComponent", "Lcom/android/build/attribution/ui/panels/AbstractBuildAttributionInfoPanel;", "SimpleChartItem", "intellij.android.build-attribution"})
public final class BuildSummaryNode
extends AbstractBuildAttributionNode {
    private final List<TimeDistributionChart.ChartDataItem<String>> chartItems;
    @Nullable
    private final Icon presentationIcon;
    @NotNull
    private final String issuesCountsSuffix;
    @NotNull
    private final String timeSuffix;
    @NotNull
    private final BuildAttributionUiEvent.Page.PageType pageType;
    @NotNull
    private final BuildSummary buildSummary;

    @Override
    @Nullable
    public Icon getPresentationIcon() {
        return this.presentationIcon;
    }

    @Override
    @NotNull
    public String getIssuesCountsSuffix() {
        return this.issuesCountsSuffix;
    }

    @Override
    @NotNull
    public String getTimeSuffix() {
        return this.timeSuffix;
    }

    @NotNull
    protected SimpleNode[] buildChildren() {
        return new SimpleNode[0];
    }

    @Override
    @NotNull
    public AbstractBuildAttributionInfoPanel createComponent() {
        return new ChartBuildAttributionInfoPanel(this){
            final /* synthetic */ BuildSummaryNode this$0;

            @NotNull
            public JComponent createHeader() {
                return BuildAttributionPanelsKt.headerLabel("Build finished at " + BuildSummaryNode.access$buildFinishedTime(this.this$0));
            }

            @NotNull
            public JComponent createChart() {
                return new TimeDistributionChart<T>(BuildSummaryNode.access$getChartItems$p(this.this$0), null, true);
            }

            @Nullable
            public JComponent createRightInfoPanel() {
                return null;
            }

            @Nullable
            public JComponent createLegend() {
                return null;
            }

            @NotNull
            public JComponent createDescription() {
                return (JComponent)new JBLabel("Total build duration was " + BuildAttributionUIUtilKt.durationString(this.this$0.getBuildSummary().getTotalBuildDuration()) + '.');
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    @Override
    @NotNull
    public BuildAttributionUiEvent.Page.PageType getPageType() {
        return this.pageType;
    }

    private final String buildFinishedTime() {
        String string = DateFormatUtil.formatDateTime((long)this.buildSummary.getBuildFinishedTimestamp());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DateFormatUtil.formatDat\u2026y.buildFinishedTimestamp)");
        return string;
    }

    @NotNull
    public final BuildSummary getBuildSummary() {
        return this.buildSummary;
    }

    public BuildSummaryNode(@NotNull BuildSummary buildSummary, @NotNull ControllersAwareBuildAttributionNode parent) {
        Intrinsics.checkNotNullParameter((Object)buildSummary, (String)"buildSummary");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(parent, "Build:");
        this.buildSummary = buildSummary;
        Object[] objectArray = new TimeDistributionChart.ChartDataItem[3];
        TimeWithPercentage timeWithPercentage = this.buildSummary.getConfigurationDuration();
        CriticalPathChartLegend.ChartColor chartColor = CriticalPathChartLegend.categoricalGooglePalette[0];
        Intrinsics.checkNotNullExpressionValue((Object)chartColor, (String)"categoricalGooglePalette[0]");
        objectArray[0] = new SimpleChartItem(timeWithPercentage, "Build configuration", chartColor);
        TimeWithPercentage timeWithPercentage2 = this.buildSummary.getCriticalPathDuration();
        CriticalPathChartLegend.ChartColor chartColor2 = CriticalPathChartLegend.categoricalGooglePalette[1];
        Intrinsics.checkNotNullExpressionValue((Object)chartColor2, (String)"categoricalGooglePalette[1]");
        objectArray[1] = new SimpleChartItem(timeWithPercentage2, "Tasks execution", chartColor2);
        objectArray[2] = new MiscGradleStepsChartItem(this.buildSummary.getMiscStepsTime());
        this.chartItems = CollectionsKt.listOf((Object[])objectArray);
        this.issuesCountsSuffix = "finished at " + this.buildFinishedTime();
        this.timeSuffix = BuildAttributionUIUtilKt.durationString(this.buildSummary.getTotalBuildDuration());
        this.pageType = BuildAttributionUiEvent.Page.PageType.BUILD_SUMMARY;
    }

    public static final /* synthetic */ String access$buildFinishedTime(BuildSummaryNode $this) {
        return $this.buildFinishedTime();
    }

    public static final /* synthetic */ List access$getChartItems$p(BuildSummaryNode $this) {
        return $this.chartItems;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0005\u001a\u00020\u0002H\u0016J\b\u0010\u0003\u001a\u00020\u0004H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/attribution/ui/tree/BuildSummaryNode$SimpleChartItem;", "Lcom/android/build/attribution/ui/panels/TimeDistributionChart$ChartDataItem;", "", "time", "Lcom/android/build/attribution/ui/data/TimeWithPercentage;", "text", "color", "Lcom/android/build/attribution/ui/panels/CriticalPathChartLegend$ChartColor;", "(Lcom/android/build/attribution/ui/data/TimeWithPercentage;Ljava/lang/String;Lcom/android/build/attribution/ui/panels/CriticalPathChartLegend$ChartColor;)V", "chartBoxText", "getLegendColor", "getTableIcon", "Ljavax/swing/Icon;", "intellij.android.build-attribution"})
    public static final class SimpleChartItem
    implements TimeDistributionChart.ChartDataItem<String> {
        private final TimeWithPercentage time;
        private final String text;
        private final CriticalPathChartLegend.ChartColor color;

        @Override
        @NotNull
        public TimeWithPercentage time() {
            return this.time;
        }

        @Override
        @NotNull
        public String text() {
            return this.text;
        }

        @Override
        @NotNull
        public CriticalPathChartLegend.ChartColor getLegendColor() {
            return this.color;
        }

        @Override
        @Nullable
        public Icon getTableIcon() {
            return null;
        }

        @Override
        @Nullable
        public String chartBoxText() {
            return null;
        }

        public SimpleChartItem(@NotNull TimeWithPercentage time2, @NotNull String text, @NotNull CriticalPathChartLegend.ChartColor color) {
            Intrinsics.checkNotNullParameter((Object)time2, (String)"time");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.time = time2;
            this.text = text;
            this.color = color;
        }
    }
}

