/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.tree;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.DescriptionWithHelpLinkLabel;
import com.android.build.attribution.ui.data.CriticalPathPluginUiData;
import com.android.build.attribution.ui.data.CriticalPathPluginsUiData;
import com.android.build.attribution.ui.panels.AbstractBuildAttributionInfoPanel;
import com.android.build.attribution.ui.panels.BuildAttributionPanelsKt;
import com.android.build.attribution.ui.panels.ChartBuildAttributionInfoPanel;
import com.android.build.attribution.ui.panels.TimeDistributionChart;
import com.android.build.attribution.ui.tree.AbstractBuildAttributionNode;
import com.android.build.attribution.ui.tree.ChartDataItemsKt;
import com.android.build.attribution.ui.tree.ControllersAwareBuildAttributionNode;
import com.android.build.attribution.ui.tree.PluginNode;
import com.android.utils.HtmlBuilder;
import com.google.wireless.android.sdk.stats.BuildAttributionUiEvent;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0014\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/android/build/attribution/ui/tree/CriticalPathPluginsRoot;", "Lcom/android/build/attribution/ui/tree/AbstractBuildAttributionNode;", "criticalPathUiData", "Lcom/android/build/attribution/ui/data/CriticalPathPluginsUiData;", "parent", "Lcom/android/build/attribution/ui/tree/ControllersAwareBuildAttributionNode;", "(Lcom/android/build/attribution/ui/data/CriticalPathPluginsUiData;Lcom/android/build/attribution/ui/tree/ControllersAwareBuildAttributionNode;)V", "chartItems", "", "Lcom/android/build/attribution/ui/panels/TimeDistributionChart$ChartDataItem;", "Lcom/android/build/attribution/ui/data/CriticalPathPluginUiData;", "issuesCountsSuffix", "", "getIssuesCountsSuffix", "()Ljava/lang/String;", "pageType", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "getPageType", "()Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "presentationIcon", "Ljavax/swing/Icon;", "getPresentationIcon", "()Ljavax/swing/Icon;", "timeSuffix", "getTimeSuffix", "buildChildren", "", "Lcom/intellij/ui/treeStructure/SimpleNode;", "()[Lcom/intellij/ui/treeStructure/SimpleNode;", "createComponent", "Lcom/android/build/attribution/ui/panels/AbstractBuildAttributionInfoPanel;", "intellij.android.build-attribution"})
public final class CriticalPathPluginsRoot
extends AbstractBuildAttributionNode {
    private final List<TimeDistributionChart.ChartDataItem<CriticalPathPluginUiData>> chartItems;
    @Nullable
    private final Icon presentationIcon;
    @Nullable
    private final String issuesCountsSuffix;
    @Nullable
    private final String timeSuffix;
    @NotNull
    private final BuildAttributionUiEvent.Page.PageType pageType;
    private final CriticalPathPluginsUiData criticalPathUiData;

    @Override
    @Nullable
    public Icon getPresentationIcon() {
        return this.presentationIcon;
    }

    @Override
    @Nullable
    public String getIssuesCountsSuffix() {
        return this.issuesCountsSuffix;
    }

    @Override
    @Nullable
    public String getTimeSuffix() {
        return this.timeSuffix;
    }

    @Override
    @NotNull
    public BuildAttributionUiEvent.Page.PageType getPageType() {
        return this.pageType;
    }

    @Override
    @NotNull
    public AbstractBuildAttributionInfoPanel createComponent() {
        return new ChartBuildAttributionInfoPanel(this){
            final /* synthetic */ CriticalPathPluginsRoot this$0;

            @NotNull
            public JComponent createChart() {
                return new TimeDistributionChart<T>(CriticalPathPluginsRoot.access$getChartItems$p(this.this$0), null, true);
            }

            @Nullable
            public JComponent createLegend() {
                return null;
            }

            @NotNull
            public JComponent createDescription() {
                HtmlBuilder text;
                HtmlBuilder htmlBuilder = text = new HtmlBuilder().openHtmlBody().add("Each of these plugins added at least one task that had an impact on this build\u2019s duration.").newline().add("Addressing this group provides the greatest likelihood of reducing the overall build duration.").closeHtmlBody();
                Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"text");
                String string = htmlBuilder.getHtml();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text.html");
                return (JComponent)((Object)new DescriptionWithHelpLinkLabel(string, "https://developer.android.com/r/tools/build-attribution/critical-path", this.this$0.getAnalytics()));
            }

            @Nullable
            public JComponent createRightInfoPanel() {
                return null;
            }

            @NotNull
            public JComponent createHeader() {
                return BuildAttributionPanelsKt.criticalPathHeader("Plugins with tasks", BuildAttributionUIUtilKt.durationString(CriticalPathPluginsRoot.access$getCriticalPathUiData$p(this.this$0).getCriticalPathDuration()));
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    @NotNull
    protected SimpleNode[] buildChildren() {
        ArrayList<PluginNode> nodes = new ArrayList<PluginNode>();
        for (TimeDistributionChart.ChartDataItem<CriticalPathPluginUiData> item : this.chartItems) {
            TimeDistributionChart.ChartDataItem<CriticalPathPluginUiData> chartDataItem = item;
            if (chartDataItem instanceof TimeDistributionChart.SingularChartDataItem) {
                Object t = ((TimeDistributionChart.SingularChartDataItem)item).getUnderlyingData();
                Intrinsics.checkNotNullExpressionValue(t, (String)"item.underlyingData");
                nodes.add(new PluginNode((CriticalPathPluginUiData)t, this.chartItems, item, this));
                continue;
            }
            if (!(chartDataItem instanceof TimeDistributionChart.AggregatedChartDataItem)) continue;
            List list = ((TimeDistributionChart.AggregatedChartDataItem)item).getUnderlyingData();
            Intrinsics.checkNotNullExpressionValue(list, (String)"item.underlyingData");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CriticalPathPluginUiData it = (CriticalPathPluginUiData)element$iv;
                boolean bl = false;
                CriticalPathPluginUiData criticalPathPluginUiData = it;
                Intrinsics.checkNotNullExpressionValue((Object)criticalPathPluginUiData, (String)"it");
                nodes.add(new PluginNode(criticalPathPluginUiData, this.chartItems, item, this));
            }
        }
        Collection $this$toTypedArray$iv = nodes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SimpleNode[] simpleNodeArray = thisCollection$iv.toArray(new SimpleNode[0]);
        if (simpleNodeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return simpleNodeArray;
    }

    public CriticalPathPluginsRoot(@NotNull CriticalPathPluginsUiData criticalPathUiData, @NotNull ControllersAwareBuildAttributionNode parent) {
        Intrinsics.checkNotNullParameter((Object)criticalPathUiData, (String)"criticalPathUiData");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(parent, "Plugins with tasks determining this build's duration");
        this.criticalPathUiData = criticalPathUiData;
        this.chartItems = ChartDataItemsKt.createPluginChartItems(this.criticalPathUiData);
        this.issuesCountsSuffix = BuildAttributionUIUtilKt.issuesCountString(this.criticalPathUiData.getWarningCount(), this.criticalPathUiData.getInfoCount());
        this.timeSuffix = BuildAttributionUIUtilKt.durationString(this.criticalPathUiData.getCriticalPathDuration());
        this.pageType = BuildAttributionUiEvent.Page.PageType.PLUGINS_ROOT;
    }

    public static final /* synthetic */ List access$getChartItems$p(CriticalPathPluginsRoot $this) {
        return $this.chartItems;
    }

    public static final /* synthetic */ CriticalPathPluginsUiData access$getCriticalPathUiData$p(CriticalPathPluginsRoot $this) {
        return $this.criticalPathUiData;
    }
}

