/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.tree;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.DescriptionWithHelpLinkLabel;
import com.android.build.attribution.ui.data.CriticalPathPluginUiData;
import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.build.attribution.ui.panels.AbstractBuildAttributionInfoPanel;
import com.android.build.attribution.ui.panels.BuildAttributionPanelsKt;
import com.android.build.attribution.ui.panels.TimeDistributionChart;
import com.android.build.attribution.ui.panels.TreeLinkListener;
import com.android.build.attribution.ui.tree.AbstractBuildAttributionNode;
import com.android.build.attribution.ui.tree.ChartElementSelectedPanel;
import com.android.build.attribution.ui.tree.PluginNode;
import com.android.build.attribution.ui.tree.PluginTaskNode;
import com.android.build.attribution.ui.tree.PluginTasksRootNode;
import com.android.utils.HtmlBuilder;
import com.google.wireless.android.sdk.stats.BuildAttributionUiEvent;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.treeStructure.SimpleNode;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0014\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020!H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/android/build/attribution/ui/tree/PluginTasksRootNode;", "Lcom/android/build/attribution/ui/tree/AbstractBuildAttributionNode;", "pluginData", "Lcom/android/build/attribution/ui/data/CriticalPathPluginUiData;", "chartItems", "", "Lcom/android/build/attribution/ui/panels/TimeDistributionChart$ChartDataItem;", "selectedChartItem", "parent", "Lcom/android/build/attribution/ui/tree/PluginNode;", "issueClickListener", "Lcom/android/build/attribution/ui/panels/TreeLinkListener;", "Lcom/android/build/attribution/ui/data/TaskIssueUiData;", "(Lcom/android/build/attribution/ui/data/CriticalPathPluginUiData;Ljava/util/List;Lcom/android/build/attribution/ui/panels/TimeDistributionChart$ChartDataItem;Lcom/android/build/attribution/ui/tree/PluginNode;Lcom/android/build/attribution/ui/panels/TreeLinkListener;)V", "issuesCountsSuffix", "", "getIssuesCountsSuffix", "()Ljava/lang/String;", "pageType", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "getPageType", "()Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "presentationIcon", "Ljavax/swing/Icon;", "getPresentationIcon", "()Ljavax/swing/Icon;", "timeSuffix", "getTimeSuffix", "buildChildren", "", "Lcom/intellij/ui/treeStructure/SimpleNode;", "()[Lcom/intellij/ui/treeStructure/SimpleNode;", "createComponent", "Lcom/android/build/attribution/ui/panels/AbstractBuildAttributionInfoPanel;", "intellij.android.build-attribution"})
final class PluginTasksRootNode
extends AbstractBuildAttributionNode {
    @Nullable
    private final Icon presentationIcon;
    @Nullable
    private final String issuesCountsSuffix;
    @Nullable
    private final String timeSuffix;
    @NotNull
    private final BuildAttributionUiEvent.Page.PageType pageType;
    private final CriticalPathPluginUiData pluginData;
    private final List<TimeDistributionChart.ChartDataItem<CriticalPathPluginUiData>> chartItems;
    private final TimeDistributionChart.ChartDataItem<CriticalPathPluginUiData> selectedChartItem;
    private final TreeLinkListener<TaskIssueUiData> issueClickListener;

    @Override
    @Nullable
    public Icon getPresentationIcon() {
        return this.presentationIcon;
    }

    @Override
    @Nullable
    public String getIssuesCountsSuffix() {
        return this.issuesCountsSuffix;
    }

    @Override
    @Nullable
    public String getTimeSuffix() {
        return this.timeSuffix;
    }

    @Override
    @NotNull
    public BuildAttributionUiEvent.Page.PageType getPageType() {
        return this.pageType;
    }

    @Override
    @NotNull
    public AbstractBuildAttributionInfoPanel createComponent() {
        return new ChartElementSelectedPanel(this, this.pluginData, this.chartItems, this.selectedChartItem){
            final /* synthetic */ PluginTasksRootNode this$0;

            @NotNull
            public JComponent createHeader() {
                return BuildAttributionPanelsKt.headerLabel("Tasks added by " + PluginTasksRootNode.access$getPluginData$p(this.this$0).getName() + " determining this build's duration");
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public JComponent createRightInfoPanel() {
                void $this$filterIsInstanceTo$iv$iv;
                JBPanel jBPanel = new JBPanel();
                boolean bl = false;
                boolean bl2 = false;
                JBPanel $this$apply = jBPanel;
                boolean bl3 = false;
                $this$apply.setLayout((LayoutManager)new VerticalLayout(5, 2));
                $this$apply.add((Component)new JBLabel("Total tasks duration: " + BuildAttributionUIUtilKt.durationString(PluginTasksRootNode.access$getPluginData$p(this.this$0).getCriticalPathDuration()) + " / " + BuildAttributionUIUtilKt.percentageString(PluginTasksRootNode.access$getPluginData$p(this.this$0).getCriticalPathDuration()) + " of all tasks execution time."));
                SimpleNode[] simpleNodeArray = this.this$0.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)simpleNodeArray, (String)"children");
                SimpleNode[] $this$filterIsInstance$iv = simpleNodeArray;
                boolean $i$f$filterIsInstance = false;
                SimpleNode[] simpleNodeArray2 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof PluginTaskNode)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    void $this$apply2;
                    PluginTaskNode it = (PluginTaskNode)element$iv;
                    boolean bl4 = false;
                    TimeWithPercentage time2 = it.getTaskData().getExecutionTime();
                    String name = it.getTaskData().getTaskPath();
                    HyperlinkLabel hyperlinkLabel = new HyperlinkLabel();
                    boolean bl5 = false;
                    boolean bl6 = false;
                    HyperlinkLabel hyperlinkLabel2 = hyperlinkLabel;
                    JBPanel jBPanel2 = $this$apply;
                    boolean bl7 = false;
                    $this$apply2.setHyperlinkText("", name, " (" + BuildAttributionUIUtilKt.durationString(time2) + " / " + BuildAttributionUIUtilKt.percentageString(time2) + ')');
                    $this$apply2.addHyperlinkListener(new HyperlinkListener(name, time2, it, $this$apply, this){
                        final /* synthetic */ String $name$inlined;
                        final /* synthetic */ TimeWithPercentage $time$inlined;
                        final /* synthetic */ PluginTaskNode $it$inlined;
                        final /* synthetic */ JBPanel $this_apply$inlined;
                        final /* synthetic */ createComponent.1 this$0;
                        {
                            this.$name$inlined = string;
                            this.$time$inlined = timeWithPercentage;
                            this.$it$inlined = pluginTaskNode;
                            this.$this_apply$inlined = jBPanel;
                            this.this$0 = var5_5;
                        }

                        public final void hyperlinkUpdate(HyperlinkEvent $noName_0) {
                            this.this$0.this$0.getNodeSelector().selectNode((SimpleNode)this.$it$inlined);
                        }
                    });
                    Unit unit = Unit.INSTANCE;
                    jBPanel2.add((Component)hyperlinkLabel);
                }
                return (JComponent)jBPanel;
            }

            @NotNull
            public JComponent createDescription() {
                HtmlBuilder descriptionText;
                String pluginDescriptionPrefix = PluginTasksRootNode.access$getPluginData$p(this.this$0).getCriticalPathTasks().getSize() == 1 ? "This task added by " + PluginTasksRootNode.access$getPluginData$p(this.this$0).getName() + " belongs" : "These " + PluginTasksRootNode.access$getPluginData$p(this.this$0).getCriticalPathTasks().getSize() + " tasks added by " + PluginTasksRootNode.access$getPluginData$p(this.this$0).getName() + " belong";
                HtmlBuilder htmlBuilder = descriptionText = new HtmlBuilder().openHtmlBody().add(pluginDescriptionPrefix + " to a group of sequentially executed tasks that has the largest impact on this build's duration.").newline().add("Addressing this group provides the greatest likelihood of reducing the overall build duration.").closeHtmlBody();
                Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"descriptionText");
                String string = htmlBuilder.getHtml();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptionText.html");
                return (JComponent)((Object)new DescriptionWithHelpLinkLabel(string, "https://developer.android.com/r/tools/build-attribution/critical-path", this.this$0.getAnalytics()));
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected SimpleNode[] buildChildren() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.pluginData.getCriticalPathTasks().getTasks();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void task2;
            TaskUiData taskUiData = (TaskUiData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            PluginTaskNode pluginTaskNode = new PluginTaskNode((TaskUiData)task2, this, this.issueClickListener);
            collection2.add(pluginTaskNode);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SimpleNode[] simpleNodeArray = thisCollection$iv.toArray(new SimpleNode[0]);
        if (simpleNodeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return simpleNodeArray;
    }

    public PluginTasksRootNode(@NotNull CriticalPathPluginUiData pluginData, @NotNull List<? extends TimeDistributionChart.ChartDataItem<CriticalPathPluginUiData>> chartItems, @NotNull TimeDistributionChart.ChartDataItem<CriticalPathPluginUiData> selectedChartItem, @NotNull PluginNode parent, @NotNull TreeLinkListener<TaskIssueUiData> issueClickListener2) {
        Intrinsics.checkNotNullParameter((Object)pluginData, (String)"pluginData");
        Intrinsics.checkNotNullParameter(chartItems, (String)"chartItems");
        Intrinsics.checkNotNullParameter(selectedChartItem, (String)"selectedChartItem");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(issueClickListener2, (String)"issueClickListener");
        super(parent, "Tasks determining this build's duration");
        this.pluginData = pluginData;
        this.chartItems = chartItems;
        this.selectedChartItem = selectedChartItem;
        this.issueClickListener = issueClickListener2;
        this.issuesCountsSuffix = BuildAttributionUIUtilKt.issuesCountString(this.pluginData.getCriticalPathTasks().getWarningCount(), this.pluginData.getCriticalPathTasks().getInfoCount());
        this.timeSuffix = BuildAttributionUIUtilKt.durationString(this.pluginData.getCriticalPathTasks().getCriticalPathDuration());
        this.pageType = BuildAttributionUiEvent.Page.PageType.PLUGIN_CRITICAL_PATH_TASKS_ROOT;
    }

    public static final /* synthetic */ CriticalPathPluginUiData access$getPluginData$p(PluginTasksRootNode $this) {
        return $this.pluginData;
    }
}

