/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb;

import com.android.ddmlib.Log;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbLogOutput {

    public static class ToStringLogger
    implements Log.ILogOutput {
        private final StringBuilder sb = new StringBuilder(100);

        public void printLog(@Nullable Log.LogLevel logLevel, @Nullable String tag, @Nullable String message2) {
            this.append(message2);
        }

        public void printAndPromptLog(@Nullable Log.LogLevel logLevel, @Nullable String tag, @Nullable String message2) {
            this.append(message2);
        }

        private void append(String message2) {
            if (!StringUtil.isEmpty((String)message2)) {
                this.sb.append(message2);
                this.sb.append('\n');
            }
        }

        @NotNull
        public String getOutput() {
            String string = this.sb.toString();
            if (string == null) {
                ToStringLogger.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/adb/AdbLogOutput$ToStringLogger", "getOutput"));
        }
    }

    public static class SystemLogRedirecter
    implements Log.ILogOutput {
        private static final NotificationGroup EVENT_LOG = NotificationGroup.logOnlyGroup((String)"ADB Logs");
        private static final Logger LOG = Logger.getInstance((String)"#com.android.ddmlib");

        public void printLog(@Nullable Log.LogLevel logLevel, @Nullable String tag, @Nullable String message2) {
            SystemLogRedirecter.reportAdbLog(logLevel, tag, message2);
        }

        public void printAndPromptLog(@Nullable Log.LogLevel logLevel, @Nullable String tag, @Nullable String message2) {
            SystemLogRedirecter.reportAdbLog(logLevel, tag, message2);
        }

        public static Logger getLogger() {
            return LOG;
        }

        private static void reportAdbLog(@Nullable Log.LogLevel logLevel, @Nullable String tag, @Nullable String message2) {
            if (StringUtil.isEmpty((String)message2)) {
                return;
            }
            if (logLevel == null) {
                logLevel = Log.LogLevel.DEBUG;
            }
            switch (logLevel) {
                case VERBOSE: 
                case DEBUG: {
                    LOG.debug(message2);
                    break;
                }
                case INFO: {
                    LOG.info(message2);
                    break;
                }
                case WARN: {
                    LOG.warn(message2);
                    break;
                }
                case ERROR: 
                case ASSERT: {
                    LOG.warn(message2);
                    EVENT_LOG.createNotification(message2, MessageType.WARNING).notify(null);
                }
            }
        }
    }
}

