/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.Density;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenRound;
import com.android.resources.ScreenSize;
import com.android.resources.TouchScreen;
import com.android.sdklib.devices.Multitouch;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.ScreenType;
import com.android.tools.idea.avdmanager.AvdDeviceData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AvdScreenData {
    private AvdDeviceData myDeviceData;

    public AvdScreenData(AvdDeviceData deviceData) {
        this.myDeviceData = deviceData;
    }

    public static double calculateDpi(double screenResolutionWidth, double screenResolutionHeight, double diagonalScreenSize, boolean isRound) {
        double diagonalPixelResolution = isRound ? screenResolutionWidth : Math.sqrt(Math.pow(screenResolutionWidth, 2.0) + Math.pow(screenResolutionHeight, 2.0));
        return diagonalPixelResolution / diagonalScreenSize;
    }

    @NotNull
    public static ScreenRatio getScreenRatio(int width, int height) {
        int shortSide;
        int longSide = Math.max(width, height);
        if ((double)longSide / (double)(shortSide = Math.min(width, height)) >= 1.6666666666666667) {
            ScreenRatio screenRatio = ScreenRatio.LONG;
            if (screenRatio == null) {
                AvdScreenData.$$$reportNull$$$0(0);
            }
            return screenRatio;
        }
        ScreenRatio screenRatio = ScreenRatio.NOTLONG;
        if (screenRatio == null) {
            AvdScreenData.$$$reportNull$$$0(1);
        }
        return screenRatio;
    }

    @NotNull
    public static Density getScreenDensity(@Nullable String deviceId, boolean isTv, double dpi, int screenHeight) {
        if (isTv) {
            Density density = screenHeight <= 720 ? Density.TV : Density.XHIGH;
            if (density == null) {
                AvdScreenData.$$$reportNull$$$0(2);
            }
            return density;
        }
        Density specialDensity = AvdScreenData.specialDeviceDensity(deviceId);
        if (specialDensity != null) {
            Density density = specialDensity;
            if (density == null) {
                AvdScreenData.$$$reportNull$$$0(3);
            }
            return density;
        }
        Density bucket = Density.MEDIUM;
        double minDifference = Double.MAX_VALUE;
        for (Density bucketDensity : Density.values()) {
            double difference;
            if (!bucketDensity.isValidValueForDevice() || !bucketDensity.isRecommended() || !((difference = Math.abs((double)bucketDensity.getDpiValue() - dpi)) < minDifference)) continue;
            minDifference = difference;
            bucket = bucketDensity;
        }
        Density density = bucket;
        if (density == null) {
            AvdScreenData.$$$reportNull$$$0(4);
        }
        return density;
    }

    @Nullable
    private static Density specialDeviceDensity(@Nullable String deviceId) {
        if ("Nexus 5X".equals(deviceId)) {
            return Density.DPI_420;
        }
        if ("Nexus 6".equals(deviceId)) {
            return Density.DPI_560;
        }
        if ("Nexus 6P".equals(deviceId)) {
            return Density.DPI_560;
        }
        if ("pixel".equals(deviceId)) {
            return Density.DPI_420;
        }
        if ("pixel_xl".equals(deviceId)) {
            return Density.DPI_560;
        }
        if ("pixel 2".equals(deviceId)) {
            return Density.DPI_420;
        }
        if ("pixel_2_xl".equals(deviceId)) {
            return Density.DPI_560;
        }
        return null;
    }

    @NotNull
    public Screen createScreen() {
        double screenDiagonal;
        Screen screen = new Screen();
        screen.setMultitouch(Multitouch.JAZZ_HANDS);
        screen.setMechanism(TouchScreen.FINGER);
        screen.setScreenType(ScreenType.CAPACITIVE);
        screen.setScreenRound((Boolean)this.myDeviceData.isScreenRound().get() != false ? ScreenRound.ROUND : ScreenRound.NOTROUND);
        int screenWidth = (Integer)this.myDeviceData.screenResolutionWidth().get();
        int screenHeight = (Integer)this.myDeviceData.screenResolutionHeight().get();
        double effectiveDiagonal = screenDiagonal = ((Double)this.myDeviceData.diagonalScreenSize().get()).doubleValue();
        if (((Boolean)this.myDeviceData.isScreenRound().get()).booleanValue()) {
            effectiveDiagonal *= Math.sqrt(2.0);
        }
        screen.setDiagonalLength(screenDiagonal);
        screen.setSize(ScreenSize.getScreenSize((Double)effectiveDiagonal));
        screen.setXDimension(screenWidth);
        screen.setYDimension(screenHeight);
        screen.setFoldedXOffset(((Integer)this.myDeviceData.screenFoldedXOffset().get()).intValue());
        screen.setFoldedYOffset(((Integer)this.myDeviceData.screenFoldedYOffset().get()).intValue());
        screen.setFoldedWidth(((Integer)this.myDeviceData.screenFoldedWidth().get()).intValue());
        screen.setFoldedHeight(((Integer)this.myDeviceData.screenFoldedHeight().get()).intValue());
        screen.setRatio(AvdScreenData.getScreenRatio(screenWidth, screenHeight));
        Double dpi = (Double)this.myDeviceData.screenDpi().get();
        if (dpi <= 0.0) {
            dpi = AvdScreenData.calculateDpi(screenWidth, screenHeight, screenDiagonal, (Boolean)this.myDeviceData.isScreenRound().get());
        }
        dpi = (double)Math.round(dpi * 100.0) / 100.0;
        screen.setYdpi(dpi.doubleValue());
        screen.setXdpi(dpi.doubleValue());
        screen.setPixelDensity(AvdScreenData.getScreenDensity((String)this.myDeviceData.deviceId().get(), (Boolean)this.myDeviceData.isTv().get(), dpi, screenHeight));
        Screen screen2 = screen;
        if (screen2 == null) {
            AvdScreenData.$$$reportNull$$$0(5);
        }
        return screen2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/idea/avdmanager/AvdScreenData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenRatio";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenDensity";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createScreen";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

