/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.analytics;

import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.common.analytics.CommonUsageTracker;
import com.android.tools.idea.common.analytics.DesignerAnalyticsManager$WhenMappings;
import com.android.tools.idea.common.surface.DesignSurface;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorState;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0015J\u0006\u0010\u001c\u001a\u00020\u0015J\u0006\u0010\u001d\u001a\u00020\u0015J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0004R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/common/analytics/DesignerAnalyticsManager;", "", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "layoutType", "Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Type;", "getLayoutType", "()Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Type;", "getSurface", "()Lcom/android/tools/idea/common/surface/DesignSurface;", "setSurface", "surfaceMode", "Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Mode;", "getSurfaceMode", "()Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Mode;", "surfaceType", "Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Surfaces;", "getSurfaceType", "()Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Surfaces;", "track", "", "type", "Lcom/google/wireless/android/sdk/stats/LayoutEditorEvent$LayoutEditorEventType;", "trackIssuePanel", "minimized", "", "trackSelectEditorMode", "trackShowIssuePanel", "trackUnknownEvent", "trackZoom", "Lcom/android/tools/adtui/actions/ZoomType;", "intellij.android.designer"})
public class DesignerAnalyticsManager {
    @NotNull
    private final LayoutEditorState.Surfaces surfaceType;
    @NotNull
    private final LayoutEditorState.Type layoutType;
    @NotNull
    private DesignSurface surface;

    @NotNull
    public LayoutEditorState.Surfaces getSurfaceType() {
        return this.surfaceType;
    }

    @NotNull
    public LayoutEditorState.Mode getSurfaceMode() {
        LayoutEditorState.Mode mode;
        switch (DesignerAnalyticsManager$WhenMappings.$EnumSwitchMapping$0[this.surface.getState().ordinal()]) {
            case 1: {
                mode = LayoutEditorState.Mode.DESIGN_MODE;
                break;
            }
            case 2: {
                mode = LayoutEditorState.Mode.PREVIEW_MODE;
                break;
            }
            case 3: {
                mode = LayoutEditorState.Mode.UNKOWN_MODE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return mode;
    }

    @NotNull
    public LayoutEditorState.Type getLayoutType() {
        return this.layoutType;
    }

    public final void trackShowIssuePanel() {
        this.track(LayoutEditorEvent.LayoutEditorEventType.SHOW_LINT_MESSAGES);
    }

    public final void trackUnknownEvent() {
        this.track(LayoutEditorEvent.LayoutEditorEventType.UNKNOWN_EVENT_TYPE);
    }

    public final void trackZoom(@NotNull ZoomType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        switch (DesignerAnalyticsManager$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.ZOOM_ACTUAL);
                break;
            }
            case 2: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.ZOOM_IN);
                break;
            }
            case 3: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.ZOOM_OUT);
                break;
            }
            case 4: 
            case 5: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.ZOOM_FIT);
                break;
            }
        }
    }

    public final void trackSelectEditorMode() {
        switch (DesignerAnalyticsManager$WhenMappings.$EnumSwitchMapping$2[this.surface.getState().ordinal()]) {
            case 1: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.SELECT_VISUAL_MODE);
                break;
            }
            case 2: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.SELECT_SPLIT_MODE);
                break;
            }
            case 3: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.SELECT_TEXT_MODE);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void trackIssuePanel(boolean minimized) {
        if (minimized) {
            this.track(LayoutEditorEvent.LayoutEditorEventType.MINIMIZE_ERROR_PANEL);
        } else {
            this.track(LayoutEditorEvent.LayoutEditorEventType.RESTORE_ERROR_PANEL);
        }
    }

    protected final void track(@NotNull LayoutEditorEvent.LayoutEditorEventType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        CommonUsageTracker.Companion.getInstance(this.surface).logAction(type);
    }

    @NotNull
    protected final DesignSurface getSurface() {
        return this.surface;
    }

    protected final void setSurface(@NotNull DesignSurface designSurface) {
        Intrinsics.checkNotNullParameter((Object)((Object)designSurface), (String)"<set-?>");
        this.surface = designSurface;
    }

    public DesignerAnalyticsManager(@NotNull DesignSurface surface2) {
        Intrinsics.checkNotNullParameter((Object)((Object)surface2), (String)"surface");
        this.surface = surface2;
        this.surfaceType = LayoutEditorState.Surfaces.UNKNOWN_SURFACES;
        this.layoutType = LayoutEditorState.Type.UNKNOWN_TYPE;
    }
}

