/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.analytics;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.idea.common.property.NlProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidAttribute;
import com.google.wireless.android.sdk.stats.AndroidView;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UsageTrackerUtil {
    @VisibleForTesting
    public static final String CUSTOM_NAME = "CUSTOM";

    private UsageTrackerUtil() {
    }

    @NotNull
    public static AndroidAttribute convertAttribute(@NotNull NlProperty property2) {
        if (property2 == null) {
            UsageTrackerUtil.$$$reportNull$$$0(0);
        }
        AndroidFacet facet2 = property2.getModel().getFacet();
        AttributeDefinition definition = property2.getDefinition();
        String libraryName = definition != null ? definition.getLibraryName() : null;
        AndroidAttribute.AttributeNamespace namespace = UsageTrackerUtil.convertNamespace(property2.getNamespace());
        AndroidAttribute androidAttribute = AndroidAttribute.newBuilder().setAttributeName(UsageTrackerUtil.convertAttributeName(property2.getName(), namespace, libraryName, facet2)).setAttributeNamespace(namespace).build();
        if (androidAttribute == null) {
            UsageTrackerUtil.$$$reportNull$$$0(1);
        }
        return androidAttribute;
    }

    @NotNull
    public static AndroidAttribute convertAttribute(@NotNull String attributeName, @NotNull AndroidFacet facet2) {
        if (attributeName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(2);
        }
        if (facet2 == null) {
            UsageTrackerUtil.$$$reportNull$$$0(3);
        }
        AndroidAttribute.AttributeNamespace namespace = null;
        if (attributeName.startsWith("tools:")) {
            namespace = AndroidAttribute.AttributeNamespace.TOOLS;
            attributeName = StringUtil.trimStart((String)attributeName, (String)"tools:");
        }
        NamespaceAndLibraryNamePair lookup = UsageTrackerUtil.lookupAttributeResource(facet2, attributeName);
        if (namespace == null) {
            namespace = lookup.getNamespace();
        }
        AndroidAttribute androidAttribute = AndroidAttribute.newBuilder().setAttributeName(UsageTrackerUtil.convertAttributeName(attributeName, lookup.getNamespace(), lookup.getLibraryName(), facet2)).setAttributeNamespace(namespace).build();
        if (androidAttribute == null) {
            UsageTrackerUtil.$$$reportNull$$$0(4);
        }
        return androidAttribute;
    }

    @NotNull
    public static AndroidAttribute.AttributeNamespace convertNamespace(@Nullable String namespace) {
        if (StringUtil.isEmpty((String)namespace)) {
            AndroidAttribute.AttributeNamespace attributeNamespace = AndroidAttribute.AttributeNamespace.ANDROID;
            if (attributeNamespace == null) {
                UsageTrackerUtil.$$$reportNull$$$0(5);
            }
            return attributeNamespace;
        }
        switch (namespace) {
            case "http://schemas.android.com/tools": {
                AndroidAttribute.AttributeNamespace attributeNamespace = AndroidAttribute.AttributeNamespace.TOOLS;
                if (attributeNamespace == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(6);
                }
                return attributeNamespace;
            }
            case "http://schemas.android.com/apk/res/android": {
                AndroidAttribute.AttributeNamespace attributeNamespace = AndroidAttribute.AttributeNamespace.ANDROID;
                if (attributeNamespace == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(7);
                }
                return attributeNamespace;
            }
        }
        AndroidAttribute.AttributeNamespace attributeNamespace = AndroidAttribute.AttributeNamespace.APPLICATION;
        if (attributeNamespace == null) {
            UsageTrackerUtil.$$$reportNull$$$0(8);
        }
        return attributeNamespace;
    }

    @NotNull
    public static String convertAttributeName(@NotNull String attributeName, @NotNull AndroidAttribute.AttributeNamespace namespace, @Nullable String libraryName, @NotNull AndroidFacet facet2) {
        if (attributeName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(9);
        }
        if (namespace == null) {
            UsageTrackerUtil.$$$reportNull$$$0(10);
        }
        if (facet2 == null) {
            UsageTrackerUtil.$$$reportNull$$$0(11);
        }
        switch (namespace) {
            case ANDROID: {
                String string = attributeName;
                if (string == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(12);
                }
                return string;
            }
            case APPLICATION: {
                return libraryName != null && UsageTrackerUtil.acceptedGoogleLibraryNamespace(libraryName) ? attributeName : CUSTOM_NAME;
            }
            case TOOLS: {
                NamespaceAndLibraryNamePair lookup = UsageTrackerUtil.lookupAttributeResource(facet2, attributeName);
                assert (lookup.getNamespace() != AndroidAttribute.AttributeNamespace.TOOLS);
                return UsageTrackerUtil.convertAttributeName(attributeName, lookup.getNamespace(), lookup.getLibraryName(), facet2);
            }
        }
        return CUSTOM_NAME;
    }

    @NotNull
    public static AndroidView convertTagName(@NotNull String tagName) {
        if (tagName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(13);
        }
        tagName = UsageTrackerUtil.acceptedGoogleTagNamespace(tagName) ? StringUtil.getShortName((String)tagName, (char)'.') : CUSTOM_NAME;
        AndroidView androidView = AndroidView.newBuilder().setTagName(tagName).build();
        if (androidView == null) {
            UsageTrackerUtil.$$$reportNull$$$0(14);
        }
        return androidView;
    }

    @VisibleForTesting
    static boolean acceptedGoogleLibraryNamespace(@NotNull String libraryName) {
        if (libraryName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(15);
        }
        return libraryName.startsWith("com.android.") || libraryName.startsWith("com.google.") || libraryName.startsWith("constraint-layout") || libraryName.startsWith("flexbox") || libraryName.startsWith("design-") || libraryName.startsWith("appcompat-v7-") || libraryName.startsWith("cardview-v7-") || libraryName.startsWith("gridlayout-v7") || libraryName.startsWith("recyclerview-v7") || libraryName.startsWith("coordinatorlayout-v7") || libraryName.startsWith("play-services-maps-") || libraryName.startsWith("play-services-ads-") || libraryName.startsWith("leanback-v17-");
    }

    @VisibleForTesting
    static boolean acceptedGoogleTagNamespace(@NotNull String fullyQualifiedTagName) {
        if (fullyQualifiedTagName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(16);
        }
        return fullyQualifiedTagName.indexOf(46) < 0 || fullyQualifiedTagName.startsWith("com.android.") || fullyQualifiedTagName.startsWith("com.google.") || fullyQualifiedTagName.startsWith("android.support.") || fullyQualifiedTagName.startsWith("android.databinding.");
    }

    @NotNull
    @VisibleForTesting
    static NamespaceAndLibraryNamePair lookupAttributeResource(@NotNull AndroidFacet facet2, @NotNull String attributeName) {
        ModuleResourceManagers resourceManagers;
        FrameworkResourceManager frameworkResourceManager;
        if (facet2 == null) {
            UsageTrackerUtil.$$$reportNull$$$0(17);
        }
        if (attributeName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(18);
        }
        if ((frameworkResourceManager = (resourceManagers = ModuleResourceManagers.getInstance(facet2)).getFrameworkResourceManager()) == null) {
            return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION);
        }
        LocalResourceManager localResourceManager = resourceManagers.getLocalResourceManager();
        AttributeDefinitions localAttributeDefinitions = ((ResourceManager)localResourceManager).getAttributeDefinitions();
        AttributeDefinitions systemAttributeDefinitions = ((ResourceManager)frameworkResourceManager).getAttributeDefinitions();
        if (systemAttributeDefinitions != null && systemAttributeDefinitions.getAttrs().contains(ResourceReference.attr((ResourceNamespace)ResourceNamespace.ANDROID, (String)attributeName))) {
            return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.ANDROID);
        }
        if (localAttributeDefinitions == null) {
            return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION);
        }
        AttributeDefinition definition = localAttributeDefinitions.getAttrDefinition(ResourceReference.attr((ResourceNamespace)ResourceNamespace.TODO(), (String)attributeName));
        if (definition == null) {
            return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION);
        }
        return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION, definition.getLibraryName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/analytics/UsageTrackerUtil";
                break;
            }
            case 2: 
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 3: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullyQualifiedTagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/analytics/UsageTrackerUtil";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAttribute";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertNamespace";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAttributeName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "convertTagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertAttribute";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertAttributeName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertTagName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "acceptedGoogleLibraryNamespace";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "acceptedGoogleTagNamespace";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lookupAttributeResource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class NamespaceAndLibraryNamePair {
        private final AndroidAttribute.AttributeNamespace myNamespace;
        private final String myLibraryName;

        @VisibleForTesting
        NamespaceAndLibraryNamePair(@NotNull AndroidAttribute.AttributeNamespace namespace) {
            if (namespace == null) {
                NamespaceAndLibraryNamePair.$$$reportNull$$$0(0);
            }
            this(namespace, null);
        }

        @VisibleForTesting
        NamespaceAndLibraryNamePair(@NotNull AndroidAttribute.AttributeNamespace namespace, @Nullable String libraryName) {
            if (namespace == null) {
                NamespaceAndLibraryNamePair.$$$reportNull$$$0(1);
            }
            this.myNamespace = namespace;
            this.myLibraryName = libraryName;
        }

        @NotNull
        public AndroidAttribute.AttributeNamespace getNamespace() {
            AndroidAttribute.AttributeNamespace attributeNamespace = this.myNamespace;
            if (attributeNamespace == null) {
                NamespaceAndLibraryNamePair.$$$reportNull$$$0(2);
            }
            return attributeNamespace;
        }

        @Nullable
        public String getLibraryName() {
            return this.myLibraryName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/common/analytics/UsageTrackerUtil$NamespaceAndLibraryNamePair";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/common/analytics/UsageTrackerUtil$NamespaceAndLibraryNamePair";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

