/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.scene.target.TargetHelper;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SceneHitListener {
    @NotNull
    private SelectionModel mySelectionModel;
    private ScenePicker myPicker;
    double myClosestComponentDistance;
    double myClosestTargetDistance;
    ArrayList<SceneComponent> myHitComponents;
    @NotNull
    final ArrayList<Target> myHitTargets;
    private Predicate<Target> myTargertFilter;

    public SceneHitListener(@NotNull SelectionModel selectionModel) {
        if (selectionModel == null) {
            SceneHitListener.$$$reportNull$$$0(0);
        }
        this.myPicker = new ScenePicker();
        this.myClosestComponentDistance = Double.MAX_VALUE;
        this.myClosestTargetDistance = Double.MAX_VALUE;
        this.myHitComponents = new ArrayList();
        this.myHitTargets = new ArrayList();
        this.myTargertFilter = it -> true;
        this.mySelectionModel = selectionModel;
        this.myPicker.setSelectListener((a, b) -> this.over(a, b));
    }

    public void setTargetFilter(@Nullable Predicate<Target> filter2) {
        this.myTargertFilter = filter2 != null ? filter2 : it -> true;
    }

    public void find(@NotNull SceneContext transform, @NotNull SceneComponent root2, int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        if (transform == null) {
            SceneHitListener.$$$reportNull$$$0(1);
        }
        if (root2 == null) {
            SceneHitListener.$$$reportNull$$$0(2);
        }
        this.myHitComponents.clear();
        this.myHitTargets.clear();
        this.myClosestComponentDistance = Double.MAX_VALUE;
        this.myClosestTargetDistance = Double.MAX_VALUE;
        this.myPicker.reset();
        root2.addHit(transform, this.myPicker, modifiersEx);
        this.myPicker.find(transform.getSwingXDip(x), transform.getSwingYDip(y));
    }

    public void over(Object over, double dist) {
        if (over instanceof Target) {
            if (!this.myTargertFilter.test((Target)over)) {
                return;
            }
            Target target = (Target)over;
            if (dist < this.myClosestTargetDistance) {
                this.myHitTargets.clear();
                this.myHitTargets.add(target);
                this.myClosestTargetDistance = dist;
            } else if (dist == this.myClosestTargetDistance) {
                this.myHitTargets.add(target);
            }
        } else if (over instanceof SceneComponent) {
            SceneComponent component3 = (SceneComponent)over;
            if (dist < this.myClosestComponentDistance) {
                this.myHitComponents.clear();
                this.myHitComponents.add(component3);
                this.myClosestComponentDistance = dist;
            } else if (dist == this.myClosestComponentDistance) {
                this.myHitComponents.add(component3);
            }
        }
    }

    public Target getClosestTarget(@JdkConstants.InputEventMask int modifiersEx) {
        Target candidate;
        int count = this.myHitTargets.size();
        if (count == 0) {
            return null;
        }
        ImmutableList<NlComponent> selection = this.mySelectionModel.getSelection();
        if ((modifiersEx & 0x200) != 0) {
            candidate = null;
            for (int i2 = count - 1; i2 >= 0; --i2) {
                Target target = this.myHitTargets.get(i2);
                if (!selection.contains(target.getComponent().getNlComponent()) || candidate != null && !TargetHelper.isAbove(target, candidate)) continue;
                candidate = target;
            }
            if (candidate != null) {
                return candidate;
            }
        }
        candidate = this.myHitTargets.get(count - 1);
        boolean inSelection = SceneHitListener.parentInSelection(candidate.getComponent(), selection);
        for (int i3 = count - 2; i3 >= 0; --i3) {
            Target target = this.myHitTargets.get(i3);
            boolean targetParentInSelection = SceneHitListener.parentInSelection(target.getComponent(), selection);
            if (inSelection && !targetParentInSelection || (inSelection || !targetParentInSelection) && !TargetHelper.isAbove(target, candidate)) continue;
            candidate = target;
            inSelection = targetParentInSelection;
        }
        return candidate;
    }

    @Nullable
    public Target getFilteredTarget(Target filteredTarget) {
        Target hit = null;
        boolean found = false;
        for (Target target : this.myHitTargets) {
            if (target == filteredTarget) {
                found = true;
                continue;
            }
            if (!filteredTarget.getClass().isAssignableFrom(target.getClass())) continue;
            hit = target;
        }
        if (hit == null && found) {
            hit = filteredTarget;
        }
        return hit;
    }

    @NotNull
    public ImmutableList<Target> getHitTargets() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myHitTargets);
        if (immutableList == null) {
            SceneHitListener.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    public SceneComponent getClosestComponent() {
        int count = this.myHitComponents.size();
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            return this.myHitComponents.get(0);
        }
        ImmutableList<NlComponent> selection = this.mySelectionModel.getSelection();
        if (selection.isEmpty()) {
            return this.myHitComponents.get(count - 1);
        }
        SceneComponent candidate = this.myHitComponents.get(count - 1);
        boolean inSelection = selection.contains(candidate.getNlComponent());
        if (inSelection) {
            return candidate;
        }
        for (int i2 = count - 1; i2 >= 0; --i2) {
            SceneComponent target = this.myHitComponents.get(i2);
            if (!SceneHitListener.parentInSelection(target, selection)) continue;
            return target;
        }
        return candidate;
    }

    public SceneComponent getTopHitComponent() {
        int count = this.myHitComponents.size();
        if (count == 0) {
            return null;
        }
        return this.myHitComponents.get(count - 1);
    }

    public ArrayList<SceneComponent> getHitComponents() {
        return this.myHitComponents;
    }

    private static boolean parentInSelection(@NotNull SceneComponent component3, @NotNull List<NlComponent> selection) {
        if (component3 == null) {
            SceneHitListener.$$$reportNull$$$0(4);
        }
        if (selection == null) {
            SceneHitListener.$$$reportNull$$$0(5);
        }
        if (selection.isEmpty()) {
            return false;
        }
        while (component3 != null) {
            if (selection.contains(component3.getNlComponent())) {
                return true;
            }
            component3 = component3.getParent();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/scene/SceneHitListener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/scene/SceneHitListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHitTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parentInSelection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

