/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.util;

import com.android.tools.idea.databinding.DataBindingMode;
import com.android.tools.idea.databinding.LayoutBindingSupport;
import com.android.tools.idea.databinding.index.BindingXmlData;
import com.android.tools.idea.databinding.index.BindingXmlIndex;
import com.android.tools.idea.databinding.index.ImportData;
import com.android.tools.idea.lang.databinding.DataBindingExpressionSupport;
import com.android.tools.idea.lang.databinding.DataBindingExpressionUtil;
import com.android.tools.idea.model.MergedManifestManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.List;
import org.jetbrains.android.dom.layout.Import;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataBindingUtil {
    public static final String BR = "BR";

    @NotNull
    private static Logger getLog() {
        Logger logger2 = Logger.getInstance(DataBindingUtil.class);
        if (logger2 == null) {
            DataBindingUtil.$$$reportNull$$$0(0);
        }
        return logger2;
    }

    @Nullable
    private static LayoutBindingSupport getBindingSupport() {
        List extensionList = LayoutBindingSupport.EP_NAME.getExtensionList();
        return extensionList.isEmpty() ? null : (LayoutBindingSupport)extensionList.get(0);
    }

    public static boolean isDataBindingEnabled(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            DataBindingUtil.$$$reportNull$$$0(1);
        }
        return DataBindingUtil.getDataBindingMode(facet2) != DataBindingMode.NONE;
    }

    @NotNull
    public static DataBindingMode getDataBindingMode(@NotNull AndroidFacet facet2) {
        LayoutBindingSupport support;
        if (facet2 == null) {
            DataBindingUtil.$$$reportNull$$$0(2);
        }
        DataBindingMode dataBindingMode = (support = DataBindingUtil.getBindingSupport()) == null ? DataBindingMode.NONE : support.getDataBindingMode(facet2);
        if (dataBindingMode == null) {
            DataBindingUtil.$$$reportNull$$$0(3);
        }
        return dataBindingMode;
    }

    @NotNull
    public static ModificationTracker getDataBindingEnabledTracker() {
        LayoutBindingSupport support = DataBindingUtil.getBindingSupport();
        ModificationTracker modificationTracker = support == null ? () -> 0L : support.getDataBindingEnabledTracker();
        if (modificationTracker == null) {
            DataBindingUtil.$$$reportNull$$$0(4);
        }
        return modificationTracker;
    }

    @Nullable
    public static String getQualifiedBindingName(@NotNull AndroidFacet facet2, @NotNull BindingXmlIndex.Entry bindingIndexEntry) {
        String modulePackage;
        if (facet2 == null) {
            DataBindingUtil.$$$reportNull$$$0(5);
        }
        if (bindingIndexEntry == null) {
            DataBindingUtil.$$$reportNull$$$0(6);
        }
        if ((modulePackage = MergedManifestManager.getSnapshot(facet2).getPackage()) == null) {
            return null;
        }
        String customBindingName = bindingIndexEntry.getData().getCustomBindingName();
        if (customBindingName == null || customBindingName.isEmpty()) {
            return modulePackage + ".databinding." + DataBindingUtil.convertToJavaClassName(bindingIndexEntry.getFile().getName()) + "Binding";
        }
        int firstDotIndex = customBindingName.indexOf(46);
        if (firstDotIndex < 0) {
            return modulePackage + ".databinding." + customBindingName;
        }
        int lastDotIndex = customBindingName.lastIndexOf(46);
        Object packageName = firstDotIndex == 0 ? modulePackage + customBindingName.substring(0, lastDotIndex) : customBindingName.substring(0, lastDotIndex);
        String simpleClassName = customBindingName.substring(lastDotIndex + 1);
        return (String)packageName + "." + simpleClassName;
    }

    @NotNull
    public static String convertToJavaClassName(@NotNull String name) {
        int dotIndex;
        if (name == null) {
            DataBindingUtil.$$$reportNull$$$0(7);
        }
        if ((dotIndex = name.indexOf(46)) >= 0) {
            name = name.substring(0, dotIndex);
        }
        String[] split = name.split("[_-]");
        StringBuilder out = new StringBuilder();
        for (String section : split) {
            out.append(StringUtil.capitalize((String)section));
        }
        String string = out.toString();
        if (string == null) {
            DataBindingUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String convertToJavaFieldName(@NotNull String name) {
        int dotIndex;
        if (name == null) {
            DataBindingUtil.$$$reportNull$$$0(9);
        }
        if ((dotIndex = name.indexOf(46)) >= 0) {
            name = name.substring(0, dotIndex);
        }
        String[] split = name.split("[_-]");
        StringBuilder out = new StringBuilder();
        boolean first = true;
        for (String section : split) {
            if (first) {
                first = false;
                out.append(section);
                continue;
            }
            out.append(StringUtil.capitalize((String)section));
        }
        String string = out.toString();
        if (string == null) {
            DataBindingUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static boolean isGetter(@NotNull PsiMethod psiMethod) {
        PsiType returnType;
        if (psiMethod == null) {
            DataBindingUtil.$$$reportNull$$$0(11);
        }
        if ((returnType = psiMethod.getReturnType()) == null) {
            return false;
        }
        return !returnType.equals(PsiType.VOID) && psiMethod.getParameterList().getParametersCount() == 0 && DataBindingUtil.isPrefixedJavaIdentifier(psiMethod.getName(), "get");
    }

    public static boolean isBooleanGetter(@NotNull PsiMethod psiMethod) {
        PsiType returnType;
        if (psiMethod == null) {
            DataBindingUtil.$$$reportNull$$$0(12);
        }
        if ((returnType = psiMethod.getReturnType()) == null) {
            return false;
        }
        return returnType.equals(PsiType.BOOLEAN) && psiMethod.getParameterList().getParametersCount() == 0 && DataBindingUtil.isPrefixedJavaIdentifier(psiMethod.getName(), "is");
    }

    public static boolean isSetter(@NotNull PsiMethod psiMethod) {
        PsiType returnType;
        if (psiMethod == null) {
            DataBindingUtil.$$$reportNull$$$0(13);
        }
        if ((returnType = psiMethod.getReturnType()) == null) {
            return false;
        }
        return returnType.equals(PsiType.VOID) && psiMethod.getParameterList().getParametersCount() == 1 && DataBindingUtil.isPrefixedJavaIdentifier(psiMethod.getName(), "set");
    }

    private static boolean isPrefixedJavaIdentifier(@NotNull String name, @NotNull String prefix) {
        if (name == null) {
            DataBindingUtil.$$$reportNull$$$0(14);
        }
        if (prefix == null) {
            DataBindingUtil.$$$reportNull$$$0(15);
        }
        return DataBindingUtil.isPrefix(name, prefix) && Character.isJavaIdentifierStart(name.charAt(prefix.length()));
    }

    @NotNull
    public static String stripPrefixFromMethod(@NotNull PsiMethod method) {
        if (method == null) {
            DataBindingUtil.$$$reportNull$$$0(16);
        }
        String methodName = method.getName();
        if (DataBindingUtil.isGetter(method)) {
            String string = StringUtil.decapitalize((String)methodName.substring("get".length()));
            if (string == null) {
                DataBindingUtil.$$$reportNull$$$0(17);
            }
            return string;
        }
        if (DataBindingUtil.isBooleanGetter(method)) {
            String string = StringUtil.decapitalize((String)methodName.substring("is".length()));
            if (string == null) {
                DataBindingUtil.$$$reportNull$$$0(18);
            }
            return string;
        }
        if (DataBindingUtil.isSetter(method)) {
            String string = StringUtil.decapitalize((String)methodName.substring("set".length()));
            if (string == null) {
                DataBindingUtil.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = methodName;
        if (string == null) {
            DataBindingUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String stripPrefixFromField(@NotNull PsiField psiField) {
        if (psiField == null) {
            DataBindingUtil.$$$reportNull$$$0(21);
        }
        String fieldName = psiField.getName();
        assert (fieldName != null);
        return DataBindingUtil.stripPrefixFromField(fieldName);
    }

    private static boolean isPrefix(@NotNull CharSequence sequence, @NotNull String prefix) {
        if (sequence == null) {
            DataBindingUtil.$$$reportNull$$$0(22);
        }
        if (prefix == null) {
            DataBindingUtil.$$$reportNull$$$0(23);
        }
        boolean prefixes = false;
        if (sequence.length() > prefix.length()) {
            int count = prefix.length();
            prefixes = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (sequence.charAt(i2) == prefix.charAt(i2)) continue;
                prefixes = false;
                break;
            }
        }
        return prefixes;
    }

    @NotNull
    private static String stripPrefixFromField(@NotNull String name) {
        if (name == null) {
            DataBindingUtil.$$$reportNull$$$0(24);
        }
        if (name.length() >= 2) {
            char firstChar = name.charAt(0);
            char secondChar = name.charAt(1);
            if (name.length() > 2 && firstChar == 'm' && secondChar == '_') {
                char thirdChar = name.charAt(2);
                if (Character.isJavaIdentifierStart(thirdChar)) {
                    String string = String.valueOf(Character.toLowerCase(thirdChar)) + name.subSequence(3, name.length());
                    if (string == null) {
                        DataBindingUtil.$$$reportNull$$$0(25);
                    }
                    return string;
                }
            } else if (firstChar == 'm' && Character.isUpperCase(secondChar) || firstChar == '_' && Character.isJavaIdentifierStart(secondChar)) {
                String string = String.valueOf(Character.toLowerCase(secondChar)) + name.subSequence(2, name.length());
                if (string == null) {
                    DataBindingUtil.$$$reportNull$$$0(26);
                }
                return string;
            }
        }
        String string = name;
        if (string == null) {
            DataBindingUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Nullable
    public static String getBrQualifiedName(@NotNull AndroidFacet facet2) {
        String packageName;
        if (facet2 == null) {
            DataBindingUtil.$$$reportNull$$$0(28);
        }
        return (packageName = DataBindingUtil.getGeneratedPackageName(facet2)) == null ? null : packageName + ".BR";
    }

    @Nullable
    public static String getGeneratedPackageName(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            DataBindingUtil.$$$reportNull$$$0(29);
        }
        return MergedManifestManager.getSnapshot(facet2).getPackage();
    }

    @Nullable
    public static String getBindingExprDefault(@NotNull XmlAttribute psiAttribute) {
        DataBindingExpressionSupport expressionSupport;
        if (psiAttribute == null) {
            DataBindingUtil.$$$reportNull$$$0(30);
        }
        if ((expressionSupport = DataBindingExpressionUtil.getDataBindingExpressionSupport()) != null) {
            return expressionSupport.getBindingExprDefault(psiAttribute);
        }
        return null;
    }

    @Nullable
    public static String getBindingExprDefault(@NotNull String expression) {
        DataBindingExpressionSupport expressionSupport;
        if (expression == null) {
            DataBindingUtil.$$$reportNull$$$0(31);
        }
        if ((expressionSupport = DataBindingExpressionUtil.getDataBindingExpressionSupport()) != null) {
            return expressionSupport.getBindingExprDefault(expression);
        }
        return null;
    }

    public static boolean isBindingExpression(@NotNull String string) {
        if (string == null) {
            DataBindingUtil.$$$reportNull$$$0(32);
        }
        return string.startsWith("@{") || string.startsWith("@={");
    }

    public static boolean isTwoWayBindingExpression(@NotNull String string) {
        if (string == null) {
            DataBindingUtil.$$$reportNull$$$0(33);
        }
        return string.startsWith("@={");
    }

    @Nullable
    public static String getAlias(@NotNull Import anImport) {
        XmlAttributeValue value2;
        GenericAttributeValue<PsiElement> type;
        if (anImport == null) {
            DataBindingUtil.$$$reportNull$$$0(34);
        }
        String aliasValue = null;
        String typeValue = null;
        GenericAttributeValue<String> alias = anImport.getAlias();
        if (alias != null && alias.getXmlAttributeValue() != null) {
            aliasValue = alias.getXmlAttributeValue().getValue();
        }
        if ((type = anImport.getType()) != null && (value2 = type.getXmlAttributeValue()) != null) {
            typeValue = value2.getValue();
        }
        return DataBindingUtil.getAlias(typeValue, aliasValue);
    }

    @Nullable
    private static String getAlias(@Nullable String type, @Nullable String alias) {
        if (alias != null || type == null) {
            return alias;
        }
        int i2 = type.lastIndexOf(46);
        int d = type.lastIndexOf(36);
        if ((i2 = Math.max(i2, d)) < 0) {
            return type;
        }
        return type.length() > i2 + 1 ? type.substring(i2 + 1) : null;
    }

    @Nullable
    public static String getQualifiedType(@NotNull Project project, final @NotNull String nameOrAlias, final @NotNull BindingXmlData bindingData, final boolean qualifyJavaLang) {
        class UnresolvedClassNameException
        extends RuntimeException {
            UnresolvedClassNameException() {
            }
        }
        PsiType psiType;
        if (project == null) {
            DataBindingUtil.$$$reportNull$$$0(35);
        }
        if (nameOrAlias == null) {
            DataBindingUtil.$$$reportNull$$$0(36);
        }
        if (bindingData == null) {
            DataBindingUtil.$$$reportNull$$$0(37);
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        final PsiJavaParserFacade parser = psiFacade.getParserFacade();
        try {
            psiType = parser.createTypeFromText(nameOrAlias, null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        if (psiType instanceof PsiPrimitiveType) {
            return nameOrAlias;
        }
        final StringBuilder result2 = new StringBuilder();
        final int[] offset = new int[1];
        try {
            psiType.accept((PsiTypeVisitor)new ClassReferenceVisitor(){

                @Override
                public void visitClassReference(@NotNull PsiClassReferenceType classReference) {
                    String className;
                    if (classReference == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PsiJavaCodeReferenceElement reference2 = classReference.getReference();
                    int nameOffset = reference2.getTextRange().getStartOffset();
                    while (offset[0] < nameOffset) {
                        int n = offset[0];
                        offset[0] = n + 1;
                        result2.append(nameOrAlias.charAt(n));
                    }
                    String string = className = reference2.isQualified() ? reference2.getQualifiedName() : reference2.getReferenceName();
                    if (className != null) {
                        int nameLength = className.length();
                        className = DataBindingUtil.resolveImport(className, bindingData);
                        if (qualifyJavaLang && className.indexOf(46) < 0 && (className = DataBindingUtil.qualifyClassName(className, parser)) == null) {
                            throw new UnresolvedClassNameException();
                        }
                        result2.append(className);
                        offset[0] = offset[0] + nameLength;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classReference", "com/android/tools/idea/databinding/util/DataBindingUtil$1", "visitClassReference"));
                }
            });
        }
        catch (UnresolvedClassNameException e) {
            return null;
        }
        while (offset[0] < nameOrAlias.length()) {
            int n = offset[0];
            offset[0] = n + 1;
            result2.append(nameOrAlias.charAt(n));
        }
        return result2.toString();
    }

    @Nullable
    private static String qualifyClassName(@NotNull String className, @NotNull PsiJavaParserFacade parser) {
        PsiType psiType;
        if (className == null) {
            DataBindingUtil.$$$reportNull$$$0(38);
        }
        if (parser == null) {
            DataBindingUtil.$$$reportNull$$$0(39);
        }
        if ((psiType = parser.createTypeFromText(className, null)) instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            if (psiClass == null) {
                return null;
            }
            String name = psiClass.getQualifiedName();
            if (name != null) {
                return name;
            }
        }
        return className;
    }

    @NotNull
    public static String resolveImport(@NotNull String className, @NotNull BindingXmlData bindingData) {
        String importedType;
        int dotOffset;
        if (className == null) {
            DataBindingUtil.$$$reportNull$$$0(40);
        }
        if (bindingData == null) {
            DataBindingUtil.$$$reportNull$$$0(41);
        }
        String firstSegment = (dotOffset = className.indexOf(46)) >= 0 ? className.substring(0, dotOffset) : className;
        ImportData anImport = bindingData.findImport(firstSegment);
        String string = importedType = anImport != null ? anImport.getType() : null;
        if (importedType == null) {
            String string2 = className;
            if (string2 == null) {
                DataBindingUtil.$$$reportNull$$$0(42);
            }
            return string2;
        }
        Object object = dotOffset >= 0 ? importedType + className.substring(dotOffset) : importedType;
        if (object == null) {
            DataBindingUtil.$$$reportNull$$$0(43);
        }
        return object;
    }

    @Nullable
    public static XmlFile findXmlFile(@NotNull Project project, @NotNull VirtualFile layoutFile) {
        if (project == null) {
            DataBindingUtil.$$$reportNull$$$0(44);
        }
        if (layoutFile == null) {
            DataBindingUtil.$$$reportNull$$$0(45);
        }
        if (!layoutFile.isValid()) {
            DataBindingUtil.getLog().info("findXmlFile aborted for invalid file: " + layoutFile);
            return null;
        }
        return (XmlFile)PsiManager.getInstance((Project)project).findFile(layoutFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/databinding/util/DataBindingUtil";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingIndexEntry";
                break;
            }
            case 7: 
            case 9: 
            case 14: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAttribute";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anImport";
                break;
            }
            case 35: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameOrAlias";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingData";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/databinding/util/DataBindingUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataBindingMode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataBindingEnabledTracker";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToJavaClassName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToJavaFieldName";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "stripPrefixFromMethod";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "stripPrefixFromField";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveImport";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDataBindingEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDataBindingMode";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedBindingName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertToJavaClassName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertToJavaFieldName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isGetter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanGetter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSetter";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isPrefixedJavaIdentifier";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "stripPrefixFromMethod";
                break;
            }
            case 21: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "stripPrefixFromField";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isPrefix";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getBrQualifiedName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratedPackageName";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getBindingExprDefault";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isBindingExpression";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isTwoWayBindingExpression";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAlias";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedType";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "qualifyClassName";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "resolveImport";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findXmlFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class ClassReferenceVisitor
    extends PsiTypeVisitor<Void> {
        @Nullable
        public final Void visitClassType(@NotNull PsiClassType classType) {
            PsiType[] parameters2;
            if (classType == null) {
                ClassReferenceVisitor.$$$reportNull$$$0(0);
            }
            if (classType instanceof PsiClassReferenceType) {
                this.visitClassReference((PsiClassReferenceType)classType);
            }
            for (PsiType parameter : parameters2 = classType.getParameters()) {
                parameter.accept((PsiTypeVisitor)this);
            }
            return null;
        }

        @Nullable
        public final Void visitArrayType(@NotNull PsiArrayType arrayType) {
            if (arrayType == null) {
                ClassReferenceVisitor.$$$reportNull$$$0(1);
            }
            PsiType type = arrayType.getComponentType();
            type.accept((PsiTypeVisitor)this);
            return null;
        }

        public abstract void visitClassReference(@NotNull PsiClassReferenceType var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayType";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/databinding/util/DataBindingUtil$ClassReferenceVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArrayType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

