/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ScreenRecorderOptions;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractDeviceAction;
import com.android.tools.idea.ddms.actions.CachedFeatures;
import com.android.tools.idea.ddms.actions.Features;
import com.android.tools.idea.ddms.actions.ScreenRecorderTask;
import com.android.tools.idea.ddms.screenrecord.ScreenRecorderOptionsDialog;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import icons.AndroidIcons;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScreenRecorderAction
extends AbstractDeviceAction {
    static final String REMOTE_PATH = "/sdcard/ddmsrec.mp4";
    static final String TITLE = "Screen Recorder";
    private static final String EMU_TMP_FILENAME = "tmp.webm";
    private final Features myFeatures;
    private final Project myProject;

    public ScreenRecorderAction(@NotNull Project project, @NotNull DeviceContext context) {
        if (project == null) {
            ScreenRecorderAction.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ScreenRecorderAction.$$$reportNull$$$0(1);
        }
        this(project, context, new CachedFeatures((Disposable)project));
    }

    @VisibleForTesting
    ScreenRecorderAction(@NotNull Project project, @NotNull DeviceContext context, @NotNull Features features) {
        if (project == null) {
            ScreenRecorderAction.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ScreenRecorderAction.$$$reportNull$$$0(3);
        }
        if (features == null) {
            ScreenRecorderAction.$$$reportNull$$$0(4);
        }
        super(context, AndroidBundle.message("android.ddms.actions.screenrecord", new Object[0]), AndroidBundle.message("android.ddms.actions.screenrecord.description", new Object[0]), AndroidIcons.Ddms.ScreenRecorder);
        this.myFeatures = features;
        this.myProject = project;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ScreenRecorderAction.$$$reportNull$$$0(5);
        }
        Presentation presentation = event.getPresentation();
        if (!this.isEnabled()) {
            presentation.setEnabled(false);
            presentation.setText(AndroidBundle.messagePointer("android.ddms.actions.screenrecord", new Object[0]));
            return;
        }
        IDevice device = this.myDeviceContext.getSelectedDevice();
        if (this.myFeatures.watch(device)) {
            presentation.setEnabled(false);
            presentation.setText("Screen Record Is Unavailable for Wear OS");
            return;
        }
        presentation.setEnabled(this.myFeatures.screenRecord(device));
        presentation.setText(AndroidBundle.messagePointer("android.ddms.actions.screenrecord", new Object[0]));
    }

    @Override
    protected void performAction(final @NotNull IDevice device) {
        ScreenRecorderOptionsDialog dialog2;
        if (device == null) {
            ScreenRecorderAction.$$$reportNull$$$0(6);
        }
        if (!(dialog2 = new ScreenRecorderOptionsDialog(this.myProject)).showAndGet()) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Starting Screen Recording..."){
            private boolean myShowTouchEnabled;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.myShowTouchEnabled = ScreenRecorderAction.isShowTouchEnabled(device);
            }

            public void onSuccess() {
                ScreenRecorderAction.this.startRecordingAsync(dialog2, device, this.myShowTouchEnabled);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/ddms/actions/ScreenRecorderAction$1", "run"));
            }
        });
    }

    private void startRecordingAsync(@NotNull ScreenRecorderOptionsDialog dialog2, @NotNull IDevice device, boolean showTouchEnabled) {
        if (dialog2 == null) {
            ScreenRecorderAction.$$$reportNull$$$0(7);
        }
        if (device == null) {
            ScreenRecorderAction.$$$reportNull$$$0(8);
        }
        ScreenRecorderOptions options = dialog2.getOptions();
        CountDownLatch latch = new CountDownLatch(1);
        CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
        AvdManager manager = ScreenRecorderAction.getVirtualDeviceManager();
        Path hostRecordingFileName = manager == null ? null : this.getTemporaryVideoPathForVirtualDevice(device, manager);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (options.showTouches != showTouchEnabled) {
                ScreenRecorderAction.setShowTouch(device, options.showTouches);
            }
            try {
                if (hostRecordingFileName != null) {
                    EmulatorConsole console = EmulatorConsole.getConsole((IDevice)device);
                    if (console != null) {
                        console.startEmulatorScreenRecording(ScreenRecorderAction.getEmulatorScreenRecorderOptions(hostRecordingFileName, options));
                    }
                } else {
                    device.startScreenRecorder(REMOTE_PATH, options, (IShellOutputReceiver)receiver);
                }
            }
            catch (Exception e) {
                ScreenRecorderAction.showError(this.myProject, "Unexpected error while launching screen recorder", e);
                latch.countDown();
            }
            finally {
                if (options.showTouches != showTouchEnabled) {
                    ScreenRecorderAction.setShowTouch(device, showTouchEnabled);
                }
            }
        });
        ScreenRecorderTask screenRecorderShellTask = new ScreenRecorderTask(this.myProject, device, latch, receiver, hostRecordingFileName);
        screenRecorderShellTask.setCancelText("Stop Recording");
        screenRecorderShellTask.queue();
    }

    @Nullable
    private static AvdManager getVirtualDeviceManager() {
        Logger logger2 = Logger.getInstance(ScreenRecorderAction.class);
        try {
            return AvdManager.getInstance((AndroidSdkHandler)AndroidSdks.getInstance().tryToChooseSdkHandler(), (ILogger)new LogWrapper(logger2));
        }
        catch (AndroidLocation.AndroidLocationException exception) {
            logger2.warn((Throwable)exception);
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    Path getTemporaryVideoPathForVirtualDevice(@NotNull IDevice device, @NotNull AvdManager manager) {
        if (device == null) {
            ScreenRecorderAction.$$$reportNull$$$0(9);
        }
        if (manager == null) {
            ScreenRecorderAction.$$$reportNull$$$0(10);
        }
        if (!this.myFeatures.screenRecord(device)) {
            return null;
        }
        AvdInfo virtualDevice = manager.getAvd(device.getAvdName(), true);
        if (virtualDevice == null) {
            return null;
        }
        return Paths.get(virtualDevice.getDataFolderPath(), EMU_TMP_FILENAME);
    }

    private static void setShowTouch(@NotNull IDevice device, boolean isEnabled) {
        if (device == null) {
            ScreenRecorderAction.$$$reportNull$$$0(11);
        }
        int value2 = isEnabled ? 1 : 0;
        try {
            device.executeShellCommand("settings put system show_touches " + value2, (IShellOutputReceiver)new NullOutputReceiver());
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            Logger.getInstance(ScreenRecorderAction.class).warn("Failed to set show taps to " + isEnabled, e);
        }
    }

    private static boolean isShowTouchEnabled(@NotNull IDevice device) {
        if (device == null) {
            ScreenRecorderAction.$$$reportNull$$$0(12);
        }
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        try {
            device.executeShellCommand("settings get system show_touches", (IShellOutputReceiver)receiver);
            String output = receiver.getOutput();
            return output.equals("1");
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            Logger.getInstance(ScreenRecorderAction.class).warn("Failed to retrieve setting", e);
            return false;
        }
    }

    @VisibleForTesting
    static String getEmulatorScreenRecorderOptions(@NotNull Path filePath, @NotNull ScreenRecorderOptions options) {
        if (filePath == null) {
            ScreenRecorderAction.$$$reportNull$$$0(13);
        }
        if (options == null) {
            ScreenRecorderAction.$$$reportNull$$$0(14);
        }
        StringBuilder sb = new StringBuilder();
        if (options.width > 0 && options.height > 0) {
            sb.append("--size ");
            sb.append(options.width);
            sb.append('x');
            sb.append(options.height);
            sb.append(' ');
        }
        if (options.bitrateMbps > 0) {
            sb.append("--bit-rate ");
            sb.append(options.bitrateMbps * 1000000);
            sb.append(' ');
        }
        if (options.timeLimit > 0L) {
            sb.append("--time-limit ");
            long seconds = TimeUnit.SECONDS.convert(options.timeLimit, options.timeLimitUnits);
            if (seconds > 180L) {
                seconds = 180L;
            }
            sb.append(seconds);
            sb.append(' ');
        }
        sb.append(filePath);
        return sb.toString();
    }

    static void showError(@Nullable Project project, @NotNull String message2, @Nullable Throwable throwable) {
        if (message2 == null) {
            ScreenRecorderAction.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Object msg = message2;
            if (throwable != null) {
                msg = (String)msg + (String)(throwable.getLocalizedMessage() != null ? ": " + throwable.getLocalizedMessage() : "");
            }
            Messages.showErrorDialog((Project)project, (String)msg, (String)TITLE);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "features";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/ddms/actions/ScreenRecorderAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "performAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "startRecordingAsync";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getTemporaryVideoPathForVirtualDevice";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "setShowTouch";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isShowTouchEnabled";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getEmulatorScreenRecorderOptions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "showError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

