/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.ddmlib.BitmapDecoder;
import com.google.common.collect.ImmutableList;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BitmapEvaluatorProvider
implements BitmapDecoder.BitmapDataProvider {
    private static final int MAX_DIMENSION = 1024;
    @NotNull
    private EvaluationContextImpl myEvaluationContext;
    @NotNull
    private ObjectReference myBitmap;

    public BitmapEvaluatorProvider(@NotNull Value bitmap, @NotNull EvaluationContextImpl evaluationContext) {
        if (bitmap == null) {
            BitmapEvaluatorProvider.$$$reportNull$$$0(0);
        }
        if (evaluationContext == null) {
            BitmapEvaluatorProvider.$$$reportNull$$$0(1);
        }
        this.myEvaluationContext = evaluationContext;
        String fqcn = bitmap.type().name();
        if ("android.graphics.drawable.BitmapDrawable".equals(fqcn)) {
            Value actualBitmap = this.getBitmapFromDrawable((ObjectReference)bitmap);
            if (actualBitmap == null) {
                throw new RuntimeException("Unable to obtain bitmap from drawable");
            }
            this.myBitmap = (ObjectReference)actualBitmap;
        } else {
            if (!"android.graphics.Bitmap".equals(fqcn)) {
                throw new RuntimeException("Invalid parameter passed into method");
            }
            this.myBitmap = (ObjectReference)bitmap;
        }
    }

    @Nullable
    public String getBitmapConfigName() throws EvaluateException {
        Value config = this.getBitmapConfig();
        if (!(config instanceof ObjectReference)) {
            return null;
        }
        Field f = ((ObjectReference)config).referenceType().fieldByName("name");
        if (f == null) {
            return null;
        }
        return ((ObjectReference)config).getValue(f).toString();
    }

    @Nullable
    public Dimension getDimension() throws EvaluateException {
        DebugProcessImpl debugProcess = this.myEvaluationContext.getDebugProcess();
        Integer w = this.getImageDimension(debugProcess, "getWidth");
        Integer h = this.getImageDimension(debugProcess, "getHeight");
        return w != null & h != null ? new Dimension(w, h) : null;
    }

    public boolean downsizeBitmap(@NotNull Dimension currentDimensions) throws EvaluateException {
        Value filter2;
        Value dstHeight;
        if (currentDimensions == null) {
            BitmapEvaluatorProvider.$$$reportNull$$$0(2);
        }
        DebugProcessImpl debugProcess = this.myEvaluationContext.getDebugProcess();
        Method createScaledBitmapMethod = DebuggerUtils.findMethod((ReferenceType)this.myBitmap.referenceType(), (String)"createScaledBitmap", (String)"(Landroid/graphics/Bitmap;IIZ)Landroid/graphics/Bitmap;");
        if (createScaledBitmapMethod == null) {
            return false;
        }
        double s = Math.max(currentDimensions.getHeight(), currentDimensions.getWidth()) / 1024.0;
        VirtualMachineProxyImpl vm = this.myEvaluationContext.getDebugProcess().getVirtualMachineProxy();
        Value dstWidth = DebuggerUtilsEx.createValue((VirtualMachineProxyImpl)vm, (String)"int", (long)((int)(currentDimensions.getWidth() / s)));
        Value result2 = debugProcess.invokeMethod((EvaluationContext)this.myEvaluationContext, this.myBitmap, createScaledBitmapMethod, Arrays.asList(this.myBitmap, dstWidth, dstHeight = DebuggerUtilsEx.createValue((VirtualMachineProxyImpl)vm, (String)"int", (long)((int)(currentDimensions.getHeight() / s))), filter2 = DebuggerUtilsEx.createValue((VirtualMachineProxyImpl)vm, (String)"boolean", (boolean)Boolean.FALSE)));
        if (result2 != null) {
            this.myBitmap = (ObjectReference)result2;
        }
        return result2 != null;
    }

    @Nullable
    public byte[] getPixelBytes(@NotNull Dimension size) throws Exception {
        List<Value> pixelValues;
        Field bufferField;
        if (size == null) {
            BitmapEvaluatorProvider.$$$reportNull$$$0(3);
        }
        if ((bufferField = this.myBitmap.referenceType().fieldByName("mBuffer")) != null) {
            Value bufferValue = this.myBitmap.getValue(bufferField);
            if (!(bufferValue instanceof ArrayReference)) {
                throw new RuntimeException("Image Buffer is not an array");
            }
            pixelValues = ((ArrayReference)bufferValue).getValues();
        } else {
            pixelValues = this.copyToBuffer(size);
            if (pixelValues == null) {
                throw new RuntimeException("Unable to extract image data: Bitmap has no buffer field.");
            }
        }
        byte[] argb = new byte[pixelValues.size()];
        for (int i2 = 0; i2 < pixelValues.size(); ++i2) {
            Value pixelValue = pixelValues.get(i2);
            if (!(pixelValue instanceof ByteValue)) continue;
            argb[i2] = ((ByteValue)pixelValue).byteValue();
        }
        return argb;
    }

    @Nullable
    private Value getBitmapConfig() throws EvaluateException {
        DebugProcessImpl debugProcess = this.myEvaluationContext.getDebugProcess();
        Method getConfig = DebuggerUtils.findMethod((ReferenceType)this.myBitmap.referenceType(), (String)"getConfig", (String)"()Landroid/graphics/Bitmap$Config;");
        if (getConfig == null) {
            return null;
        }
        return debugProcess.invokeMethod((EvaluationContext)this.myEvaluationContext, this.myBitmap, getConfig, Collections.emptyList());
    }

    @Nullable
    private Integer getImageDimension(@NotNull DebugProcessImpl debugProcess, @NotNull String methodName) throws EvaluateException {
        Value widthValue;
        Method method;
        if (debugProcess == null) {
            BitmapEvaluatorProvider.$$$reportNull$$$0(4);
        }
        if (methodName == null) {
            BitmapEvaluatorProvider.$$$reportNull$$$0(5);
        }
        if ((method = DebuggerUtils.findMethod((ReferenceType)this.myBitmap.referenceType(), (String)methodName, (String)"()I")) != null && (widthValue = debugProcess.invokeMethod((EvaluationContext)this.myEvaluationContext, this.myBitmap, method, Collections.emptyList())) instanceof IntegerValue) {
            return ((IntegerValue)widthValue).value();
        }
        return null;
    }

    @Nullable
    private List<Value> copyToBuffer(@NotNull Dimension size) throws EvaluateException {
        DebugProcessImpl debugProcess;
        VirtualMachineProxyImpl virtualMachineProxy;
        List classes2;
        if (size == null) {
            BitmapEvaluatorProvider.$$$reportNull$$$0(6);
        }
        if ((classes2 = (virtualMachineProxy = (debugProcess = this.myEvaluationContext.getDebugProcess()).getVirtualMachineProxy()).classesByName("byte[]")).size() != 1 || !(classes2.get(0) instanceof ArrayType)) {
            return null;
        }
        ArrayType byteArrayType = (ArrayType)classes2.get(0);
        classes2 = virtualMachineProxy.classesByName("java.nio.ByteBuffer");
        if (classes2.size() != 1 || !(classes2.get(0) instanceof ClassType)) {
            return null;
        }
        ClassType byteBufferType = (ClassType)classes2.get(0);
        Method wrapMethod = DebuggerUtils.findMethod((ReferenceType)byteBufferType, (String)"wrap", (String)"([B)Ljava/nio/ByteBuffer;");
        if (wrapMethod == null) {
            return null;
        }
        ArrayReference byteArray = byteArrayType.newInstance(size.width * size.height * 4);
        Value byteBufferRef = debugProcess.invokeMethod((EvaluationContext)this.myEvaluationContext, byteBufferType, wrapMethod, (List)ImmutableList.of((Object)byteArray));
        Method copyToBufferMethod = DebuggerUtils.findMethod((ReferenceType)this.myBitmap.referenceType(), (String)"copyPixelsToBuffer", (String)"(Ljava/nio/Buffer;)V");
        if (copyToBufferMethod == null) {
            return null;
        }
        debugProcess.invokeMethod((EvaluationContext)this.myEvaluationContext, this.myBitmap, copyToBufferMethod, (List)ImmutableList.of((Object)byteBufferRef));
        return byteArray.getValues();
    }

    @Nullable
    private Value getBitmapFromDrawable(@NotNull ObjectReference bitmapDrawable) {
        if (bitmapDrawable == null) {
            BitmapEvaluatorProvider.$$$reportNull$$$0(7);
        }
        try {
            DebugProcessImpl debugProcess = this.myEvaluationContext.getDebugProcess();
            Method getBitmapMethod = DebuggerUtils.findMethod((ReferenceType)bitmapDrawable.referenceType(), (String)"getBitmap", (String)"()Landroid/graphics/Bitmap;");
            if (getBitmapMethod == null) {
                return null;
            }
            return debugProcess.invokeMethod((EvaluationContext)this.myEvaluationContext, bitmapDrawable, getBitmapMethod, Collections.emptyList());
        }
        catch (EvaluateException ignored) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bitmap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentDimensions";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bitmapDrawable";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/debug/BitmapEvaluatorProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "downsizeBitmap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPixelBytes";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getImageDimension";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "copyToBuffer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getBitmapFromDrawable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

