/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.util.ListenerCollection;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class LastActionTracker
implements Disposable,
AnActionListener {
    private final ListenerCollection<Listener> myListeners = ListenerCollection.createWithDirectExecutor();
    private String myCurrentActionId = "(no action)";
    private long myCurrentActionStartNano;

    public LastActionTracker() {
        ActionManager.getInstance().addAnActionListener((AnActionListener)this);
    }

    public void registerActionDurationListener(Listener listener2) {
        this.myListeners.add(listener2);
    }

    public String getCurrentActionId() {
        return this.myCurrentActionId;
    }

    public long getCurrentDurationMs() {
        if (this.myCurrentActionStartNano != 0L) {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.myCurrentActionStartNano);
        }
        return 0L;
    }

    public void unregisterActionDurationListener(Listener listener2) {
        this.myListeners.remove(listener2);
    }

    public void dispose() {
        ActionManager.getInstance().removeAnActionListener((AnActionListener)this);
    }

    public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        String actionId;
        if (action2 == null) {
            LastActionTracker.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            LastActionTracker.$$$reportNull$$$0(1);
        }
        if (event == null) {
            LastActionTracker.$$$reportNull$$$0(2);
        }
        this.myCurrentActionId = actionId = LastActionTracker.getActionId(action2);
        this.myCurrentActionStartNano = System.nanoTime();
        this.myListeners.forEach(l -> l.actionStarted(actionId));
    }

    private static String getActionId(AnAction action2) {
        if (action2 == null) {
            return "<null>";
        }
        return action2.getClass().getName() + " (" + ActionManager.getInstance().getId(action2) + ")";
    }

    public void afterActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (action2 == null) {
            LastActionTracker.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            LastActionTracker.$$$reportNull$$$0(4);
        }
        if (event == null) {
            LastActionTracker.$$$reportNull$$$0(5);
        }
        String actionId = LastActionTracker.getActionId(action2);
        this.myListeners.forEach(l -> l.actionFinished(actionId, this.getCurrentDurationMs()));
        this.myCurrentActionId = "(no action)";
        this.myCurrentActionStartNano = 0L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/diagnostics/LastActionTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeActionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "afterActionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener {
        public void actionStarted(String var1);

        public void actionFinished(String var1, long var2);
    }
}

